'============================================================================'
'                                                                            '
' Visual Basic global constant file.  This file can be loaded into the       '
' global module.                                                             '
'                                                                            '
' Some constants are commented out because they have duplicates (for         '
' example, NONE appears in several places).                                  '
'                                                                            '
'============================================================================'

'========='
'         '
' General '
'         '
'========='

' Booleans
Global Const TRUE = -1
Global Const FALSE = 0
Global Const NULL = 0
'Global Const CRLF = Chr$(10) + Chr$(13)

'=================='
'                  '
' Event parameters '
'                  '
'=================='

' Button and Shift (KeyDown, KeyUp, MouseDown, MouseMove, MouseUp)
Global Const SHIFT_MASK = 1
Global Const CTRL_MASK = 2
Global Const ALT_MASK = 4
Global Const LEFT_BUTTON = 1
Global Const RIGHT_BUTTON = 2
Global Const MIDDLE_BUTTON = 4

' ErrNum (LinkError)
Global Const WRONG_FORMAT = 1
Global Const REQUEST_WITHOUT_INIT = 2
Global Const DDE_WITHOUT_INIT = 3
Global Const ADVISE_WITHOUT_INIT = 4
Global Const POKE_WITHOUT_INIT = 5
Global Const DDE_SERVER_CLOSED = 6
Global Const TOO_MANY_LINKS = 7
Global Const STRING_TOO_LONG = 8
Global Const INVALID_CONTROL_ARRAY_REFERENCE = 9
Global Const UNEXPECTED_DDE = 10
Global Const OUT_OF_MEMORY = 11
Global Const SERVER_ATTEMPTED_CLIENT_OPERATION = 12


' State (DragOver)
Global Const ENTER = 0
Global Const LEAVE = 1
Global Const OVER = 2

'====================='
'                     '
' Function parameters '
'                     '
'====================='

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed


'==================='
'                   '
' Method parameters '
'                   '
'==================='

' Drag (controls)
Global Const CANCEL = 0
Global Const BEGIN_DRAG = 1
Global Const END_DRAG = 2

' GetData, GetFormat, SetData (Clipboard)
Global Const CF_LINK = &HBF00
Global Const CF_TEXT = 1
Global Const CF_BITMAP = 2
Global Const CF_METAFILE = 3
Global Const CF_DIB = 8

' Show (form)
Global Const MODAL = 1
Global Const MODELESS = 0

'================='
'                 '
' Property values '
'                 '
'================='

' Alignment (label)
Global Const LEFT_JUSTIFY = 0          ' 0 - Left Justify
Global Const RIGHT_JUSTIFY = 1         ' 1 - Right Justify
Global Const CENTER = 2                ' 2 - Center

' BackColor, ForeColor, FillColor (standard RGB colors: form, controls)
Global Const BLACK = &H0&
Global Const RED = &HFF&
Global Const GREEN = &HFF00&
Global Const YELLOW = &HFFFF&
Global Const BLUE = &HFF0000
Global Const MAGENTA = &HFF00FF
Global Const CYAN = &HFFFF00
Global Const WHITE = &HFFFFFF
Global Const DARKGREY = &H808080

' BackColor, ForeColor, FillColor (system colors: form, controls)
Global Const SCROLL_BARS = &H80000000           ' Scroll-bars gray area.
Global Const DESKTOP = &H80000001               ' Desktop.
Global Const ACTIVE_TITLE_BAR = &H80000002      ' Active window caption.
Global Const INACTIVE_TITLE_BAR = &H80000003    ' Inactive window caption.
Global Const MENU_BAR = &H80000004              ' Menu background.
Global Const WINDOW_BACKGROUND = &H80000005     ' Window background.
Global Const WINDOW_FRAME = &H80000006          ' Window frame.
Global Const MENU_TEXT = &H80000007             ' Text in menus.
Global Const WINDOW_TEXT = &H80000008           ' Text in windows.
Global Const TITLE_BAR_TEXT = &H80000009        ' Text in caption, size box, scroll-bar arrow box..
Global Const ACTIVE_BORDER = &H8000000A         ' Active window border.
Global Const INACTIVE_BORDER = &H8000000B       ' Inactive window border.
Global Const APPLICATION_WORKSPACE = &H8000000C ' Background color of multiple document interface (MDI) applications.
Global Const HIGHLIGHT = &H8000000D             ' Items selected item in a control.
Global Const HIGHLIGHT_TEXT = &H8000000E        ' Text of item selected in a control.
Global Const BUTTON_FACE = &H8000000F           ' Face shading on command buttons.
Global Const BUTTON_SHADOW = &H80000010         ' Edge shading on command buttons.
Global Const GRAY_TEXT = &H80000011             ' Grayed (disabled) text.  This color is set to 0 if the current display driver does not support a solid gray color.
Global Const BUTTON_TEXT = &H80000012           ' Text on push buttons.

' BorderStyle (form, label, picture box, text box)
Global Const NONE = 0                  ' 0 - None
Global Const FIXED_SINGLE = 1          ' 1 - Fixed Single
Global Const SIZABLE = 2               ' 2 - Sizable (Forms only)
Global Const FIXED_DOUBLE = 3          ' 3 - Fixed Double (Forms only)

' DragMode (controls)
Global Const MANUAL = 0                ' 0 - Manual
Global Const AUTOMATIC = 1             ' 1 - Automatic

' DrawMode (form, picture box, Printer)
Global Const BLACKNESS = 1             ' 1 - Blackness
Global Const NOT_MERGE_PEN = 2         ' 2 - Not Merge Pen
Global Const MASK_NOT_PEN = 3          ' 3 - Mask Not Pen
Global Const NOT_COPY_PEN = 4          ' 4 - Not Copy Pen
Global Const MASK_PEN_NOT = 5          ' 5 - Mask Pen Not
Global Const INVERT = 6                ' 6 - Invert
Global Const XOR_PEN = 7               ' 7 - Xor Pen
Global Const NOT_MASK_PEN = 8          ' 8 - Not Mask Pen
Global Const MASK_PEN = 9              ' 9 - Mask Pen
Global Const NOT_XOR_PEN = 10          ' 10 - Not Xor Pen
Global Const NOP = 11                  ' 11 - Nop
Global Const MERGE_NOT_PEN = 12        ' 12 - Merge Not Pen
Global Const COPY_PEN = 13             ' 13 - Copy Pen
Global Const MERGE_PEN_NOT = 14        ' 14 - Merge Pen Not
Global Const MERGE_PEN = 15            ' 15 - Merge Pen
Global Const WHITENESS = 16            ' 16 - Whiteness

' DrawStyle (form, picture box, Printer)
Global Const SOLID = 0                 ' 0 - Solid
Global Const DASH = 1                  ' 1 - Dash
Global Const DOT = 2                   ' 2 - Dot
Global Const DASH_DOT = 3              ' 3 - Dash-Dot
Global Const DASH_DOT_DOT = 4          ' 4 - Dash-Dot-Dot
Global Const INVISIBLE = 5             ' 5 - Invisible
Global Const INSIDE_SOLID = 6          ' 6 - Inside Solid

' FillStyle (form, picture box, Printer)
' Global Const SOLID = 0               ' 0 - Solid
Global Const TRANSPARENT = 1           ' 1 - Transparent
Global Const HORIZONTAL_LINE = 2       ' 2 - Horizontal Line
Global Const VERTICAL_LINE = 3         ' 3 - Vertical Line
Global Const UPWARD_DIAGONAL = 4       ' 4 - Upward Diagonal
Global Const DOWNWARD_DIAGONAL = 5     ' 5 - Downward Diagonal
Global Const CROSS = 6                 ' 6 - Cross
Global Const DIAGONAL_CROSS = 7        ' 7 - Diagonal Cross

' LinkMode (controls)
' Global Const NONE = 0                ' 0 - None
Global Const HOT = 1                   ' 1 - Hot
Global Const COLD = 2                  ' 2 - Cold

' LinkMode (form)
' Global Const NONE = 0                ' 0 - None
Global Const SERVER = 1                ' 1 - Server

' MousePointer (form, controls)
Global Const DEFAULT = 0               ' 0 - Default
Global Const ARROW = 1                 ' 1 - Arrow
Global Const CROSSHAIR = 2             ' 2 - Cross
Global Const IBEAM = 3                 ' 3 - I-Beam
Global Const ICON_POINTER = 4          ' 4 - Icon
Global Const SIZE_POINTER = 5          ' 5 - Size
Global Const SIZE_NE_SW = 6            ' 6 - Size NE SW
Global Const SIZE_N_S = 7              ' 7 - Size N S
Global Const SIZE_NW_SE = 8            ' 8 - Size NW SE
Global Const SIZE_W_E = 9              ' 9 - Size W E
Global Const UP_ARROW = 10             ' 10 - Up Arrow
Global Const HOURGLASS = 11            ' 11 - Hourglass
Global Const NO_DROP = 12              ' 12 - No drop

' ScaleMode (form, picture box, Printer)
Global Const USER = 0                  ' 0 - User
Global Const TWIPS = 1                 ' 1 - Twip
Global Const POINTS = 2                ' 2 - Point
Global Const PIXELS = 3                ' 3 - Pixel
Global Const CHARACTERS = 4            ' 4 - Character
Global Const INCHES = 5                ' 5 - Inch
Global Const MILLIMETERS = 6           ' 6 - Millimeter
Global Const CENTIMETERS = 7           ' 7 - Centimeter

' ScrollBar (text box)
' Global Const NONE = 0                ' 0 - None
Global Const HORIZONTAL = 1            ' 1 - Horizontal
Global Const VERTICAL = 2              ' 2 - Vertical
Global Const BOTH = 3                  ' 3 - Both

' Value (check box)
Global Const UNCHECKED = 0             ' 0 - Unchecked
Global Const CHECKED = 1               ' 1 - Checked
Global Const GRAYED = 2                ' 2 - Grayed

' WindowState (form)
Global Const NORMAL = 0                ' 0 - Normal
Global Const MINIMIZED = 1             ' 1 - Minimized
Global Const MAXIMIZED = 2             ' 2 - Maximized

' WindowStyle (shell)
Global Const NORMAL_WITH_FOCUS = 1
Global Const MIN_WITH_FOCUS = 2
Global Const MAX_WITH_FOCUS = 3
Global Const NORMAL_NO_FOCUS = 4
Global Const MIN_NO_FOCUS = 7

'******************************************************
'           DLL Declarations                          *
'******************************************************
Type POINTAPI
    x As Integer
    y As Integer
End Type

Declare Function LoadMenu Lib "User" (ByVal hInstance As Integer, ByVal lpString As String) As Integer
Declare Function GetMenu Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function SetMenu Lib "User" (ByVal hWnd As Integer, ByVal hMenu As Integer) As Integer
Declare Function HiliteMenuItem Lib "User" (ByVal hWnd As Integer, ByVal hMenu As Integer, ByVal wIDHiliteItem As Integer, ByVal wHilite As Integer) As Integer
Declare Function GetMenuString Lib "User" (ByVal hMenu As Integer, ByVal wIDItem As Integer, ByVal lpString As String, ByVal nMaxCount As Integer, ByVal wFlag As Integer) As Integer
Declare Function GetMenuState Lib "User" (ByVal hMenu As Integer, ByVal wId As Integer, ByVal wFlags As Integer) As Integer
Declare Sub DrawMenuBar Lib "User" (ByVal hWnd As Integer)
Declare Function GetSystemMenu Lib "User" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
Declare Function GetSubMenu Lib "User" (ByVal hMenu As Integer, ByVal nPos As Integer) As Integer
Declare Function GetMenuItemID Lib "User" (ByVal hMenu As Integer, ByVal nPos As Integer) As Integer
Declare Function GetMenuItemCount Lib "User" (ByVal hMenu As Integer) As Integer
Declare Function TrackPopupMenu Lib "User" (ByVal hMenu As Integer, ByVal wFlags As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nReserved As Integer, ByVal hWnd As Integer, lpReserved As Any) As Integer
Declare Function InsertMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpNewItem As Any) As Integer
Declare Function AppendMenu Lib "User" (ByVal hMenu As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpNewItem As Any) As Integer
Declare Function ModifyMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpString As Any) As Integer
Declare Function RemoveMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
Declare Function DeleteMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
 
Declare Function ExitWindows Lib "User" (ByVal dwReserved As Long, wReturnCode) As Integer
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Function GetActiveWindow Lib "User" () As Integer
Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer
Declare Function GetFocus Lib "User" () As Integer
Declare Function SetActiveWindow Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function GetModuleHandle Lib "Kernel" (ByVal lpModuleName As String) As Integer
Declare Function GetModuleFileName Lib "Kernel" (ByVal hModule As Integer, ByVal lpFilename As String, ByVal nSize As Integer) As Integer
Declare Function GetFreeSpace Lib "Kernel" (ByVal wFlags As Integer) As Long

'Indices for GetSystemMetrics
Global Const SM_CXSIZE = 30
Global Const SM_CYSIZE = 31

'Indices for GetDeviceCaps
Global Const HORZRES = 8    '  Horizontal width in pixels
Global Const VERTRES = 10   '  Vertical width in pixels

'Menu flags for Add/Check/EnableMenuItem()
Global Const MF_INSERT = &H0
Global Const MF_CHANGE = &H80
Global Const MF_APPEND = &H100
Global Const MF_DELETE = &H200
Global Const MF_REMOVE = &H1000

Global Const MF_BYCOMMAND = &H0
Global Const MF_BYPOSITION = &H400

Global Const MF_SEPARATOR = &H800

Global Const MF_ENABLED = &H0
Global Const MF_GRAYED = &H1
Global Const MF_DISABLED = &H2

Global Const MF_UNCHECKED = &H0
Global Const MF_CHECKED = &H8
Global Const MF_USECHECKBITMAPS = &H200

Global Const MF_STRING = &H0
Global Const MF_BITMAP = &H4
Global Const MF_OWNERDRAW = &H100

Global Const MF_POPUP = &H10
Global Const MF_MENUBARBREAK = &H20
Global Const MF_MENUBREAK = &H40

Global Const MF_UNHILITE = &H0
Global Const MF_HILITE = &H80

Global Const MF_SYSMENU = &H2000
Global Const MF_HELP = &H4000
Global Const MF_MOUSESELECT = &H8000

'  Menu item resource format
Type MENUITEMTEMPLATEHEADER
    versionNumber As Integer
    offset As Integer
End Type

Type MENUITEMTEMPLATE
    mtOption As Integer
    mtID As Integer
    mtString As Long
End Type

Global Const MF_END = &H80

'  System Menu Command Values
Global Const SC_SIZE = &HF000
Global Const SC_MOVE = &HF010
Global Const SC_MINIMIZE = &HF020
Global Const SC_MAXIMIZE = &HF030
Global Const SC_NEXTWINDOW = &HF040
Global Const SC_PREVWINDOW = &HF050
Global Const SC_CLOSE = &HF060
Global Const SC_VSCROLL = &HF070
Global Const SC_HSCROLL = &HF080
Global Const SC_MOUSEMENU = &HF090
Global Const SC_KEYMENU = &HF100
Global Const SC_ARRANGE = &HF110
Global Const SC_RESTORE = &HF120
Global Const SC_TASKLIST = &HF130

'******************************************************
'*          OpenFile Modes                            *
'******************************************************
Global Const REPLACEFILE = 0
Global Const READFILE = 1
Global Const APPENDFILE = 2
Global Const RANDOMFILE = 3
Global Const BINARYFILE = 4


'******************************************************
'           Tool Box Globals                          *
'******************************************************

'Command Path and Icon Path Of Property Form
Global CommandPath As String
Global IconPath As String

'Command Path and Icon Path of Browser Form
Global BrowseCmdPath As String
Global BrowseIconPath As String

'Flag to notify Browser that it is being used by Run
Global UseFormForRun As Integer

'Definition of record type for .ini file
Type ToolSetRecord
    CmdFile As String * 80
    IconFile As String * 80
End Type


