DefInt A-Z

Declare Function todGetModuleUsage Lib "Kernel" Alias "GetModuleUsage" (ByVal hModule As Integer) As Integer
Declare Function todGetPrivateProfileString Lib "Kernel" Alias "GetPrivateProfileString" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFilename As String) As Integer
Declare Function todEnableWindow Lib "User" Alias "EnableWindow" (ByVal hWnd As Integer, ByVal aBOOL As Integer) As Integer
Declare Function todIsWindowEnabled Lib "User" Alias "IsWindowEnabled" (ByVal hWnd As Integer) As Integer

Sub ShowTipsOfTheDay (TipINIFile$, mode As Integer)
    
    On Error Resume Next

    screen.MousePointer = 11

    Dim TOD As String       'name of this applet, TOD.EXE
    Dim inistring As String 'access TODs INI
    Dim retval              '   "     "   "

    'make sure INI file is there
    If TipINIFile$ = "" Then Exit Sub
    If Len(Dir$(TipINIFile$)) = 0 Then Exit Sub
    
    'see how to run TOD
    inistring$ = Space$(16)
    retval = todGetPrivateProfileString("TOD PREFS", "Show At Startup", "", inistring$, Len(inistring$), TipINIFile$)
    If Val(Left(inistring$, retval)) <> 0 Then
        'default is run TOD
    ElseIf mode <> True Then 'if not forcing then exit
        Exit Sub
    End If
    
    'build TOD command string (including, the INI file to run)
    If Right$(App.Path, 1) = "\" Then
        TOD = App.Path + "TOD.EXE "
    Else
        TOD = App.Path + "\TOD.EXE "
    End If
    TOD = TOD + TipINIFile$
    
    'run TOD
    hModTod = Shell(TOD, 1)
    
    'make TOD "modal"
    ReDim FormState(Forms.Count)
    For i = 0 To Forms.Count - 1'disable all enabled windows of this app
        FormState(i) = todIsWindowEnabled(Forms(i).hWnd)
        result = todEnableWindow(Forms(i).hWnd, False)
    Next
    screen.MousePointer = 0
    While todGetModuleUsage(hModTod) > 0'wait while TOD runs
        DoEvents
    Wend
    For i = 0 To Forms.Count - 1'restore window states
        result = todEnableWindow(Forms(i).hWnd, FormState(i))
    Next
    
    screen.ActiveForm.ZOrder

End Sub

