VERSION 2.00
Begin Form form1 
   Caption         =   "Form2"
   ClientHeight    =   2610
   ClientLeft      =   1260
   ClientTop       =   735
   ClientWidth     =   4935
   Height          =   3015
   Left            =   1200
   LinkTopic       =   "Form2"
   ScaleHeight     =   2610
   ScaleWidth      =   4935
   Top             =   390
   Width           =   5055
   Begin TList TList2 
      BackColor       =   &H00FFFFFF&
      DragIcon        =   DRAGDROP.FRX:0000
      ForeColor       =   &H00000000&
      Height          =   2295
      ItemImageDefHeight=   225
      ItemImageDefWidth=   225
      Left            =   3300
      SelBackColor    =   &H00800000&
      SelForeColor    =   &H00FFFFFF&
      ShiftStep       =   300
      ShowChildren    =   0   'False
      TabIndex        =   1
      TabStopDistance =   0
      Top             =   360
      Width           =   1515
      WidthOfText     =   0
   End
   Begin TList tlist1 
      BackColor       =   &H00FFFFFF&
      DragIcon        =   DRAGDROP.FRX:0302
      ForeColor       =   &H00000000&
      Height          =   2235
      ItemImageDefHeight=   225
      ItemImageDefWidth=   225
      Left            =   720
      MultiSelect     =   2  'Extended
      SelBackColor    =   &H00800000&
      SelForeColor    =   &H00FFFFFF&
      ShiftStep       =   300
      ShowChildren    =   0   'False
      TabIndex        =   0
      TabStopDistance =   0
      Tag             =   "TREE"
      Top             =   420
      Width           =   1515
      WidthOfText     =   0
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "This Application illustrates the use of Drag && Drop."
      DragIcon        =   DRAGDROP.FRX:0604
      Height          =   195
      Left            =   180
      TabIndex        =   2
      Top             =   120
      Width           =   4320
   End
End
Dim hTreeBuffer&    ' Tree Buffer to be used during Drag&Drop
Dim XCheck, YCheck  ' Mouse coordinates

' Tlist functions declarations
Declare Sub TListFreeBuffer Lib "TList" (ByVal hTreeBuffer&)
Declare Function TListIsValidBuffer Lib "TList" (ByVal hTreeBuffer&) As Integer

Sub Form_Load ()
For I = 1 To 10
   Tlist1.AddItem I
   Next I

End Sub

Sub Form_Unload (Cancel As Integer)
'   We must be in the firm belief that our temporary Tree Buffer is
'   freed when we have finished, otherwise some resources will be lost.
'   -------------------------------------------------------------------
    TListFreeBuffer (hTreeBuffer&)
End Sub

Sub tlist1_DblClick ()
' Expand/Collapse item on double - click.
    I% = Tlist1.ListIndex
    If I% >= 0 Then
      Tlist1.Expand(I%) = Not Tlist1.Expand(I%)
    End If
    Exit Sub
End Sub

Sub tlist1_DragDrop (Source As Control, X As Single, Y As Single)
    On Error GoTo Err_BadTreeBuffer ' Set Error Handler

    If Source.Tag = "TREE" Then ' Source is a TList control
      Tlist1.Redraw = False            ' Set repainting OFF
      Tlist1.Expand(Tlist1.DropTarget) = True ' Expand target item
      Tlist1.Add(Tlist1.DropTarget) = hTreeBuffer& 'Copy item(s) from Tree Buffer
      
      'Expand all dropped elements
       IPtr = Tlist1.DropTarget
       CurrentShift = Tlist1.Shift(IPtr)
       Do
         IPtr = IPtr + 1
         If IPtr >= Tlist1.ListCount Then Exit Do
         If Tlist1.Shift(IPtr) <= CurrentShift Then Exit Do
         Tlist1.Expand(IPtr) = True
         Loop
    
      Tlist1.Redraw = True             ' Set repainting ON
      TListFreeBuffer (hTreeBuffer&)      ' Free Tree Buffer
    End If
    Exit Sub

Err_BadTreeBuffer:
    MsgBox Error$
    Resume Next
End Sub

Sub tlist1_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    XCheck = X: YCheck = Y
End Sub

Sub tlist1_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
' Initiates dragging only after moving at least 50 twips with the mouse depressed

    If (Button And 1) And (XCheck > 0) And (YCheck > 0) And ((Abs(XCheck - X) > 50) Or (Abs(YCheck - Y) > 50)) Then
      XCheck = 0: YCheck = 0            ' Reset mouse coordinates
      If Tlist1.ListIndex >= 0 Then
        TListFreeBuffer (hTreeBuffer&)  ' Free Tree Buffer
        hTreeBuffer& = Tlist1.CopyItem(Tlist1.ListIndex) ' copy item
        Tlist1.Redraw = False        ' Set repainting to OFF
        Tlist1.RemoveItem Tlist1.ListIndex ' Remove item
        Tlist1.Redraw = True         ' Set repainting to ON
        Tlist1.Drag 1                ' Start drag
      End If
    End If
End Sub

Sub TList2_DblClick ()
 XCheck = X: YCheck = Y
End Sub

Sub TList2_DragDrop (Source As Control, X As Single, Y As Single)
    'On Error GoTo Err_BadTreeBuffer2 ' Set Error Handler

    If Source.Tag = "TREE" Then ' Source is a TList control
      TList2.Redraw = False            ' Set repainting OFF
      TList2.Expand(TList2.DropTarget) = True ' Expand target item
      TList2.Add(TList2.DropTarget) = hTreeBuffer& 'Copy item(s) from Tree Buffer
      'Expand all dropped elements
       IPtr = TList2.DropTarget
       CurrentShift = TList2.Shift(IPtr)
       Do
         IPtr = IPtr + 1
         If IPtr >= TList2.ListCount Then Exit Do
         If TList2.Shift(IPtr) <= CurrentShift Then Exit Do
         TList2.Expand(IPtr) = True
         Loop
         
      TList2.Redraw = True             ' Set repainting ON
      TListFreeBuffer (hTreeBuffer&)      ' Free Tree Buffer
    End If
    Exit Sub

Err_BadTreeBuffer2:
    MsgBox Error$
    Resume Next

End Sub

Sub TList2_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
 XCheck = X: YCheck = Y
End Sub

Sub TList2_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
' Initiates dragging only after moving at least 100 twips with the mouse depressed

    If (Button And 1) And (XCheck > 0) And (YCheck > 0) And ((Abs(XCheck - X) > 100) Or (Abs(YCheck - Y) > 100)) Then
      XCheck = 0: YCheck = 0            ' Reset mouse coordinates
      If TList2.ListIndex >= 0 Then
        TListFreeBuffer (hTreeBuffer&)  ' Free Tree Buffer
        hTreeBuffer& = TList2.CopyItem(TList2.ListIndex) ' copy item
        TList2.Redraw = False        ' Set repainting to OFF
        TList2.RemoveItem TList2.ListIndex ' Remove item
        TList2.Redraw = True         ' Set repainting to ON
        TList2.Drag 1                ' Start drag
      End If
    End If

End Sub

