Option Explicit

Type apiRect
    left                    As Integer
    top                     As Integer
    right                   As Integer
    bottom                  As Integer
End Type
Type apiPoint
    X                       As Integer
    Y                       As Integer
End Type

Global MP_Alt               As Integer
Global Const BUTTON_FACE = &H8000000F           ' Face shading on command buttons.
Global Const srcCopy = &HCC0020
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Function GetSystemMetrics Lib "user" (ByVal Param As Integer) As Integer
Declare Function StretchBlt Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal nSrcWidth%, ByVal nSrcHeight%, ByVal dwRop&) As Integer

Declare Function CreateDC Lib "GDI" (ByVal Driver$, ByVal Dev&, ByVal O&, ByVal init&) As Integer
Declare Function DeleteDC Lib "GDI" (ByVal dc As Integer) As Integer
Declare Sub DrawFocusRect Lib "User" (ByVal hDC As Integer, lpRect As apiRect)
Declare Function GetKeyState Lib "User" (ByVal nVirtKey As Integer) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function GetTickCount Lib "user" () As Long
Declare Function DrawIcon Lib "User" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal hIcon As Integer) As Integer
Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, lpRect As apiRect)
Declare Sub GetCursorPos Lib "User" (sPoint As apiPoint)

Declare Function GetMenu Lib "User" (ByVal hWnd As Integer) As Integer
Declare Sub ClipCursor Lib "User" (lpRect As apiRect)
Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)

Sub MakeLowerStatusBar (Bar As PictureBox)
Dim OldParentMode As Integer, MyOldMode As Integer, MDICorr As Integer
Dim OldRedraw As Integer, wRect As apiRect, Col As Long
    If Bar.Align = 2 Then
        OldRedraw = Bar.AutoRedraw
        Bar.AutoRedraw = True
        Bar.BackColor = BUTTON_FACE'GetSysColor(15)
        Bar.BorderStyle = False
        GetWindowRect Bar.hWnd, wRect
        MyOldMode = Bar.ScaleMode
        Bar.ScaleMode = 3
        Col = GetSysColor(20)
        Bar.Line (0, 1)-(wRect.right - wRect.left, 1), Col
        Bar.Line (0, 2)-(0, wRect.bottom - wRect.top), Col
        Col = GetSysColor(16)
        Bar.Line (1, wRect.bottom - wRect.top - 1)-(wRect.right - wRect.left, wRect.bottom - wRect.top - 1), Col
        Bar.Line (0, 0)-(wRect.right - wRect.left, 0), RGB(0, 0, 0)
        If MDICorr = 1 Then
            Bar.Parent.ScaleMode = OldParentMode
        End If
        Bar.ScaleMode = MyOldMode
        Bar.AutoRedraw = OldRedraw
    Else
        MakeUpperStatusBar Bar
    End If
End Sub

Sub MakeStatusBar (Bar As PictureBox)
    If Bar.Align = 2 Then
        MakeLowerStatusBar Bar
    Else
        MakeUpperStatusBar Bar
    End If
End Sub

Sub MakeUpperStatusBar (Bar As PictureBox)
Dim OldParentMode As Integer, MyOldMode As Integer, MDICorr As Integer
Dim OldRedraw As Integer, wRect As apiRect, Col As Long
    If Bar.Align = 1 Then
        OldRedraw = Bar.AutoRedraw
        Bar.AutoRedraw = True
        Bar.BackColor = BUTTON_FACE'GetSysColor(15)
        Bar.BorderStyle = False
        GetWindowRect Bar.hWnd, wRect           '<<<!!!
        MyOldMode = Bar.ScaleMode
        Bar.ScaleMode = 3
        Col = GetSysColor(20)
        Bar.Line (0, 0)-(wRect.right - wRect.left, 0), Col
        Bar.Line (0, 1)-(0, wRect.bottom - wRect.top), Col
        Col = GetSysColor(16)
        Bar.Line (1, wRect.bottom - wRect.top - 2)-(wRect.right - wRect.left, wRect.bottom - wRect.top - 2), Col
        Bar.Line (0, wRect.bottom - wRect.top - 1)-(wRect.right - wRect.left, wRect.bottom - wRect.top - 1), RGB(0, 0, 0)
        If MDICorr = 1 Then
            Bar.Parent.ScaleMode = OldParentMode
        End If
        Bar.ScaleMode = MyOldMode
        Bar.AutoRedraw = OldRedraw
    Else
        MakeLowerStatusBar Bar
    End If
End Sub

Sub SizeControl (MyControl As Control)
Dim rl As Long
    On Error Resume Next
    MyControl.Width = MyControl.Parent.ScaleWidth - MyControl.Left
    MyControl.Height = MyControl.Parent.ScaleHeight - MyControl.Top
End Sub

Sub WaitZehntel (Sec As Integer)
Dim StartZeit!, StoppZeit!
    StartZeit! = GetTickCount() / 1000
    Do
    StoppZeit! = GetTickCount() / 1000
    DoEvents
    If StartZeit! + (Sec / 10) <= StoppZeit! Then Exit Do
    Loop
End Sub

Sub zGetInnerRect (MyForm As Form, MyRect As apiRect)
Dim a As Integer, b As Integer, c As Integer, d As Integer, MyMenu As Integer
Dim bs As Integer
    GetWindowRect MyForm.hWnd, MyRect
    MyMenu = GetMenu(MyForm.hWnd)
    If MyMenu < 0 Then MyMenu = 0
    If TypeOf MyForm Is MDIForm Then
    bs = 2
    Else
    bs = MyForm.BorderStyle
    End If
    Select Case bs
    Case 0  ' ohne Rand
        a = 0
        b = 0
        c = 0
        d = 0
    Case 1  ' mit einfachem Rand
        a = GetSystemMetrics(5)
        b = GetSystemMetrics(4)
        If MyMenu Then b = b + GetSystemMetrics(15)
        c = a
        d = GetSystemMetrics(6)
    Case 2  ' mit normalem Rand
        a = GetSystemMetrics(32)
        b = GetSystemMetrics(33) + GetSystemMetrics(4) - GetSystemMetrics(6)
        If MyMenu Then b = b + GetSystemMetrics(15)
        c = a
        d = GetSystemMetrics(32)
    Case 3  ' mit doppeltem Rand
        a = GetSystemMetrics(7)
        b = GetSystemMetrics(8) + GetSystemMetrics(4) - GetSystemMetrics(6)
        If MyMenu Then b = b + GetSystemMetrics(15)
        c = a
        d = GetSystemMetrics(8)
    End Select
    MyRect.left = MyRect.left + a
    MyRect.top = MyRect.top + b
    MyRect.right = MyRect.right - c
    MyRect.bottom = MyRect.bottom - d
End Sub

