Option Explicit

  ' CONSTANTS
    '
    ' Global Constants for Stay On Top call
    '
      Global Const SWP_NOMOVE = 2
      Global Const SWP_NOSIZE = 1
      Global Const FLAGS = SWP_NOMOVE Or SWP_NOSIZE
      Global Const HWND_TOPMOST = -1
      Global Const HWND_NOTOPMOST = -2
    '
    ' System Menu Constants
    '
      Global Const MF_SEPARATOR = &H800
      Global Const MF_STRING = &H0
      Global Const MF_ENABLED = 0
      Global Const MF_BYCOMMAND = &H0
      Global Const MF_UNCHECKED = &H0
      Global Const MF_CHECKED = &H8
      Global Const MF_BYPOSITION = &H400
    '
    ' Windows Message Constants
    '
      Global Const WM_QUERYOPEN = &H13    'restore minimized window message
      Global Const WM_SYSCOMMAND = &H112  'system command message

  ' API CALLS
    '
    ' FindWindow API call to locate VB Toolbox
    '
      Declare Function FindWindowBystring Lib "User" Alias "FindWindow" (ByVal lpClassName As Any, ByVal lpWindowName As String) As Integer
    '
    ' SetWindowPos API call used to toggle window stay on top status
    '
      Declare Function SetWindowPos Lib "User" (ByVal h As Integer, ByVal hb As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal f As Integer) As Integer
    '
    ' System Menu API Declarations
    '
      '
      ' Append or Remove menu items
      '
        Declare Function AppendMenu Lib "USER" (ByVal hMenu As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpNewItem As Any) As Integer
        Declare Function RemoveMenu Lib "USER" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
      '
      ' Get System Menu handle
      '
        Declare Function GetSystemMenu Lib "USER" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
      '
      ' Get the state of and modify System Menu items. Used to check and
      ' uncheck menu items
      '
        Declare Function GetMenuState Lib "USER" (ByVal hMenu As Integer, ByVal wId As Integer, ByVal wFlags As Integer) As Integer
        Declare Function ModifyMenuBystring Lib "USER" Alias "ModifyMenu" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpString As String) As Integer

Sub CheckOnTop (iStatus As Integer)
  '
  ' Place checkmark on or remove checkmark from hard coded menu item.
  ' Routine could be made more generic by passing more info into it.
  '
  Dim iResult As Integer, hMenu As Integer
  hMenu = GetSystemMenu(frmMain.hWnd, False)
  If iStatus = MF_UNCHECKED Then
    iResult = ModifyMenuBystring(hMenu, 6, MF_UNCHECKED Or MF_BYPOSITION, 1, "&Toolbox On Top")
  Else
    iResult = ModifyMenuBystring(hMenu, 6, MF_CHECKED Or MF_BYPOSITION, 1, "&Toolbox On Top")
  End If
End Sub

Function IsMenuChecked () As Integer
 '
 '  See if System Menu Item is checked or not
 '
 Dim iResult As Integer, hMenu As Integer
 hMenu = GetSystemMenu(frmMain.hWnd, False)
 iResult = GetMenuState(hMenu, 1, MF_BYCOMMAND)
 If iResult = MF_CHECKED Then
   IsMenuChecked = True
 Else
   IsMenuChecked = False
 End If
End Function

Sub SetupDialogMenu (frm As Form)
  Dim hMenu As Integer, iResult As Integer
  hMenu = GetSystemMenu(frm.hWnd, 0)
  '
  ' Remove all but the MOVE and CLOSE options. Note that
  ' the min and max buttons are assumed to be set to
  ' false and the form's BorderStyle is assumed to be
  ' fixed double.
  '
  iResult = RemoveMenu(hMenu, 8, MF_BYPOSITION) 'Switch to
  iResult = RemoveMenu(hMenu, 7, MF_BYPOSITION) 'Separator
  iResult = RemoveMenu(hMenu, 5, MF_BYPOSITION) 'Separator
End Sub

Sub SysMenuBuild ()
 '
 ' Add Additional Menu Strings to System Menu
 '
 Dim hMenu As Integer, Result As Integer
 hMenu = GetSystemMenu(frmMain.hWnd, False)
 Result = AppendMenu(hMenu, MF_SEPARATOR, 0, "")
 Result = AppendMenu(hMenu, MF_STRING, 1, "&Toolbox On Top")
 Result = AppendMenu(hMenu, MF_SEPARATOR, 0, "")
 Result = AppendMenu(hMenu, MF_STRING, 2, "&About 'Toolbox On Top'...")
End Sub

Sub ToolboxOnTop (iToggle As Integer)
  Dim iResult As Integer, iToolbox As Integer
  '
  ' Gets VB Toolbox handle
  '
  iToolbox = FindWindowBystring("ToolsPalette", "")
  '
  ' If Toolbox is present, then toggle it
  '
  If iToolbox <> 0 Then
    If iToggle Then
      iResult = SetWindowPos(iToolbox, HWND_TOPMOST, 0, 0, 0, 0, FLAGS)
    Else
      iResult = SetWindowPos(iToolbox, HWND_NOTOPMOST, 0, 0, 0, 0, FLAGS)
    End If
  End If
End Sub

