Option Explicit

Global LanguageUsed  As Integer
Global nYear         As Integer
Global nMonth        As Integer
Global nDay          As Integer
Global OldDayIndex   As Integer

Sub Main ()

   LanguageUsed = LNG_ENGLISH

   Load T2Wcalendar

   cShowWindow T2Wcalendar.hWnd, 0, 70

   sCreateCalendar

   nYear = Year(Int(Now))
   nMonth = Month(Int(Now))
   nDay = Day(Int(Now))

   sDisplayMonth nYear, nMonth, nDay

   T2Wcalendar.Show

End Sub

Sub sCreateCalendar ()

   Dim i       As Integer

   Dim l       As Integer
   Dim t       As Integer
   Dim w       As Integer
   Dim h       As Integer

   l = T2Wcalendar.lblDay(0).Left
   t = T2Wcalendar.lblDay(0).Top
   w = T2Wcalendar.lblDay(0).Width
   h = T2Wcalendar.lblDay(0).Height

   T2Wcalendar.lblDay(0).Tag = "   "

   For i = 0 To 41

      If (i > 0) Then

         Load T2Wcalendar.lblDay(i)

         T2Wcalendar.lblDay(i).Left = l + ((i Mod 7) * (w + 30))
         T2Wcalendar.lblDay(i).Top = t + ((i \ 7) * (h + 30))

         T2Wcalendar.lblDay(i).Visible = True

      End If

   Next i

   l = T2Wcalendar.lblDayName(0).Left
   t = T2Wcalendar.lblDayName(0).Top
   w = T2Wcalendar.lblDayName(0).Width
   h = T2Wcalendar.lblDayName(0).Height

   For i = 0 To 6

      If (i > 0) Then

         Load T2Wcalendar.lblDayName(i)

         T2Wcalendar.lblDayName(i).Left = l + ((i Mod 7) * (w + 30))
         T2Wcalendar.lblDayName(i).Top = t

         T2Wcalendar.lblDayName(i).Visible = True

      End If

   Next i

   l = T2Wcalendar.lblWeek(0).Left
   t = T2Wcalendar.lblWeek(0).Top
   w = T2Wcalendar.lblWeek(0).Width
   h = T2Wcalendar.lblWeek(0).Height

   For i = 0 To 5

      If (i > 0) Then

         Load T2Wcalendar.lblWeek(i)

         T2Wcalendar.lblWeek(i).Left = l
         T2Wcalendar.lblWeek(i).Top = t + (i * (h + 30))

         T2Wcalendar.lblWeek(i).Visible = True

      End If

   Next i

End Sub

Sub sDisplayMonth (nYear As Integer, nMonth As Integer, nDay As Integer)

   Dim i                As Integer

   Dim WeekNumber       As Integer
   Dim DayNumber        As Integer
   Dim FirstDay         As Integer
   Dim TotalDays        As Integer

   Dim Tmp              As String

   FirstDay = cDayOfWeek(nYear, nMonth, 1, True)
   TotalDays = cDaysInMonth(nYear, nMonth)

   T2Wcalendar.lblDayYear(1).Caption = ""

   For i = 0 To 41

      DayNumber = i - FirstDay + 1

      T2Wcalendar.lblDay(i).BorderStyle = 0
      T2Wcalendar.lblDay(i).BackColor = &HC0C0C0
      Tmp = T2Wcalendar.lblDay(i).Tag

      If (i < 6) Then T2Wcalendar.lblWeek(i).Caption = ""
      
      If (i < FirstDay) Then
         T2Wcalendar.lblDay(i).Caption = ""
         Mid$(Tmp, 1, 2) = "  "
      ElseIf (DayNumber > TotalDays) Then
         T2Wcalendar.lblDay(i).Caption = ""
         Mid$(Tmp, 1, 2) = "  "
      Else
         T2Wcalendar.lblDay(i).Caption = DayNumber
         Mid$(Tmp, 1, 2) = Format$(DayNumber, "00")
         If (DayNumber = nDay) Then T2Wcalendar.lblDay(i).BorderStyle = 1
         If (DayNumber < 8) Then T2Wcalendar.lblDayName(DayNumber - 1).Caption = cGetSmallDay(LanguageUsed, IIf((DayNumber + 1) > 7, 1, (DayNumber + 1)))
         If ((DayNumber = 1) Or ((i Mod 7) = 0)) Then
            WeekNumber = cWeekOfYear(nYear, nMonth, DayNumber, 0)
            If (WeekNumber = 53) Then WeekNumber = 1
            T2Wcalendar.lblWeek(i \ 7).Caption = WeekNumber
         End If
      End If

      T2Wcalendar.lblDay(i).Tag = Tmp

   Next i

   T2Wcalendar.lblDayYear(0).Caption = cDayOfYear(nYear, nMonth, nDay)
   T2Wcalendar.lblMonth.Caption = cGetLongMonth(LanguageUsed, nMonth)
   T2Wcalendar.lblYear.Caption = nYear

   T2Wcalendar.txtEditDay(0).Text = Format$(nMonth, "00")
   T2Wcalendar.txtEditDay(1).Text = Format$(nDay, "00")
   T2Wcalendar.txtEditDay(2).Text = Format$(nYear, "0000")

   sEffect3D

End Sub

Sub sEffect3D ()

   Dim i       As Integer

   For i = 0 To 41
      If (Val(Mid$(T2Wcalendar.lblDay(i).Tag, 1, 2)) > 0) Then
         c3D T2Wcalendar.lblDay(i), 1, 0
      Else
         c3D T2Wcalendar.lblDay(i), 0, 0
      End If
   Next i

   For i = 0 To 6
      c3D T2Wcalendar.lblDayName(i), 0, 0
   Next i

   For i = 0 To 5
      c3D T2Wcalendar.lblWeek(i), 0, 0
   Next i

   For i = 0 To 3
      c3D T2Wcalendar.pctPrevNext(i), 0, 0
   Next i

   For i = 0 To 2
      c3D T2Wcalendar.txtEditDay(i), 0, 0
   Next i

   c3D T2Wcalendar.lblMonth, 0, 0
   c3D T2Wcalendar.lblYear, 0, 0
   c3D T2Wcalendar.Picture1, 1, 0

End Sub

