

Function strfield$ (record$, separator$, fieldnumber%)


      'I must yield glory to Pete Thompson, creator of the Lotus Ami Pro Macro Language,
      'for the idea to create the StrField function which is present in the Ami Pro
      'Macro Language, but ABSENT in Visual Basic.  The StrField function has three
      'parameters:
      '
      '     1. a string which is a record of fields delimited by a specific character
      '     2. the delimiter
      '     3. the field number to be extracted from the record


      If Len(record$) = 0 Then               'return null if zero length string
         strfield$ = ""
         Exit Function
      End If

      If InStr(record$, separator$) = 0 Then 'return null if less than two fields
         strfield$ = ""
         Exit Function
      End If

      If fieldnumber% < 1 Then               'return null if requested field number is not positive
         strfield$ = ""
         Exit Function
      End If

      For a = 1 To Len(record$)              'count separators for next evaluation
         b = Mid$(record$, a, 1)
            If b = separator$ Then
               y = y + 1
            End If
      Next a

      If y < (fieldnumber% - 1) Then         'return null if non-existent field is requested
         strfield$ = ""
         Exit Function
      End If

      For x = 1 To Len(record$)              'parse requested field from record
         c = Mid$(record$, x, 1)
            If c = separator$ Then
               z = z + 1
                  If z = (fieldnumber% - 1) Then
                     record$ = Right$(record$, Len(record$) - x)
                  End If
            End If
      Next x

      If InStr(record$, separator$) = 0 Then 'if no separators left in record, then remaining record IS the
         strfield$ = record$                 'requested field (last)
      Else
         strfield$ = Left$(record$, InStr(record$, separator$) - 1)
      End If

End Function

