#ifndef _SPLASH_H
#define _SPLASH_H

//
//  Copyright (C) 1994 by
//  HSC Software Devlopers, St. Louis, MO, USA
//  All Rights Reserved.
//
//  This software is furnished under a license and may be used and copied
//  only in accordance of the terms of such license and with the
//  inclusion of the above copyright notice. This software or any other
//  copies thereof may not be provided or otherwise made available to any
//  other person. No title to and ownership of the software is hereby
//  transferred.
//
//  The information in this software is subject to change without notice
//  and should not be construed as a commitment by HSC Software Developers.
//
//
//  FACILITY: General Windows Functionality
//
//  ABSTRACT:
//
//     The SPLASH Libraries are used to create a splash, or startup,                  
//     screen that is displayed while another program is initializing. This              
//     gives users immediate feedback and an indication that the                       
//     application is starting properly.                                                        
//                                                                                     
//     SPLASH16.DLL is the 16 bit Windows Version.                                     
//     SPLASH32.DLL is the 32 bit Windows Version. (Not included w/o registration)
//     SPLASH16.LIB is the import library for SPLASH16.DLL                             
//     SPLASH32.LIB is the import library for SPLASH32.DLL (Not included w/o registration)                            
//     SPLASH.H is the header file
//                                                                                     
//     SPLASHxx.DLL supports standard SDK painting functions for drawing               
//     splash screens based on bitmap files (BMP) and bitmap resources                 
//     embedded in the calling program. In addition, the 16 bit version
//	   supports the ACCUSOFT.DLL and ACCUGOLD.DLL graphics libraries
//	   from AccuSoft. This allows display of splash screens with more
//	   than 16 colors and special effects.                     
//                                                                                     
//     Currently, SPLASHxx.DLL supports 16 colors for internal functions.              
//     ShowSplashAnyFormat uses the AccuSoft DLL(s) (16 bit only)
//	   and is capable of more than 16 colors.                                                                 
//                                                                                     
//     See SPLASH.WRI for more information                                             
//
//  AUTHOR(S): Todd Osborne
//
//  CREATED: 06/08/94
//
//  Version Date        By      		Reason
//
//	1.00	06/08/94	Todd Osborne	Created
//	1.01	10/28/94	Todd Osborne	Modified for Win32									AccuSoft functions are not supported in Win32.
//
// To show a splash bitmap from a bitmap resource in a DLL or EXE file, pass
// ShowSplashFromResource the instance handle of the calling DLL or EXE, the null
// terminated string of the bitmap resource to load, and the number of seconds
// to show the splash screen.
// The number of seconds only causes a splash screen
// to be displayed for a required amount of time. The splash screen is NOT detroyed
// until a call is made to EndSplash().

// To show a splash bitmap from a file (any format) pass the null terminated
// filename, effect constant, the name of the DLL provided by AccuSoft and the number of
// seconds to show the splash screen to ShowSplashAnyFormat. You will need to have the
// appropriate DLL from AccuSoft to do this.
// For ACCUGOLD.DLL, pass ACCU32IF.DLL as the 3rd parameter. If you are using the basic
// ACCUSOFT.DLL, pass this instead.
// The number of seconds only causes a splash screen
// to be displayed for a required amount of time. The splash screen is NOT detroyed
// until a call is made to EndSplash().

// To show a splash bitmap from a Windows bitmap file (BMP) pass the null terminated
// filename to ShowSplashFromFile, and the number of seconds to show the splash screen.
// No additonal DLL's (other than SPLASHxx.DLL) are required to perform this operation.
// The number of seconds only causes a splash screen
// to be displayed for a required amount of time. The splash screen is NOT detroyed
// until a call is made to EndSplash().

#ifdef __cplusplus
extern "C" {
#endif

// Undefine for WIN32
#ifdef WIN32
	#define huge
	#define _export
#endif

// These can be used to call splash functions via GetProcAddress()
// rather than using the import library. This allows your program
// to run even if SPLASHxx.DLL is not found on the users system.
// For Example:
// HINSTANCE hSplash = LoadLibrary("SPLASH16.DLL)
// If 16-Bit Windows, use if ( hSplash < HINSTANCE_ERROR ). LoadLibrary() will
// return NULL only in Win32
// if ( hSplash )
// {
//		SHOWSPLASHFROMRESOURCE fp = (SHOWSPLASHFROMRESOURCE)GetProcAddress(m_hSplashDLL, "ShowSplashFromResource");
//		if ( fp )
//			Start the splash screen
//			(*fp)(AfxGetInstanceHandle(), "IDB_SPLASH", 1);
//		Continue more processing
//		.
//		.
//		.
// }
//
// 	if ( hSplash )
//	{
//		ENDSPLASH fp = (ENDSPLASH)GetProcAddress(hSplash, "EndSplash");
//		if ( fp )
//			(*fp)();
//
//		FreeLibrary(hSplash);
//	}			
typedef BOOL (FAR PASCAL *SHOWSPLASHANYFORMAT)(char FAR*, int, char FAR*, UINT);
typedef BOOL (FAR PASCAL *SHOWSPLASHFROMFILE)(char FAR*, UINT);
typedef BOOL (FAR PASCAL *SHOWSPLASHFROMRESOURCE)(HINSTANCE, char FAR*, UINT);
typedef void (FAR PASCAL *ENDSPLASH)(void);

// Exported functions
// ShowSplashAnyFormat() is not supported under Win32
#ifndef _WIN32
	BOOL FAR PASCAL ShowSplashAnyFormat(char FAR* lpszFileName, int Effect,char FAR* lpszAccuSoftDLLName, UINT nWait);
#endif
BOOL FAR PASCAL ShowSplashFromFile(char FAR* lpszFileName, UINT nWait);
BOOL FAR PASCAL ShowSplashFromResource(HINSTANCE hInstance, char far* lpszBitmap, UINT nWait);
void FAR PASCAL EndSplash(void);

#ifdef __cplusplus
}
#endif

// Effects that can be passed for use with AccuSoft DLL's.
// Not available for Win32
#ifndef _WIN32
	#define NO_EFFECT       0
	#define TOP_WIPE        1
	#define BOTTOM_WIPE     2
	#define LEFT_WIPE       3
	#define RIGHT_WIPE      4
	#define BLINDS          5
	#define BLOCKS          6
	#define CENTER          7
	#define LOUVERS         8
	#define SQUAREOUT       9
	#define ZIGZAG          10
#endif

#endif	// _SPLASH_H

