#include "demo_cpp.h"

CTheApp ThisApp;

BOOL CTheApp::InitInstance()
{
	// Create main dialog box window and show m_strAPPTITLE in caption bar
	m_pMainWnd = new CMainDlgWindow();
	
	if ( m_pMainWnd != NULL )
	{
		#ifdef _WIN32
			m_pMainWnd->SetWindowText("SPLASH32.DLL Demo for C/C++");
		#else
			m_pMainWnd->SetWindowText("SPLASH16.DLL Demo for C/C++");
		#endif
		
		// Set application (window) icon
		#ifdef _WIN32
			::SetClassLong(m_pMainWnd->m_hWnd, GCL_HICON, (WORD)::LoadIcon(AfxGetResourceHandle(), MAKEINTRESOURCE(IDI_APPLICATION)));
		#else
			SetClassWord(m_pMainWnd->m_hWnd, GCW_HICON, (WORD)LoadIcon(IDI_APPLICATION));
		#endif
	
		return TRUE;
	}
	else
		return FALSE;
}

CMainDlgWindow::CMainDlgWindow()
{
	// We can use the help file path as a start for the default file
	// Parse it to last backslash and add "SPLASH.BMP"
	m_strSplashFileName = App.m_pszHelpFilePath;
	m_strSplashFileName = m_strSplashFileName.Mid(0, m_strSplashFileName.ReverseFind('\\') + 1) + "SPLASH.BMP";
	m_nHowLong = 1;
	m_nWhichDLL = 0;

	//{{AFX_DATA_INIT(CMainDlgWindow)
	//}}AFX_DATA_INIT
	
	// Create the Main Dialog Window
	Create(IDD_MAIN);
}

// ***** MESSAGE HANDLERS ******

BOOL CMainDlgWindow::OnCommand(WPARAM wParam, LPARAM lParam)
{
	// Handle messages before message map
	// This is where we trap buton clicks to call DLL
	// The button ID's for the AccuSoft functions are between 100 - 110
	// Button ID 111 is used to show splash using normal bitmap loading techniques (No AccuSoft DLL's are needed)
	
	WORD wControl		= 0;
	WORD wNotifyCode 	= 0;

	#ifdef _WIN32
		wControl = 		LOWORD(wParam);
		wNotifyCode = 	HIWORD(wParam);
	#else
		wControl = 		wParam;
		wNotifyCode =	HIWORD(lParam);
	#endif
	
	if ( wControl && wNotifyCode == BN_CLICKED )
	{
		// Call DDX routine to get data from screen into member vars
		UpdateData(TRUE);
		
		// Subtract 100 from the control ID and call ShowSplashAnyFormat for values 0-10
		// Call ShowSplashFromFile for 11 and ShowSplashFromResource for 12
		// WIN32: ShowSplashAnyFormat() is NOT supported

		int nButton = wControl - 100;
		
		char* psz = m_strSplashFileName.GetBuffer(m_strSplashFileName.GetLength());
		
		#ifndef _WIN32
			if ( nButton >= 0 && nButton <=10 )
				// This will show the splash screen using AccuSoft DLL(s). These DLL's are capable
				// of more than 16 color displays and can produce interesting visual effects.
				// Contact AccuSoft for more information.
				ShowSplashAnyFormat(psz, nButton, (m_nWhichDLL == 0 ) ? "ACCUSOFT.DLL" : "ACCU32IF.DLL", m_nHowLong);
			else
		#endif
			
		if ( nButton == 11 )
			// This will show the splash screen by passing the name of a Windows bitmap (BMP)
			// file. This routine currently supports up to 16 colors. No additional DLL's are
			// needed.
			ShowSplashFromFile(psz, m_nHowLong);
		
		else if ( nButton == 12 )
			// This will show the splash screen by passing the name of a resource embedded in
			// the calling program. This routine currently supports up to 16 colors. No additional
			// DLL's are needed. This is not available to languages and applications that do not
			// store their resources within their EXE or DLL. Sorry VB guys!
			ShowSplashFromResource(AfxGetInstanceHandle(), "IDB_SPLASH", m_nHowLong);
				
		m_strSplashFileName.ReleaseBuffer();
	
		// End the splash screen
		EndSplash();
	}	
			
	// Do default processing of this message
	CWnd::OnCommand(wParam, lParam);
	
	return 1;
}

void CMainDlgWindow::OnCancel()
{
	// Override default processing that closes window
}

void CMainDlgWindow::OnClose()
{
	DestroyWindow();
}

void CMainDlgWindow::PostNcDestroy()
{
	// Destroy this dialog box pointer
	delete this;

	// Tell Windows to shut us down
	::PostQuitMessage(0);
}

BOOL CMainDlgWindow::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// The ACCUSOFT DLL's are NOT supported under Win32. Gray these controls
  	#ifdef _WIN32
		for ( UINT i = IDC_BUTTON0; i <= IDC_BUTTON10; i++ )
			GetDlgItem(i)->EnableWindow(FALSE);

		GetDlgItem(IDC_RADIO1)->EnableWindow(FALSE);
		GetDlgItem(IDC_RADIO2)->EnableWindow(FALSE);
	#endif

  	// Center this window on screen
	CenterWindow();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMainDlgWindow::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainDlgWindow)
	DDX_Text(pDX, IDC_EDIT1, m_strSplashFileName);
	DDX_CBIndex(pDX, IDC_COMBO1, m_nHowLong);
	DDX_Radio(pDX, IDC_RADIO1, m_nWhichDLL);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMainDlgWindow, CDialog)
	//{{AFX_MSG_MAP(CMainDlgWindow)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
