Sub Control3D (TheForm As Form, FrameStyle As Integer, Bevelwidth As Integer)
    
    Dim ColorLeftTop As Long, ColorRightBottom As Long
    Dim x  As Integer, y As Integer, i As Integer
    Dim xdiff As Integer, ydiff As Integer
    Dim cLeft As Integer, cright As Integer, ctop As Integer, cbottom As Integer
    
    xdiff = Screen.TwipsPerPixelX
    ydiff = Screen.TwipsPerPixelY
    Bevelwidth = Bevelwidth - 1
    
    Select Case FrameStyle
        Case True
            ColorLeftTop = RGB(128, 128, 128) ' darkgray
            ColorRightBottom = RGB(255, 255, 255) 'fullwhite
        'remove
        Case False
            ColorLeftTop = TheForm.BackColor
            ColorRightBottom = TheForm.BackColor
    End Select

    For j% = 0 To TheForm.Controls.Count - 1
        If TheForm.Controls(j%).Tag = "3D" Then
            cLeft = TheForm.Controls(j%).Left
            ctop = TheForm.Controls(j%).Top
            cright = TheForm.Controls(j%).Left + TheForm.Controls(j%).Width
            cbottom = TheForm.Controls(j%).Top + TheForm.Controls(j%).Height
    
            For i = 0 To Bevelwidth
                x = xdiff * i
                y = ydiff * i
                TheForm.Line ((cLeft - xdiff) - x, (ctop - ydiff) - y)-((cright) + x, (ctop - ydiff) - y), ColorLeftTop
                TheForm.Line ((cLeft - xdiff) - x, (ctop - ydiff) - y)-((cLeft - xdiff) - x, (cbottom) + y), ColorLeftTop
                TheForm.Line ((cright) + x, (ctop) - y)-((cright) + x, (cbottom + ydiff) + y), ColorRightBottom
                TheForm.Line ((cLeft) - x, (cbottom) + y)-((cright) + x, (cbottom) + y), ColorRightBottom
            Next
        End If
    Next
End Sub

Sub Form3D (TheForm As Form, FrameStyle As Integer, Bevelwidth As Integer)


    Dim ColorLeftTop As Long, ColorRightBottom As Long
    Dim x  As Integer, y As Integer, i As Integer
    Dim xdiff As Integer, ydiff As Integer
    Dim cLeft As Integer, cright As Integer, ctop As Integer, cbottom As Integer
    
    xdiff = Screen.TwipsPerPixelX
    ydiff = Screen.TwipsPerPixelY
    Bevelwidth = Bevelwidth - 1
    
    Select Case FrameStyle
        Case True
            ColorLeftTop = RGB(128, 128, 128) ' darkgray
            ColorRightBottom = RGB(255, 255, 255) 'fullwhite
        'remove
        Case False
            ColorLeftTop = TheForm.BackColor
            ColorRightBottom = TheForm.BackColor'TheForm.Simple3D1.BorderColor'RGB(192, 192, 192)
    End Select

    cLeft = 8
    ctop = 8
    cright = TheForm.ScaleWidth - 8
    cbottom = TheForm.ScaleHeight - 8
    For i = 0 To Bevelwidth
        x = xdiff * i
        y = ydiff * i
        TheForm.Line ((cLeft - 1 - xdiff) - x, (ctop - ydiff) - y)-((cright) + x - 1, (ctop - ydiff) - y), ColorLeftTop
        TheForm.Line ((cLeft - xdiff) - x, (ctop - ydiff) - y)-((cLeft - xdiff) - x, (cbottom) + y), ColorLeftTop
        TheForm.Line ((cright) + x, (ctop) - y - 1)-((cright) + x, (cbottom + ydiff) + y), ColorRightBottom
        TheForm.Line ((cLeft - 1) - x, (cbottom) + y)-((cright - 2) + x, (cbottom) + y), ColorRightBottom
    Next
End Sub

