Option Explicit

Global Const ApplicationName = "SERIALIZ"

Global DirectoryForApplication      As String
Global SelectedLanguage             As String
Global CurrentLanguage              As Integer
Global SaveTitleForm                As String

Global FileToUse                    As String

Global SERIALDATA                   As tagSERIALDATA

Sub FileProcessAdd ()

   Dim ErrCode          As Integer
   Dim WasSerial        As Integer

   ' get the full name to use
   FileToUse = GetFileToUse()

   ' if no file selected, stop
   If (Len(FileToUse) = 0) Then Exit Sub

   ' check if file is serialized
   WasSerial = cIsSerial(FileToUse)

   ' format the serial number field
   frmSerialization.SerNumber.Text = Val(frmSerialization.SerNumber.Text)

   ' set the serialization info from fields
   SERIALDATA.Description1 = frmSerialization.SerPart1.Text
   SERIALDATA.Description2 = frmSerialization.SerPart2.Text
   SERIALDATA.Number = frmSerialization.SerNumber.Text
   ' put the serialization info
   ErrCode = cSerialPut(FileToUse, SERIALDATA)

   ' check if file was been serialized
   If (WasSerial = False) Then
      ' yes, display the message
      Call MessageDisplay("2", FileToUse)

   Else
      ' no, display the message
      Call MessageDisplay("3", FileToUse)

   End If

End Sub

Sub FileProcessChange ()

   Dim ErrCode          As Integer

   ' get the full name to use
   FileToUse = GetFileToUse()

   ' if no file selected, stop
   If (Len(FileToUse) = 0) Then Exit Sub

   ' check if file is serialized
   If (cIsSerial(FileToUse) = 0) Then
      ' no, display error
      Call MessageDisplay("1", FileToUse)

   Else
      ' yes, add 1 to serial number
      ErrCode = cSerialInc(FileToUse, 1)
      ' read the serialization info
      ErrCode = cSerialGet(FileToUse, SERIALDATA)
      ' set the serialization info on fields
      frmSerialization.SerPart1.Text = SERIALDATA.Description1
      frmSerialization.SerPart2.Text = SERIALDATA.Description2
      frmSerialization.SerNumber.Text = SERIALDATA.Number
      ' check the serial number, for example MOD 10
      If ((SERIALDATA.Number Mod 10) = 0) Then
         ' yes, modulo 10, display message
         Call MessageDisplay("4", FileToUse)
      End If

   End If

End Sub

Sub FileProcessRead ()

   Dim ErrCode          As Integer

   ' get the full name to use
   FileToUse = GetFileToUse()

   ' if no file selected, stop
   If (Len(FileToUse) = 0) Then Exit Sub

   ' check if file is serialized
   If (cIsSerial(FileToUse) = 0) Then
      ' no, display error
      Call MessageDisplay("1", FileToUse)

   Else
      ' yes, display the serialization info
      ErrCode = cSerialGet(FileToUse, SERIALDATA)
      ' set the serialization info on fields
      frmSerialization.SerPart1.Text = SERIALDATA.Description1
      frmSerialization.SerPart2.Text = SERIALDATA.Description2
      frmSerialization.SerNumber.Text = SERIALDATA.Number

   End If

End Sub

Sub FileProcessRemove ()

   Dim ErrCode          As Integer

   ' get the full name to use
   FileToUse = GetFileToUse()

   ' if no file selected, stop
   If (Len(FileToUse) = 0) Then Exit Sub

   ' check if file is serialized
   If (cIsSerial(FileToUse) = 0) Then
      ' no, display error
      Call MessageDisplay("1", FileToUse)

   Else
      ' yes, remove the serialization info
      ErrCode = cSerialRmv(FileToUse)
      ' display remove message
      Call MessageDisplay("5", FileToUse)

   End If

End Sub

Function GetFileToUse () As String

   ' check if a file has been selected
   If (frmSerialization.File1.ListIndex >= 0) Then
      ' yes, form the full name
      GetFileToUse = frmSerialization.File1.Path + "\" + frmSerialization.File1.List(frmSerialization.File1.ListIndex)

   Else

      Call MessageDisplay("0", "")
      
      ' no, return empty
      GetFileToUse = ""

   End If

End Function

Sub Loader ()

   DoEvents

   Dim ErrCode    As Integer
   Dim SplitPath  As tagSPLITPATH

   ' some initializations
   CurrentLanguage = LNG_ENGLISH
   DirectoryForApplication = cGetIn(cEXEnameActiveWindow(), ".", 1)
   ' split the path of the application into four components
   ErrCode = cSplitPath(DirectoryForApplication, SplitPath)
   ' regenerate only the directory of the application
   DirectoryForApplication = SplitPath.nDrive + SplitPath.nDir
   ' set the default language
   SelectedLanguage = ".TUK"

   ' save the caption of this form
   SaveTitleForm = frmSerialization.Caption
   
   ' change the language to the current language in the system menu of the current form
   Call cLngSysMenu(CurrentLanguage, frmSerialization.hWnd)
   
   ErrCode = cReadCtlLanguage(frmSerialization.Label1(0), RS_CAPTION, DirectoryForApplication + ApplicationName + SelectedLanguage)

End Sub

Sub MessageDisplay (TextOrder As String, InsertText As String)

   ' display a multi-language message box, message are centered
   ' and a timeout of 30 seconds is displayed.
   Call cLngBoxMsg(CurrentLanguage, ReadText(TextOrder, InsertText), MB_MESSAGE_LEFT Or MB_TIMEOUT_30 Or MB_DISPLAY_TIMEOUT Or 32, SaveTitleForm)

End Sub

Function ReadText (TextOrder As String, InsertText As String) As String

   Dim Tmp              As String
   Dim BasisText        As String

   ' read the text in the language file
   BasisText = cGetIni(ApplicationName, TextOrder, "?", DirectoryForApplication & ApplicationName & SelectedLanguage)
   
   ' insert some text if any
   Tmp = cInsertBlocks(BasisText, InsertText)

   ' change all  to make a CR
   Call cChangeChars(Tmp, "", Chr$(13))

   ReadText = Tmp

End Function

