'used to figure out if it was a text box control passed to the function
Declare Function GetClassName Lib "User" (ByVal hWnd As Integer, ByVal lpClassName As String, ByVal nMaxCount As Integer) As Integer

'the class type of a VB Text Box
Global Const TEXT_BOX = "ThunderTextBox"

'variable to globalize the control we're searching and replacing
Global FAndRControl As Control

'constant to identify the FindandReplace form
Global Const FIND_FORM_TAG = "FindFormTag"

'message box constants
Global Const MB_QUESTION = 36
Global Const MB_YES = 6

Sub FindAndReplace (MyControl As Control)

Dim ClassName As String
Dim RetVal As Integer
Dim Looper As Integer

'go through each form to see if the Find and Replace form is already loaded
For Looper = 0 To Forms.Count - 1
  If Forms(Looper).Tag = FIND_FORM_TAG Then Exit Sub
Next Looper

'clear out variable
ClassName = String$(256, 0)

'get the class name of the control to make sure that it's a VB Text Box
RetVal = GetClassName(MyControl.hWnd, ClassName, 255)

ClassName = Left$(ClassName, RetVal)

If ClassName <> TEXT_BOX Then  'if we haven't been passed a text box as a control
  MsgBox "The control you are checking is not a text box; the Search and Replace will not work.", 16, ProgTitle
  Exit Sub
End If

'turn the pointer to an hourglass
Screen.MousePointer = 11

'set the global search and replace control variable
Set FAndRControl = MyControl

'if the text selection point isn't at the beginning, and no text is selected,
'ask the user if it should be moved there
If (FAndRControl.SelStart > 0) And (FAndRControl.SelLength = 0) Then
  If MsgBox("Do you want to start at the beginning of the text?", MB_QUESTION, ProgTitle) = MB_YES Then
    FAndRControl.SelStart = 0
  End If
End If

'show the search form
FindForm.Show

'turn the pointer back to normal
Screen.MousePointer = 0

End Sub

