VERSION 2.00
Begin Form FindForm 
   BackColor       =   &H8000000F&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Form1"
   ClientHeight    =   1995
   ClientLeft      =   2625
   ClientTop       =   4110
   ClientWidth     =   5850
   ControlBox      =   0   'False
   Height          =   2400
   Icon            =   FINDFORM.FRX:0000
   Left            =   2565
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1995
   ScaleWidth      =   5850
   Tag             =   "FindFormTag"
   Top             =   3765
   Width           =   5970
   Begin CheckBox MatchCase 
      BackColor       =   &H00C0C0C0&
      Caption         =   "MatchCase"
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   1680
      Width           =   1695
   End
   Begin CommandButton Action 
      Caption         =   "Verify"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Index           =   1
      Left            =   4560
      TabIndex        =   7
      Top             =   600
      Width           =   1215
   End
   Begin CommandButton Action 
      Caption         =   "Replace"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Index           =   2
      Left            =   4560
      TabIndex        =   6
      Top             =   1080
      Width           =   1215
   End
   Begin CommandButton Action 
      Caption         =   "Cancel"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Index           =   3
      Left            =   4560
      TabIndex        =   5
      Top             =   1560
      Width           =   1215
   End
   Begin CommandButton Action 
      Caption         =   "Find"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Index           =   0
      Left            =   4560
      TabIndex        =   4
      Top             =   120
      Width           =   1215
   End
   Begin TextBox ReplaceText 
      Height          =   285
      Left            =   1560
      TabIndex        =   3
      Top             =   600
      Width           =   2775
   End
   Begin TextBox FindText 
      Height          =   285
      Left            =   1560
      TabIndex        =   2
      Top             =   120
      Width           =   2775
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Replace With:"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   600
      Width           =   1335
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Search For:"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1335
   End
End
Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)
Const AppTitle = "Steve's Find and Replace"
Const SWP_SHOWWINDOW = &H40
Const HWND_TOPMOST = -1

Sub Action_Click (Index As Integer)

Dim SearchType As Integer
Dim StartPos As Integer
Dim NextPos As Integer
Dim FindVal As String
Dim ReplaceVal As String
Dim SearchLen As Integer
Dim CaseSensitive As Integer

'search constants
Const SRCH_FIND = 0
Const SRCH_VERIFY = 1
Const SRCH_REPLACE = 2

'message box constants
Const MB_QUESTION = 36
Const MB_YES = 6

'if the user selected cancel
If Index = 3 Then
  'unload the form
  Unload Me
  'quit the subroutine
  Exit Sub
Else
  'otherwise, define the type of Find and Replace
  SearchType = Index
End If

'make sure text is entered
If FindText.Text = "" Then
  MsgBox "The Search For field must contain one or more characters to look for.", 16, ProgTitle
  FindText.SetFocus
  Exit Sub
End If

'change pointer to an hourglass
Screen.MousePointer = 11

'set initial values
NextPos = 0    'the next position we start looking for a match
FindVal = FindText.Text  'the text we're looking for
ReplaceVal = ReplaceText.Text  'the text we want to replace with
SearchLen = Len(FindVal)  'the length of the text we're looking for

'the starting position we look for a match
If (FAndRControl.SelText = ReplaceVal) Or (SearchType = SRCH_FIND) Then
  'if we've already done this one or we're just finding, we want to go
  'past it to the next one
  StartPos = FAndRControl.SelStart + 2
Else
  'SelStart is 0-based, so we add one to make it one-based (like our text)
  StartPos = FAndRControl.SelStart + 1
End If

'if we haven't selected any text yet, we have to start at position 1
If StartPos = 2 Then StartPos = 1

'hide the form so it won't get in the way of the dialog boxes
Me.Visible = False

'read the check box to see if the search is case sensitive
If MatchCase.Value = 0 Then
  CaseSensitive = 1
Else
  CaseSensitive = 0
End If

'look for the first occurrence of our string
NextPos = InStr(StartPos, (FAndRControl.Text), FindVal, CaseSensitive)

'while we find occurences of our string
While NextPos > 0
  
  'set the value for the next position we'll start looking at
  StartPos = NextPos + 1

  'select the text in the text box
  FAndRControl.SelStart = NextPos - 1
  FAndRControl.SelLength = SearchLen

  'depending on the type of search we're doing
  Select Case SearchType
    'a search and replace, replace the text and keep on going
    Case SRCH_REPLACE
      FAndRControl.SelText = ReplaceVal
    'a verify, if user says to replace, then replace
    Case SRCH_VERIFY
      'move the focus to the text box
      FAndRControl.SetFocus
      If MsgBox("Replace Text?", MB_QUESTION, AppTitle) = MB_YES Then FAndRControl.SelText = ReplaceVal
    'user just wants to find next value
    Case SRCH_FIND
      'move the search starting position to the end of the text so no more matches will
      'be found; it forces the user to keep hitting Find and move on
      StartPos = Len(FAndRControl.Text)
  End Select

  'look for the next occurence of our string
  NextPos = InStr(StartPos, (FAndRControl.Text), FindVal, CaseSensitive)

Wend

'let the user know we've finished replacing
If SearchType <> SRCH_FIND Then MsgBox "Search completed.", 48, AppTitle

'reset the form's visible property so the user can knows what's going on
Me.Visible = True

'set the focus on the text box
FAndRControl.SetFocus

'change pointer back to normal
Screen.MousePointer = 0

End Sub

Sub CenterForm (SForm As Form)

SForm.Top = (Screen.Height - SForm.Height) / 2
SForm.Left = (Screen.Width - SForm.Width) / 2

End Sub

Sub Form_Load ()

'set form caption
Me.Caption = AppTitle

'center the form
CenterForm Me

'set the form tag
Me.Tag = FIND_FORM_TAG

'make the form a top-most window
SetWindowPos Me.hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_SHOWWINDOW

'if text in the control is selected, make it the default search for text
If FAndRControl.SelText <> "" Then FindText.Text = Trim$(FAndRControl.SelText)

'if there's text in the findtext, select it
FindText.SelLength = Len(FindText)

End Sub

