Option Explicit
'
' User Defined Types
'
  '
  ' Used for GetCursor - gets mouse location in screen coordinates.
  '
    Type POINTAPI
      X As Integer
      Y As Integer
    End Type
  '
  ' Used by WM_SYSCOMMAND - converts mouse location.
  '
    Type ConvertPOINTAPI
      xy As Long
    End Type
  '
  ' .INI File Type - holds application .INI file information
  '
    Type INI_FILE_TYPE
      fTop As Single
      fLeft As Single
      nStyle As Integer
      lColor As Long
      nGrab As Integer
    End Type
  '
  ' Screen Size Type - holds screen size info
  '
    Type SCREEN_SIZE_TYPE
      fVGA_HEIGHT As Single
      fVGA_WIDTH As Single
      fSVGA_HEIGHT As Single
      fSVGA_WIDTH As Single
      f1024_HEIGHT As Single
      f1024_WIDTH As Single
    End Type
  '
  ' Screen Rectangle type for API calls
  '
    Type lrect
      Left As Integer
      Top As Integer
      Right As Integer
      Bottom As Integer
    End Type
'
' API Calls
'
  '
  ' Send Windows Message
  '
    Declare Function SendmessageByNum Lib "User" Alias "SendMessage" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, ByVal lParam As Long) As Integer
  '
  ' Get Cursor Position
  '
    Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)
  '
  ' Set Window Position
  '
    Declare Function SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal CX As Integer, ByVal CY As Integer, ByVal wFlags As Integer) As Integer
  '
  ' .INI File Functions
  '
    Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
    Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lplFileName As String) As Integer
  '
  ' Screen Capture Functions
  '
    Declare Function GetDesktopWindow Lib "User" () As Integer
    Declare Function GetDC Lib "User" (ByVal hWnd As Integer) As Integer
    Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
    Declare Function ReleaseDC Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer
    Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, lpRect As lrect)
  '
  ' System Menu API Declarations
  '
    Declare Function GetSystemMenu Lib "User" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
    Declare Function RemoveMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
'
' Module Constants
'
  '
  ' For SetWindowPos API Call
  '
    Const SWP_NOMOVE = 2
    Const SWP_NOSIZE = 1
    Const Flags = SWP_NOMOVE Or SWP_NOSIZE
    Const HWND_TOPMOST = -1
    Const HWND_NOTOPMOST = -2
    Const HWND_BOTTOM = 1
    Const HWND_TOP = 0
  '
  ' .INI file constants
  '
    Const INI_FILENAME = "SCRNTEST.INI"
    Const MAX_INI_STRING = 255
  '
  ' System Menu Constants
  '
    Const MF_SEPARATOR = &H800
    Const MF_STRING = &H0
    Const MF_ENABLED = 0
    Const MF_BYCOMMAND = &H0
    Const MF_UNCHECKED = &H0
    Const MF_CHECKED = &H8
    Const MF_BYPOSITION = &H400
  '
  ' Move Window Message
  '
    Const SC_MOVE = &HF010
'
' Global Constants
'
  '
  ' For Window Movement API calls
  '
    Global Const WM_LBUTTONUP = &H202
    Global Const WM_SYSCOMMAND = &H112
    Global Const MOUSE_MOVE = &HF012
  '
  ' Standard VB Keyboard Constants
  '
    Global Const ALT_MASK = 4
    Global Const KEY_F4 = &H73
    Global Const KEY_LBUTTON = &H1
    Global Const KEY_RBUTTON = &H2
    Global Const KEY_HOME = &H24
    Global Const KEY_LEFT = &H25
    Global Const KEY_UP = &H26
    Global Const KEY_RIGHT = &H27
    Global Const KEY_DOWN = &H28
  '
  ' Standard VB WindowState Constant
  '
    Global Const NORMAL = 0
    Global Const MINIMIZED = 1
  '
  ' Constants for PlaceDialog Subroutine
  '
    Global Const DLG_STANDARD = 0
    Global Const DLG_CENTERED = 1
  '
  ' MsgBox Warning message Constant
  '
    Global Const MB_ICONEXCLAMATION = 48
  '
  ' Form Show Constants
  '
    Global Const MODELESS = 0
    Global Const MODAL = 1
  '
  ' Style Constants (numbers should match menu control arrray on frmUtility)
  '
    Global Const STYLE_VGA = 0
    Global Const STYLE_SVGA = 1
    Global Const STYLE_1024 = 2
'
' Module Variables
'
  '
  ' Throwaway Return variable
  '
    Dim r As Variant
  '
  ' INI variable
  '
    Dim muINIVals As INI_FILE_TYPE
  '
  ' Screen pixel/size type
  '
    Dim muScreenVals As SCREEN_SIZE_TYPE

Sub ExitProgram ()
  '
  ' Centralized Exit from program that saves .INI values
  ' and makes sure that all forms are unloaded prior to
  ' ending
  '
  Dim iLoop As Integer
  SaveINIValues
  For iLoop = Forms.Count - 1 To 0 Step -1
    Unload Forms(iLoop)
  Next
  End
End Sub

Sub GetINIValues ()
  '
  ' Gets INI values from File
  ' (all Topic|Section and Default values are hard coded)
  '
  Dim nSize As Integer
  Dim sReturnString As String
  '
  ' Get Form Top Value
  '
  sReturnString = String$(MAX_INI_STRING, 32)
  nSize = GetPrivateProfileString("Screen Tester", "Top", "300", sReturnString, MAX_INI_STRING, INI_FILENAME)
  muINIVals.fTop = Val(Mid$(sReturnString, 1, nSize))
  '
  ' Get Form Left Value
  '
  sReturnString = String$(MAX_INI_STRING, 32)
  nSize = GetPrivateProfileString("Screen Tester", "Left", "300", sReturnString, MAX_INI_STRING, INI_FILENAME)
  muINIVals.fLeft = Val(Mid$(sReturnString, 1, nSize))
  '
  ' Get Form Style Value
  '
  sReturnString = String$(MAX_INI_STRING, 32)
  nSize = GetPrivateProfileString("Screen Tester", "Style", "0", sReturnString, MAX_INI_STRING, INI_FILENAME)
  muINIVals.nStyle = Val(Mid$(sReturnString, 1, nSize))
  '
  ' Get Form Color Value
  '
  sReturnString = String$(MAX_INI_STRING, 32)
  nSize = GetPrivateProfileString("Screen Tester", "Color", "0", sReturnString, MAX_INI_STRING, INI_FILENAME)
  muINIVals.lColor = Val(Mid$(sReturnString, 1, nSize))
  '
  ' Get Screen Grab Destination Preference
  '
  sReturnString = String$(MAX_INI_STRING, 32)
  nSize = GetPrivateProfileString("Screen Tester", "Grab", "0", sReturnString, MAX_INI_STRING, INI_FILENAME)
  muINIVals.nGrab = Val(Mid$(sReturnString, 1, nSize))
End Sub

Function GetScreenHeight () As Integer
  '
  ' Return Pixel Screen Height based on current style value
  '
  Select Case muINIVals.nStyle
    Case STYLE_VGA
      GetScreenHeight = 480
    Case STYLE_SVGA
      GetScreenHeight = 600
    Case STYLE_1024
      GetScreenHeight = 768
  End Select
End Function

Function GetScreenWidth () As Integer
  '
  ' Return Pixel Screen Width based on current style value
  '
  Select Case muINIVals.nStyle
    Case STYLE_VGA
      GetScreenWidth = 640
    Case STYLE_SVGA
      GetScreenWidth = 800
    Case STYLE_1024
      GetScreenWidth = 1024
  End Select
End Function

Sub GrabScreen ()
  '
  ' Captures Screen area where floating screen is located
  ' and sends it to the Clipboard or to BMP File
  '
  ' This routine is based on information found in the
  ' following Knowledge Base article:
  '
  '   How to Copy Entire Screen into a Picture Box in Visual Basic
  '   Article ID: Q80670
  '
  Dim winSize As lrect
  Dim hWndSrc As Integer
  Dim hSrcDC As Integer
  Dim XSrc As Integer
  Dim YSrc As Integer
  Dim nWidth As Integer
  Dim nHeight As Integer
  Dim hDestDC As Integer
  Dim X As Integer
  Dim Y As Integer
  Dim dwRop As Long
  '
  ' Constant for Clipboard operations
  '
  Const CF_BITMAP = 2
  '
  ' Assign information of the source bitmap.
  ' Note that BitBlt requires coordinates in pixels.
  '
  hWndSrc = GetDesktopWindow()
  hSrcDC = GetDC(hWndSrc)
  Call GetWindowRect(frmMain.hWnd, winSize)
  XSrc = winSize.Left
  YSrc = winSize.Top
  nWidth = GetScreenWidth()
  nHeight = GetScreenHeight()
  '
  ' Assign destination bitmap.
  '
  hDestDC = frmUtility.picCapture.hDC
  X = 0
  Y = 0
  '
  ' Set picture box to same size as screen being grabbed.
  ' If picture box not the same size as picture being
  ' BitBlt'ed to it, it will chop off all that does not
  ' fit in the picture box.
  '
  frmUtility.picCapture.Top = 0
  frmUtility.picCapture.Left = 0
  frmUtility.picCapture.Width = (nWidth + 1) * screen.TwipsPerPixelX
  frmUtility.picCapture.Height = (nHeight + 1) * screen.TwipsPerPixelY
  '
  ' Assign the value of the constant SRCOPYY to the Raster operation.
  '
  dwRop = &HCC0020
  r = BitBlt(hDestDC, X, Y, nWidth, nHeight, hSrcDC, XSrc, YSrc, dwRop)
  '
  ' Release the DeskTopWindow's hDC to Windows.
  ' Windows may hang if this is not done.
  '
  r = ReleaseDC(hWndSrc, hSrcDC)
  If frmUtility!mnuPDDestOpt(0).Checked Then
    '
    ' Copy picture to Clipboard
    '
    Clipboard.SetData frmUtility.picCapture.Image, CF_BITMAP
  ElseIf frmUtility!mnuPDDestOpt(1).Checked Then
    '
    ' Save to BMP File
    '
    SavePictureToFile
  End If
  '
  ' Clear out picture box
  '
  frmUtility.picCapture.Picture = LoadPicture()
End Sub

Sub InitScreenSizeValues ()
  '
  ' Initialize screen size variable type based on current screen.
  '
  muScreenVals.fVGA_HEIGHT = screen.TwipsPerPixelX * 480
  muScreenVals.fVGA_WIDTH = screen.TwipsPerPixelY * 640
  muScreenVals.fSVGA_HEIGHT = screen.TwipsPerPixelX * 600
  muScreenVals.fSVGA_WIDTH = screen.TwipsPerPixelY * 800
  muScreenVals.f1024_HEIGHT = screen.TwipsPerPixelX * 768
  muScreenVals.f1024_WIDTH = screen.TwipsPerPixelY * 1024
End Sub

Sub Main ()
  '
  ' Start of program
  '
  GetINIValues
  InitScreenSizeValues
  Load frmUtility
  frmMain.Show
End Sub

Sub MoveForm (frm As Form)
  '
  ' Issue keyboard Move command to a form
  '
  r = SendmessageByNum(frm.hWnd, WM_SYSCOMMAND, SC_MOVE, 0&)
End Sub

Sub PlaceDialog (frmSource As Form, frmDialog As Form, iPos As Integer)
  '
  ' Place a dialog box (frmDialog) in specified relationship (iPos) to a source form (frmSource)
  '
  ' ****( Current Usage 1/10/95) ****
  '
  ' DLG_STANDARD = Offset dialog form 300 twips to right and 300 twips down from source form
  ' DLG_CENTERED = Center dialog form in relation to source form.
  '
  ' If the display position would place the form outside the screen area, then set it
  ' 60 twips from the edge of the screen.
  '
  '**************************************************************************************************************
  Dim iLeft As Integer
  Dim iTop As Integer
  Select Case iPos
    Case DLG_STANDARD
      iLeft = frmSource.Left + 300
      If iLeft < 0 Then
  iLeft = 60
      ElseIf (iLeft + frmDialog.Width) > screen.Width Then
  iLeft = screen.Width - (frmDialog.Width + 60)
      End If
      iTop = frmSource.Top + 300
      If iTop < 0 Then
  iTop = 60
      ElseIf iTop + frmDialog.Height > screen.Height Then
  iTop = screen.Height - (frmDialog.Height + 60)
      End If
    Case DLG_CENTERED
      iLeft = frmSource.Left + ((frmSource.Width / 2) - (frmDialog.Width / 2))
      If iLeft < 0 Then
  iLeft = 60
      ElseIf (iLeft + frmDialog.Width) > screen.Width Then
  iLeft = screen.Width - (frmDialog.Width + 60)
      End If
      iTop = frmSource.Top + ((frmSource.Height / 2) - (frmDialog.Height / 2))
      If iTop < 0 Then
  iTop = 60
      ElseIf iTop + frmDialog.Height > screen.Height Then
  iTop = screen.Height - (frmDialog.Height + 60)
      End If
    Case Else
      iLeft = frmDialog.Left
      iTop = frmDialog.Top
      MsgBox "Programmer Error!" & Chr$(13) & Chr$(13) & "Invalid iPos sent to PlaceDialog", MB_ICONEXCLAMATION
  End Select
  frmDialog.Move iLeft, iTop
End Sub

Sub SaveColor (lColor As Long)
  '
  ' Save color change in .INI type
  '
  muINIVals.lColor = lColor
End Sub

Sub SaveGrab (nGrab As Integer)
  '
  ' Save Grab destination in .INI Type
  '
  muINIVals.nGrab = nGrab
End Sub

Sub SaveINIValues ()
  '
  ' Saves .INI Values to file (note that Topic|Section values are hard coded)
  '
  r = WritePrivateProfileString("Screen Tester", "Top", CStr(muINIVals.fTop), INI_FILENAME)
  r = WritePrivateProfileString("Screen Tester", "Left", CStr(muINIVals.fLeft), INI_FILENAME)
  r = WritePrivateProfileString("Screen Tester", "Style", CStr(muINIVals.nStyle), INI_FILENAME)
  r = WritePrivateProfileString("Screen Tester", "Color", CStr(muINIVals.lColor), INI_FILENAME)
  r = WritePrivateProfileString("Screen Tester", "Grab", CStr(muINIVals.nGrab), INI_FILENAME)
End Sub

Sub SavePictureToFile ()
  '
  ' Save Captured Image to a BMP File
  '
  On Error Resume Next

  '
  ' File Open/Save Dialog Flag Constants
  '
  Const OFN_OVERWRITEPROMPT = &H2&
  Const OFN_HIDEREADONLY = &H4&
  Const OFN_PATHMUSTEXIST = &H800&
  Const OFN_NOREADONLYRETURN = &H8000&

  frmUtility!dlgUtility.CancelError = True
  frmUtility!dlgUtility.DefaultExt = ".BMP"
  frmUtility!dlgUtility.DialogTitle = "Save Screen Image"
  frmUtility!dlgUtility.Filename = ""
  frmUtility!dlgUtility.Filter = "Bitmaps(*.bmp)|*.bmp"
  frmUtility!dlgUtility.Flags = OFN_OVERWRITEPROMPT Or OFN_HIDEREADONLY Or OFN_PATHMUSTEXIST Or OFN_NOREADONLYRETURN
  frmUtility!dlgUtility.Action = 2
  If Err = 0 Then
    SavePicture frmUtility!picCapture.Image, frmUtility!dlgUtility.Filename
    If Err <> 0 Then
      MsgBox "The following error occured while attempting to save screen picture:" & Chr$(13) & Chr$(10) & Chr$(13) & Chr$(10) & Error$, MB_ICONEXCLAMATION, "File Save Error"
    End If
  End If
  frmUtility!dlgUtility.CancelError = False
  SendFormToBack frmMain
End Sub

Sub SaveScreenPosition ()
  '
  ' Saves Screen Position prior to minimize or after a move.
  '
  muINIVals.fTop = frmMain.Top
  muINIVals.fLeft = frmMain.Left
End Sub

Sub SendFormToBack (frm As Form)
  '
  ' Places form at the lowest in the Zorder
  '
  r = SetWindowPos(frm.hWnd, HWND_BOTTOM, 0, 0, 0, 0, Flags)
End Sub

Sub SetDestCheck (Index As Integer)
  '
  ' Toggle the Check mark on the screen capture
  ' destination menu choices
  '
  Dim iLoop As Integer
  For iLoop = 0 To 1
    If iLoop = Index Then
      frmUtility!mnuPDDestOpt(iLoop).Checked = True
    Else
      frmUtility!mnuPDDestOpt(iLoop).Checked = False
    End If
  Next
  SaveGrab Index
End Sub

Sub SetDialogMenu (frm As Form)
  '
  ' Removes menu items from the System menu of the specified Form (frm)
  ' to achieve a standard dialog look.
  '
  ' ****> MaxButton and MinButton properties must be False and the form's borderstyle must be
  ' ****> Fixed Double in order to achieve the correct effect.  This will
  ' ****> remove all but the MOVE and CLOSE options from the system menu.
  '
  '**************************************************************************************************************
  Dim hSysMenu As Integer
  hSysMenu = GetSystemMenu(frm.hWnd, 0)
  r = RemoveMenu(hSysMenu, 8, MF_BYPOSITION)
  r = RemoveMenu(hSysMenu, 7, MF_BYPOSITION)
  r = RemoveMenu(hSysMenu, 5, MF_BYPOSITION)
End Sub

Sub SetStyle (frm As Form, nStyle As Integer)
  '
  ' Sets the style of the form (VGA, SVGA, 1024), checks the
  ' popup menu and saves this new setting.
  '
  Dim iLoop As Integer
  Select Case nStyle
    Case STYLE_VGA
      frm.Height = muScreenVals.fVGA_HEIGHT
      frm.Width = muScreenVals.fVGA_WIDTH
    Case STYLE_SVGA
      frm.Height = muScreenVals.fSVGA_HEIGHT
      frm.Width = muScreenVals.fSVGA_WIDTH
    Case STYLE_1024
      frm.Height = muScreenVals.f1024_HEIGHT
      frm.Width = muScreenVals.f1024_WIDTH
  End Select
  For iLoop = 0 To 2
    If iLoop = nStyle Then
      frmUtility!mnuPType(iLoop).Checked = True
    Else
      frmUtility!mnuPType(iLoop).Checked = False
    End If
  Next
  muINIVals.nStyle = nStyle
End Sub

Sub SetUpForm (frm As Form, sID As String)
  '
  ' Sets form up based on .INI file info
  '
  Select Case sID
    Case "Main"
      frm.Move muINIVals.fLeft, muINIVals.fTop
      frm.BackColor = muINIVals.lColor
      SetStyle frm, muINIVals.nStyle
    Case "Utility"
      SetDestCheck muINIVals.nGrab
  End Select
End Sub

