/*******************************QSEARCH.DLL**********************************
*   Author  - Jeff Simms  72200,3173	  Date: June 24, 1992		    *
*									    *
*   FindString Routine from FGREP.C author unknown			    *
*   CopyFile Routine from COPY.C author Eric Flo			    *
*   FindFile Routine from FILEFIND.C author unknown			    *
*									    *
*									    *
*   .def and .h files at end	Compiled under MS C 7.0 Compact Model	    *
****************************************************************************/

#include <dos.h>
#include <stdio.h>
#include <direct.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include "qsearch.h"

int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSegment,
				   WORD wHeapSize, LPSTR lpszCmdLine )
{
    if ( wHeapSize != 0 )
	UnlockData( 0 );
    return 1;
}

int FAR PASCAL WEP (int bSystemExit)
{
    return (1);
}


int _export FAR PASCAL FindString(int iSwitch, LPSTR lpPathName,
				 LPSTR lpSearchString, HWND hListBox)
{

	FILE	*hFile;
	char line[132],buff[132],bufftwo[132];
	int	lnum=0,found=0,length;

	if (iSwitch > 0)
	AnsiLower(lpSearchString);

	if (hFile = fopen(lpPathName, "r")){

		while (fgets(line,132,hFile)) {
			lnum++;
		   strcpy(bufftwo,line);

		 if (iSwitch > 0)
		   AnsiLower(line);

	       if (strstr(line,lpSearchString)) {
		  if (iSwitch == 2 || iSwitch == -1){
		      itoa(lnum,buff,10);
		       strcat(buff,": ");
		       strcat(buff,bufftwo);
		    }
		  else
		       strcpy(buff, bufftwo);

		  length = strlen(buff);
		  buff[length-1] = '\0';

	  SendMessage(hListBox,LB_ADDSTRING,0,(LONG)(LPSTR)buff);
				found++;
				}
		}
		  fclose(hFile);
	  }
		  if (hFile)
		    return found;
		  else
		    return (-1);
}


int _export FAR PASCAL CopyFile (LPSTR szSource, LPSTR szDest, BOOL bAttrib)

{


  static int hFileSource, hFileDest;
  OFSTRUCT OpenBuff;
  WORD	  wBytesRead,CHUNKSIZE=32000;
  HANDLE   hMem;
  LPSTR    gPtr;
  static unsigned int uTime, uDate, uAttrib, uResult;


  /* open source file for reading */
  hFileSource = OpenFile (szSource, &OpenBuff, OF_READ | OF_SHARE_DENY_WRITE);
  if (hFileSource == -1)
    return (ERROR_CANNOT_OPEN_SOURCE);

  /* open destination file for writing */
  hFileDest = OpenFile (szDest, &OpenBuff, OF_CREATE | OF_WRITE | OF_SHARE_EXCLUSIVE);
  if (hFileDest == -1)
    {
    _lclose (hFileSource);
    return (ERROR_CANNOT_OPEN_DEST);
    }


  hMem = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, CHUNKSIZE+10);

  if (hMem == 0)
    {
    _lclose (hFileSource);
    _lclose (hFileDest);
    return (ERROR_CANNOT_ALLOCATE_MEMORY);
    }

  gPtr = GlobalLock (hMem);

  if (gPtr == 0)
    {
    GlobalFree (hMem);
    _lclose (hFileSource);
    _lclose (hFileDest);
    return (ERROR_CANNOT_LOCK_MEMORY);
    }

  do
    {
    wBytesRead = (WORD) _lread(hFileSource, gPtr, CHUNKSIZE);
    if (wBytesRead == -1)
        {
        GlobalUnlock (hMem);
        GlobalFree (hMem);
        _lclose (hFileSource);
        _lclose (hFileDest);
        return (ERROR_READING_FILE);
        }
    _lwrite(hFileDest,	gPtr, wBytesRead);
    }
  while (wBytesRead == CHUNKSIZE);


  if (bAttrib)
    {

    uResult = _dos_getftime (hFileSource, &uTime, &uDate);
    if (uResult != 0)
        {
        GlobalUnlock (hMem);
        GlobalFree (hMem);
        _lclose (hFileSource);
        _lclose (hFileDest);
        return (ERROR_GETTING_FILE_DATE_TIME);
        }
    uResult = _dos_setftime (hFileDest, uTime, uDate);
    if (uResult != 0)
        {
        GlobalUnlock (hMem);
        GlobalFree (hMem);
        _lclose (hFileSource);
        _lclose (hFileDest);
        return (ERROR_SETTING_FILE_DATE_TIME);
        }
    }

  GlobalUnlock (hMem);
  GlobalFree (hMem);
  _lclose (hFileSource);
  _lclose (hFileDest);

  if (bAttrib)
    {
    /* Query and set file attributes */
    uResult = _dos_getfileattr ( szSource, &uAttrib);
    if (uResult != 0)
        return (ERROR_GETTING_FILE_ATTRIB);

    uResult = _dos_setfileattr (szDest, uAttrib);
    if (uResult != 0)
        return (ERROR_SETTING_FILE_ATTRIB);
    }

  return (SUCCESS);
  }


static char	file[13],dletter[1];
unsigned int	found=0,lbhandle;
int		drive;

int _export FAR PASCAL FindFile (LPSTR szDrive,LPSTR szPattern,HWND hListBox)

{

	char	 rootpath[128];

	lstrcpy(file,szPattern);
	lbhandle = hListBox;
	found = 0;
	rootpath[0]='\0';
	strcat(rootpath, "\\");
	dletter[0]=(char)toupper(szDrive[0]);
	drive = dletter[0] - 64;
	if (_chdrive(drive))
	     return (-1);

	do_a_dir(rootpath);

	return found;

}

   void do_a_dir(char currentpath[128])

{
	char	nextpath[128];
	char	searchpath[128];
	char	fullname[128];
	unsigned done;
	struct	find_t ffblk;

	strcpy(searchpath,currentpath);
	strcat(searchpath,file);

	done = _dos_findfirst(searchpath,_A_HIDDEN,&ffblk);

	while (!done) {
		strcpy(fullname,dletter);
		strcat(fullname,":");
		strcat(fullname,currentpath);
		strcat(fullname,ffblk.name);
		SendMessage(lbhandle,LB_ADDSTRING,0,(LONG)(LPSTR)fullname);
		found++;
		done = _dos_findnext(&ffblk);
	}

	strcpy(searchpath,currentpath);
	strcat(searchpath,"*.*");

	done = _dos_findfirst(searchpath,_A_SUBDIR,&ffblk);

	while (!done) {
		if (ffblk.attrib == _A_SUBDIR && ffblk.name[0] != '.') {
			strcpy(nextpath,currentpath);
			strcat(nextpath,ffblk.name);
			strcat(nextpath,"\\");
			do_a_dir(nextpath);
		}
		done = _dos_findnext(&ffblk);
	}

}


/*	       QSEARCH.DEF

LIBRARY        QSEARCH
DESCRIPTION    'STRING SEARCHING DLL'
EXETYPE        WINDOWS
CODE	       PRELOAD MOVEABLE DISCARDABLE
DATA	       PRELOAD MOVEABLE SINGLE
HEAPSIZE       1024
EXPORTS        WEP
	       FindString
	       CopyFile
	       FindFile

*/

/*		QSEARCH.H

int _export FAR PASCAL FindString(BOOL,LPSTR,LPSTR,HWND);
int _export FAR PASCAL CopyFile (LPSTR,LPSTR,BOOL);
int _export FAR PASCAL FindFile (LPSTR,LPSTR,HWND);

void do_a_dir(char currentpath[128]);

#define SUCCESS                       0
#define ERROR_CANNOT_OPEN_SOURCE      1
#define ERROR_CANNOT_OPEN_DEST        2
#define ERROR_CANNOT_ALLOCATE_MEMORY  3
#define ERROR_CANNOT_LOCK_MEMORY      4
#define ERROR_READING_FILE            5
#define ERROR_GETTING_FILE_DATE_TIME  6
#define ERROR_SETTING_FILE_DATE_TIME  7
#define ERROR_GETTING_FILE_ATTRIB     8
#define ERROR_SETTING_FILE_ATTRIB     9


*/
