{ This DLL Source code is provided as a sample to show how to write DLL's for
  Visual Basic as well as Turbo Pascal for Windows }

{ Provided by Joe Palmer
  Balto., Md }

Library Psetup;

Uses WinTypes, WinProcs, WObjects, Strings;

Type
    TDeviceMode =
      Procedure(HWindow: HWnd; Module: THandle;
        DeviceName, OutPutName: PChar);

    TExtDeviceMode =
      function(Hwindow: HWnd; Hdriver: THandle; DevModeOutPut: PDevMode;
        DeviceName, PortName: PChar; DevModeInput: PDevMode;
        ProFile: PChar; Mode: Word):Integer;

Var
  DeviceMode: TDeviceMode;
  ExtDeviceMode: TExtDeviceMode;

Procedure CallPsetup(HWindow: HWnd; DriverName: PChar; DeviceName:PChar; PortName: PChar; OutPutName: PChar); export;
Var
  HDriver: THandle;
  DevModeOutput: PDevMode;
  DevModeInPut: PDevMode;
  P: TfarProc;
  Size: Integer;
begin
  if (StrLen(DriverName)= 0) or (StrLen(OutPutName) = 0) then
    begin
      MessageBox(HWindow, 'No Printer Installed', 'Error', mb_Ok);
      Exit;
    end;
  HDriver:= LoadLibrary(DriverName);
  if HDriver < 32 then
    MessageBox(HWindow, 'Failed to load driver', 'Error', mb_IconExclamation or mb_ok)
  else
    begin
      p:= GetProcAddress(HDriver, 'ExtDeviceMode');
      if p <> nil then
        begin
          ExtDeviceMode:= TExtDeviceMode(p);
          Size:= ExtDeviceMode(Hwindow, Hdriver, nil, DeviceName, OutputName, nil, nil, 0);
          GetMem(DevModeOutPut, Size);
          GetMem(DevModeInput, Size);
          ExtDeviceMode(Hwindow, HDriver, DevModeOutput, DeviceName, PortName, DevModeInPut, nil, dm_Prompt or dm_Copy
                         or dm_UpDate) ;
          FreeMem(DevModeOutput, Size);
          FreeMem(DevModeInput, Size);
        end Else
        begin
          P:= GetProcAddress(HDriver, 'DeviceMode');
          if P <> nil then
            begin
              DeviceMode:= TDeviceMode(P);
              DeviceMode(HWindow, HDriver, DeviceName, OutputName)
            end
          end;
          FreeLibrary(HDriver);
        end;
      end;
     Exports
       CallPSetup index 1;
     begin
     end.
