Option Explicit

Dim tfPrintCancelled As Integer

Type typWindowsDevice
   sWindowsDeviceUserName As String
   sWindowsDeviceShortName As String
   sWindowsDevicePortName As String
End Type

Const sWINDOWS_SECTION_NAME = "windows"
Const sDEVICES_SECTION_NAME = "devices"
Const sDEVICE_KEY_NAME = "device"

Declare Function duprt_nAbortDoc Lib "GDI" Alias "AbortDoc" (ByVal hDC As Integer) As Integer
Declare Function duprt_nSetSysModalWindow Lib "User" Alias "SetSysModalWindow" (ByVal hWnd As Integer) As Integer

Sub duprt_BeginDoc ()

'This routine must be called at the beginning of the print
'job to initialize the "cancel" flag and popup the status
'window.

Dim nRC As Integer


'Initialize the "cancel" flag.

tfPrintCancelled = False

'Display the status window.  Note that as far as VB is concerned,
'the window is not MODAL.  This is what allows the print job to
'proceed in the "background".

Load frmPrt
frmPrt.Move (Screen.Width - frmPrt.Width) / 2, (Screen.Height - frmPrt.Height) / 2
frmPrt.Show

'Tell Windows to treat the status window as "System Modal".

nRC = duprt_nSetSysModalWindow(frmPrt.hWnd)

End Sub

Sub duprt_CancelDoc ()

'This routine should be called if the user cancels the
'print job, to flush it from the print queue.

Dim nRC As Integer


If tfPrintCancelled Then
   'do nothing; shouldn't call this routine
   'more than once per print job.
Else
   'Flush the output from the print queue.

   nRC = duprt_nAbortDoc(Printer.hDC)

   'Close the Printer object.  Error-trapping is
   'mandatory here, because the Printer object and
   'the AbortDoc API function don't always get along.

   On Error Resume Next

   Printer.EndDoc

   On Error GoTo 0
   
   'Set the "cancel" flag

   tfPrintCancelled = True
End If

End Sub

Sub duprt_EndDoc ()

'This routine should always be called at the end of the
'print job to close the status window, whether the user
'cancels the output or not.


If tfPrintCancelled Then
   'do nothing; shouldn't call this routine
   'more than once per print job.
Else
   'Close the print job.

   Printer.EndDoc
End If

'Close the status window.

frmPrt.Hide
Unload frmPrt

Set frmPrt = Nothing

End Sub

Sub duprt_GetDefaultPrinter (recDefaultPrinter As typWindowsDevice)

'This routine returns the "default" Windows printer.

Dim nStrPos As Integer
Dim sDefaultPrinter As String
Dim nRC As Integer


sDefaultPrinter = duini_sGetString(sWINDOWS_SECTION_NAME, sDEVICE_KEY_NAME, "", "")
nStrPos = InStr(sDefaultPrinter, ",")

recDefaultPrinter.sWindowsDeviceUserName = Left$(sDefaultPrinter, nStrPos - 1)

sDefaultPrinter = Mid$(sDefaultPrinter, nStrPos + 1)
nStrPos = InStr(sDefaultPrinter, ",")

recDefaultPrinter.sWindowsDeviceShortName = Left$(sDefaultPrinter, nStrPos - 1)
recDefaultPrinter.sWindowsDevicePortName = Mid$(sDefaultPrinter, nStrPos + 1)

End Sub

Sub duprt_GetInstalledPrinters (recInstalledPrinters() As typWindowsDevice)
    
'This routine enumerates the "installed" Windows printers.

Dim nStrPos As Integer, nPrtSub As Integer
Dim sInstalledPrinter As String
ReDim sPrinterNames(0) As String


Call duini_GetKeyNames(sDEVICES_SECTION_NAME, sPrinterNames(), "")

ReDim recInstalledPrinters(UBound(sPrinterNames))
    
For nPrtSub = 1 To UBound(sPrinterNames)
   sInstalledPrinter = duini_sGetString(sDEVICES_SECTION_NAME, sPrinterNames(nPrtSub), "", "")
   nStrPos = InStr(sInstalledPrinter, ",")

   recInstalledPrinters(nPrtSub).sWindowsDeviceUserName = sPrinterNames(nPrtSub)
   recInstalledPrinters(nPrtSub).sWindowsDeviceShortName = Left$(sInstalledPrinter, nStrPos - 1)

   sInstalledPrinter = Mid$(sInstalledPrinter, nStrPos + 1)
   nStrPos = InStr(sInstalledPrinter, ",")

   If nStrPos > 0 Then
      recInstalledPrinters(nPrtSub).sWindowsDevicePortName = Left$(sInstalledPrinter, nStrPos - 1)
   Else
      recInstalledPrinters(nPrtSub).sWindowsDevicePortName = sInstalledPrinter
   End If
Next

End Sub

Sub duprt_SetDefaultPrinter (recDefaultPrinter As typWindowsDevice)
    
'This routine sets the "default" Windows printer to one
'of the "installed" printers.

Dim sNewPrinter As String
Dim nRC As Integer


sNewPrinter = recDefaultPrinter.sWindowsDeviceUserName + "," + recDefaultPrinter.sWindowsDeviceShortName + "," + recDefaultPrinter.sWindowsDevicePortName
    
Call duini_WriteString(sWINDOWS_SECTION_NAME, sDEVICE_KEY_NAME, sNewPrinter, "")
Call duini_WININIChange(sWINDOWS_SECTION_NAME)

End Sub

Sub duprt_StatusDoc (sPrintCaption As String, sPrintDesc As String, sPrintStatus As String)

'This routine updates the status window with new
'information, to show the progress of the print job.

If Len(sPrintCaption) > 0 Then
   frmPrt.Caption = sPrintCaption
   frmPrt.Refresh
End If

If Len(sPrintDesc) > 0 Then
   frmPrt.lblPrintDesc.Caption = sPrintDesc
   frmPrt.lblPrintDesc.Refresh
End If

If Len(sPrintStatus) > 0 Then
   frmPrt.lblPrintStatus.Caption = sPrintStatus
   frmPrt.lblPrintStatus.Refresh
End If

End Sub

Function duprt_tfPrintCancelled () As Integer

'This routine checks to see if the print job has been
'cancelled.  It should be called periodically by your
'application's print routine.


'Allow queued events to be processed, so a click on
'the Cancel button will be recognized.

DoEvents

'Return the status of the "cancel" flag.

duprt_tfPrintCancelled = tfPrintCancelled

End Function

