                                Introducing
                                
                                  PDQComm
                                  
                                For Windows


                          Communications Support

                             For Visual Basic




OVERVIEW

PDQComm for Windows is a comprehensive library of subroutines and functions
for adding communications to programs written in Visual Basic.  It contains
both high- and low-level routines for controlling the communications ports,
sending and receiving text and binary data, and emulating popular terminal
protocols.  All of the Assembler, C, and Visual Basic source code is included
so you can see how the routines work and even modify them if you want to.


LOW-LEVEL SERVICES

Numerous low-level routines are provided to open and close the ports, and
control fully all aspects of on-line communications.  You can access Com 1
through Com 4 at speeds up to 19,200 Baud, with up to two ports open at one
time.  Both transmit and receive buffers are employed, so your program can
send a long stream of data and resume immediately.  Likewise, data that
arrives while your program is busy is stored automatically in a receive
buffer.  This lets you retrieve the data later when your program is ready to
handle it.

Other low-level services let you input text line by line, read the status of
the hardware lines, determine if any characters have been received and how
many, read the current status of any open port, and much more.  You can even
change port parameters while they are open.  For instance, if your program
answers the phone at 2400 baud but the caller connects using 1200, your
program can determine that and change speeds automatically.

All of the subroutines and functions are modeled after their counterparts in
regular compiled BASIC, letting you port existing code with as few changes as
possible.  As an example, where regular BASIC uses the LOC function to report
how many characters are waiting to be read, PDQComm for Windows uses a
function named ComLoc.

Non-standard protocols are also supported such as 8 data bits with 2 stop
bits and also odd or even parity.  The timed Line Input routine is especially
valuable because it prevents the application from locking up if the sender
never sends a Chr$(13) byte to end the current line.  Both hardware (RTS) and
software (Xon/Xoff) handshaking are fully supported, and handled
automatically by the transmit and receive routines.



HIGH-LEVEL ROUTINES

File transfer subroutines are provided for sending and receiving using a
variety of popular protocols.  These include XModem, XModem-1K, YModem, and
plain ASCII.  You simply provide the name of the file, and call the
appropriate routine.  The file transfer begins immediately, and its progress
is displayed on your form.  If you prefer, the status display can be
disabled.  Once a transfer has begun you can switch to another Windows
session, and the transfer will continue in the background.



THE TEXT WINDOW CONTROL

A unique text window custom control lets you simulate DOS-style output with
full or partial scrolling.  The window may be sized at runtime, and it will
contain the text output within the window borders.  Settable properties let
you control both vertical and horizontal scrolling independently, to either
scroll the screen as new text arrives or let it disappear below or to the
right of the output window.  This avoids the "jitter" effect you may have
seen with text output from other companies.



TERMINAL EMULATIONS

A complete set of standard terminal emulations are provided, including ANSI,
DEC VT52 and VT100, Data General D215, and generic terminals.  The ANSI
emulation lets you display text embedded with all of the color and cursor
positioning codes recognized by ANSI.SYS, but without having to use that
driver.  The other emulations simplify communicating with minicomputers and
mainframes that use those protocols.  These emulations work in conjunction
with the text window control, and different emulations can even be employed
simultaneously.



SUBROUTINE LIST

There isn't enough room here to describe all of the features in PDQComm in
detail, but the function and subroutine list that follows describes each of
the low-level routines briefly.  Not listed are the high-level routines for
sending and receiving data (XModem, YModem, and ASCII), or the routines that
interpret the terminal emulation codes.

Functions:
==========

CheckSum returns the checksum value of a string.
    
ComEof reports if any characters have arrived and are waiting to be read.

ComErr is queried to see if an error has occurred.

ComInput reads a specified number of characters.

ComLineInput reads a single line of text in one operation.

ComLoc reports how many characters have been received and are pending.

CRC16 (Cyclical Redundancy Check, 16-bit method) aids error correction.

OverRun checks the receive buffer for an overflow error.

PDQExist reports if a file exists, but without requiring On Error.

PDQTimer returns the current number of system timer ticks.

ScanCodes searches a string for control characters (used by the emulators).

XOff reports if the sender has transmitted an XOff character.


Subroutines:
============

AdjustRecBuffer sets the halt and resume points when using handshaking.

CloseCom closes the specified port.

ComPrint is used to send data through the communications ports.

ComPutBack lets you place data already read back into the receive buffer.

DTR sets the state of the hardware DTR line.

FlushBuffer resets the receive buffer and discards its contents.

FlushSendBuffer is like FlushBuffer, but works with the transmit buffer.

GetLineStatus returns the status of the CTS, DTR, and RI hardware lines.

GetPortConfig retrieves the current parameters for an open port.

OpenCom opens a port, and is equivalent to Basic's OPEN "COM" statement.

Pause halts a program for a specified period.

PDQPrint is used to send text to the TxtWnd custom control.

RTS sets the state of the hardware RTS line.

SendBreak sends a break signal for a specified period.

SetActivePort lets you specify which Com port is to be accessed.

SetCom lets you modify the parameters for a port that is already open.

SetComErr allows a Visual Basic program to set an error condition.

SetHandshaking changes the handshaking method for a port that is open.

WScroll lets you manually scroll text in the TxtWnd custom control.



SUPERB DOCUMENTATION

The PDQComm for Windows manual contains extensive tutorial information,
including a complete overview of communications in general.  Additional
tutorials explain modems, serial cables, specifying port parameters, and
UARTs.  All of the important standard Hayes commands are described in detail,
and each emulation includes a table of all codes that are recognized.


WHAT'S INCLUDED

PDQComm for Windows comes with a comprehensive owner's manual, demonstrations
(including a complete terminal program), and fully commented source code.
PDQComm for Windows is not copy protected, and royalties are not required
when the routines are added to your executable programs.  Free technical
support is included.

                ===========================================

Crescent Software publishes many other useful products for programmers using
Visual Basic, QuickBASIC, and BASIC PDS.  We offer general purpose toolboxes,
as well as subroutines for graphics, screen design, scientific applications,
BASIC TSR utilities, and much more.  All products include complete source
code, and royalties are never required.  Please call or write for more
information on our entire line.


Crescent Software, Inc.
32 Seventy Acres
West Redding, CT  06896
     Phone: 203-438-5300
       Fax: 203-431-4626
CompuServe: 72657,3070
