{ (c) by Kai Oliver Marohn }
{        Stormstrae 19    }
{        44651 Herne       }
{$F+,N+,C FIXED MOVEABLE DISCARDABLE}
{$R QUICKHLP}
{DEFINE SHAREWARE}
{$DEFINE RUNTIME}
Library QUICK;
Uses WinTypes,WinProcs,VBAPI_,Strings,Win31,Objects;

Const QDISPLAY:PCHAR = 'QuickDisplay';
      ControlSEG     = 'QHCTRLSEG';
      ControlOFS     = 'QHCTRLOFS';

Type PQUICK = ^TQUICK;
     TQUICK = Record
                LinkedCTL : hCTL;
                Quick     : hWnd;
                hFont     : hFont;
                HLPWnd    : hWnd;
                Status    : Boolean; {False = Nix; True = Hilfemodus}
                CNT       : Byte;
              End;

Var Gen               : TQUICK;         {}
    DLLUSE            : Integer;

{zustzliche Properties ! begin}
{zustzliche Properties ! end}

Const   IDBMP_QUICK        =8000; {Resourceid fuer die Bitmaps im Toolbar}
        IDBMP_QUICKDOWN    =8001;
        IDBMP_QUICKMONO    =8003;
        IDBMP_QUICKEGA     =8006;


Const   VBX_COMPANYNAME 	   ='Oliver Marohn';
        VBX_FILEDESCRIPTION	   ='Visual Basic Custom Control Beisiel';
        VBX_INTERNALNAME	   ='QUICK';
        VBX_LEGALCOPYRIGHT	   ='Copyright \251 Oliver Marohn 94';
        VBX_LEGALTRADEMARKS	   ='Microsoft\256 is a registered trademark of Microsoft Corporation';
        VBX_ORIGINALFILENAME	   ='G.VBX';
        VBX_PRODUCTNAME 	   ='Microsoft\256 Visual Basic\231 for Windows\231\0';

        VBX_VERSION		   ='3,00,0,00';
        VBX_VERSION_STR 	   ='3.00.000\0';


Const IPROP_QUICK_CTLNAME          =    0;  {fr den Zugriff auf die einzelnen Prporties}
      IPROP_QUICK_LEFT             =    1;
      IPROP_QUICK_TOP              =    2;
      IPROP_QUICK_PARENT           =    3;
      IPROP_QUICK_TAG              =    4;
      IPROP_QUICK_HWND             =    5;
      IPROP_QUICK_ALIGN            =    6;
      IPROP_QUICK_FONTNAME         =    7;
      IPROP_QUICK_FONTBOLD         =    8;
      IPROP_QUICK_FONTITALIC       =    9;
      IPROP_QUICK_FONTSTRIKE       =   10;
      IPROP_QUICK_FONTUNDER        =   11;
      IPROP_QUICK_FONTSIZE         =   12;

Const numPR =  13; {Anzahl der Properties}
Type TPR = Array[0..numPR] of OfsPPROPINFO;
Const
 QUICK_Properties:TPR =
    (
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_TAG,
    PPROPINFO_STD_HWND,
    PPROPINFO_STD_ALIGN,
    PPROPINFO_STD_FONTNAME,
    PPROPINFO_STD_FONTBOLD,
    PPROPINFO_STD_FONTITALIC,
    PPROPINFO_STD_FONTSTRIKE,
    PPROPINFO_STD_FONTUNDER,
    PPROPINFO_STD_FONTSIZE,
    0
    );

Const numEV = 0; {Anzahl der Events}
Type TEV = Array[0..numEV] of OfsPEVENTINFO;

Const
 QUICK_Events:TEV=
    (
    0
    );

Const DCN  : Array[0..9] of Char = 'QuickHELP';    {Der Contol Name}

Var EV : TEV;
    PR : TPR;

Const
  cmodelQUICK:TMODEL =
    (
    usVersion : VB_VERSION;		        { VB version being used}
    fl:MODEL_fInVisAtRun or MODEL_fInitMsg;                       { Model Flags}
    ctlproc:Nil;		                { Control procedure in INIT einsetzen}
    fsClassStyle:0;	                        { Class style}
    flWndStyle:0;			        { Default Windows style}
    cbCtlExtra:SizeOf(TQUICK);   		        { Size of QUICK structure}
    idBMPPalette:IDBMP_QUICK;			{ Palette bitmap ID}
    DefCtlName:Ofs(DCN);			{ Default control name in INIT einsetzen}
    ClassName:Ofs(DCN);				{ Visual Basic class name in INIT einsetzen}
    ParentClassName:0;				{ Parent class name}
    propList:0;			                { Property information table in INIT einsetzen}
    eventlist:0;			        { Event information table in INIT einsetzen}
    nDefProp:IPROP_QUICK_CTLNAME;               { Default property}
    nDefEvent:Byte(-1);	                        { Default event}
    nValueProp:Byte(IPROP_QUICK_CTLNAME)        { Property representing value of ctl}
    );


{Hilfsfunktionen in C als Makro}
Function lpQUICKDEREF(hCtl:hCtl):PQUICK;
Begin;
  lpQUICKDEREF:=PQUICK(VBDerefControl(hCtl));
End;

Function GetSTDPropIndex(Ctl:hCtl;Prop:ofsPPROPINFO;Modell:lpModel):Integer;
Type PropArray = Array[0..100] of OfsPPROPINFO;
     PPropList = ^PropArray;

Var  lpPropList : PPROPLIST;
     i          : Integer;

Begin;
  GetSTDPropIndex:=-1;
  lpPropList:=PPropList(MakeLong(Modell^.PropList,Seg(Modell^)));
  i:=0;
  While (lpPropList^[i]<>0)  do
  begin;
    If lpPropList^[i]=Prop Then
    Begin;
      GetSTDPropIndex:=i;
      Exit;
    End;
    Inc(i);
  End;
End;

Function QUICKCtlProc(MyCtl:HCTL;Wnd:HWnd;msg,wp:USHORT;lp:LongInt):LongInt; export;
Var WFromPT   : hWnd;
    MPos      : TPoint;
    CTLFromPt : hCtl;
    TMPHSZ    : HSZ;
    iTag      : Integer;
    l         : LongInt;
    CTLMod    : lpModel;
    lpStr     : PChar;
    RetStr    : Array[0..255] of Char;
    DumStr    : Array[0..255] of Char;
    e,d       : Integer;

  Procedure ShowHelp;
  Begin;
    StrCopy(RetStr,'');
    If isWindow(WFromPt) And
       isWindowVisible(WFromPt) And
       isWindowEnabled(WFromPt) Then
    Begin;
      CTLFromPt:=VBGetHWNDControl(WFromPt);
      If CTLFromPt<>Nil Then
      Begin;
        CTLMod:=VBGetControlModel(CTLFromPt);
        If CTLMod<>Nil Then
        Begin;
          iTag:=GetSTDPropIndex(CTLFromPt,ppropinfo_Std_TAG,CTLMod);
          If iTag<>-1 Then
          Begin;
            l:=VBGetControlProperty(CTLFromPt,iTag,@TMPHsz);
            If l=0 then
            Begin;
              lpStr:=VBLockHSZ(TMPHsz);
              If (lpStr<>Nil) And (StrLIComp(lpStr,'@',1)=0) Then
              Begin;
                StrCopy(RetStr,lpStr+1);
                VBUnLockHSZ(TMPHsz);
                VBDestroyHsz(TMPHsz);
              End;
            End;
          End;
        End;
      End;
    End;
    SendMessage(lpQUICKDEREF(MyCtl)^.Quick,WM_SETTEXT,0,LongInt(@RetStr));
  End;

Begin
  Case msg of
    WM_NCCREATE :
      Begin;
        lpQUICKDEREF(MyCtl)^.HLPWnd:=0;
        lpQUICKDEREF(MyCtl)^.Status:=False;
        lpQUICKDEREF(MyCtl)^.CNT:=0;
      End;
    WM_SETFONT :
      Begin;
        lpQUICKDEREF(MyCtl)^.hFont:=wp;
        QUICKCtlProc:=0;
        Exit;
      End;
    WM_GETFONT :
      Begin;
        QUICKCtlProc:=lpQUICKDEREF(MyCtl)^.hFont;
        Exit;
      End;
    WM_CREATE :
      If (VBGetMode=MODE_RUN) Then
      Begin;
        lpQUICKDEREF(MyCtl)^.Quick:=CreateWindow(QDISPLAY,
                 Nil,
                 WS_BORDER or WS_POPUP {or WS_VISIBLE},
                 10,10,100,50,Wnd,0,HINSTANCE,Nil);;
        SetProp(lpQUICKDEREF(MyCtl)^.Quick,ControlSEG,LongRec(MyCtl).Hi);
        SetProp(lpQUICKDEREF(MyCtl)^.Quick,ControlOFS,LongRec(MyCtl).Lo);
        SetTimer(WND,4711,100,Nil);
      End;
    WM_DESTROY:
      Begin;
        If (VBGetMode=MODE_RUN) Then
        Begin;
          KillTimer(WND,4711);
          RemoveProp(lpQUICKDEREF(MyCtl)^.Quick,ControlSEG);
          RemoveProp(lpQUICKDEREF(MyCtl)^.Quick,ControlOFS);
          DestroyWindow(lpQUICKDEREF(MyCtl)^.Quick);
        End;
      End;
    WM_TIMER:
      Begin;
        If (VBGetMode=MODE_RUN) Then
        Begin;
          If (Hi(GetKeyState(VK_LBUTTON)) And 128 = 128) or
             (Hi(GetKeyState(VK_RBUTTON)) And 128 = 128) or
             (Hi(GetKeyState(VK_MBUTTON)) And 128 = 128) Then
          Begin;
            ShowWindow(lpQUICKDEREF(MyCtl)^.Quick,SW_HIDE);
            lpQUICKDEREF(MyCtl)^.CNT:=0;
            lpQUICKDEREF(MyCtl)^.HLPWnd:=0;
            lpQUICKDEREF(MyCtl)^.Status:=False;
            Exit;
          End;
          GetCursorPos(MPos);
          WFromPt:=WindowFromPoint(MPos);
          If WFromPt=lpQUICKDEREF(MyCtl)^.Quick then
          Begin;
            ShowWindow(lpQUICKDEREF(MyCtl)^.Quick,SW_HIDE);
            lpQUICKDEREF(MyCtl)^.CNT:=0;
            lpQUICKDEREF(MyCtl)^.HLPWnd:=0;
            lpQUICKDEREF(MyCtl)^.Status:=False;
            Exit;
          End;
          If lpQUICKDEREF(MyCtl)^.Status Then
          Begin;
            If (WFromPt<>lpQUICKDEREF(MyCtl)^.HLPWnd) And
               (lpQUICKDEREF(MyCtl)^.CNT<=10) Then  {Neues Fenster}
            Begin;
              lpQUICKDEREF(MyCtl)^.CNT:=0;
              lpQUICKDEREF(MyCtl)^.HLPWnd:=WFromPt;
              ShowHelp;
            End;
          End Else
          Begin;  {Hilfe noch nicht angezeigt}
            Inc(lpQUICKDEREF(MyCtl)^.CNT);
            If lpQUICKDEREF(MyCtl)^.CNT>=40 Then
            Begin;
              lpQUICKDEREF(MyCtl)^.CNT:=0;
              lpQUICKDEREF(MyCtl)^.HLPWnd:=WFromPt;
              ShowHelp;
            End;
          End;
        End;
      End;
  End;
  QUICKCtlProc:=VBDefControlProc(MyCtl, Wnd, msg, wp, lp);
End;

Var modelQUICK    : TModel;

Function QDISPLAYFN(MyWnd: HWnd; Message, WParam: Word;LParam: Longint): LongInt; export;
Var MyDC   : hDC;
    R      : TRect;
    MPos,
    WPos   : TPoint;
    MyCtl  : hCtl;
    OldFont: hFont;
    WndR   : TRect;


Begin;
  Case Message of
    WM_SETTEXT :
       Begin;
         LongRec(MyCtl).Hi:=GetProp(MyWnd,ControlSEG);
         LongRec(MyCtl).Lo:=GetProp(MyWnd,ControlOFS);
         ShowWindow(MyWnd,SW_HIDE);
         If StrLen(PCHAR(lParam))<>0 Then
         Begin;
           lpQUICKDEREF(MyCtl)^.Status:=True;
           GetCursorPos(MPos);
           MyDC:=GetDC(MyWnd);
           If lpQUICKDEREF(MyCtl)^.hFont<>0
             then OldFont:=SelectObject(MyDc,lpQUICKDEREF(MyCtl)^.hFont)
             else OldFont:=SelectObject(MyDc,GetStockObject(SYSTEM_FONT));
           DrawText(MyDC,PCHAR(LParam),-1,R,DT_CENTER or DT_SINGLELINE or DT_CALCRECT);
           InflateRect(R,5,1);
           GetWindowRect(lpQUICKDEREF(MyCtl)^.HLPWnd,WndR);

           WPos.Y:=MPos.Y+GetSystemMetrics(SM_CYCURSOR)-10;
           WPos.X:=MPos.X-2;
           If WPos.Y+(R.Bottom-R.Top)>GetSystemMetrics(SM_CYSCREEN)
             then WPos.Y:=MPos.Y-(R.Bottom-R.Top) -10;

           If WPos.X+(R.Right-R.Left)>GetSystemMetrics(SM_CXSCREEN)
             then WPos.X:=GetSystemMetrics(SM_CXSCREEN)-(R.Right-R.Left);

           SetWindowPos(MyWnd,0,
             WPos.X,
             WPos.Y,
             (R.Right-R.Left),
             (R.Bottom-R.Top),
              SWP_NOZORDER or SWP_NOACTIVATE);

           ShowWindow(MyWnd,SW_SHOWNOACTIVATE);
           SetBKMode(MyDC,TRANSPARENT);
           GetClientRect(MyWnd,R);
           DrawText(MyDC,PCHAR(LParam),-1,R,DT_CENTER or DT_SINGLELINE or DT_VCENTER);
           SelectObject(MyDC,OldFont);
           ReleaseDC(MyWnd,MyDC);
         End Else
           Begin;
             If lpQUICKDEREF(MyCtl)^.CNT>10 Then
             Begin;
               lpQUICKDEREF(MyCtl)^.Status:=False;
               lpQUICKDEREF(MyCtl)^.CNT:=0;
             End Else
             Begin;
               lpQUICKDEREF(MyCtl)^.Status:=False;
               Inc(lpQUICKDEREF(MyCtl)^.CNT);
             End;
           End;
       End;
    Else QDISPLAYFN:=DefWindowProc(MyWnd,Message,wParam,lParam);
  End;
End;

Function VBINITCC(usVersion:UShort;fRuntime:Bool):Bool; export;
Var ClassInfo : TWndClass;
Const SmallAbout : PChar =
                        'Dies ist die VBX Runtimeversion!'#10#13#10#13#9+
                        'Oliver Marohn'#10#13#9+
                        'Stormstrasse 19'#10#13#10#13#9+
                        '44651 Herne';
Begin;
{$IFDEF RUNTIME}
  If Not(fRuntime) then
  Begin;
    MessageBox(Getfocus,SmallAbout,'ACHTUNG !',MB_OK or MB_ICONSTOP);
    Exit;
  End;
{$ENDIF}
  Inc(DLLUSE);
  If DLLUSE=1 Then
  Begin;
    With ClassInfo do
    Begin;
      Style:=CS_SAVEBITS or CS_VREDRAW or CS_HREDRAW;
      lpfnWndProc:=@QDISPLAYFN;
      cbClsExtra:=0;
      cbWndExtra:=0;
      hIcon:=0;
      hCursor:=LoadCursor(0,IDC_ARROW);
      hBrBackGround:=CreateSolidBrush(RGB(255,255,$80));
      lpszMenuName:=Nil;
      lpszClassName:=QDISPLAY;
    End;
    ClassInfo.hInstance:=HINSTANCE;
    If Not RegisterClass(ClassInfo) then
    Begin;
      MessageBox(Getfocus,'ERROR !','',MB_OK);
    End
  End;
  VBINITCC:= VBRegisterModel(HINSTANCE, modelQUICK);
End;

Procedure VBTERMCC; export;
Begin;
  Dec(DLLUSE);
  If DLLUSE=1 Then
  Begin;
    UnRegisterClass(QDISPLAY,HINSTANCE);
  End;
End;

exports
 VBINITCC           index 1,
 QUICKCtlProc       index 2,
 VBTERMCC           Index 3,
 QDISPLAYFN         Index 4;

Begin;
  DLLUSE:=0;
  modelQUICK:=cModelQUICK;                     {defaults setzen}
  ModelQUICK.ctlProc:=@QUICKCtlProc;           {und die die nicht in Pascalsyntax defenierbaren}
                                                 {hier einsetzen}
  EV:=QUICK_EVENTS;

  PR:=QUICK_Properties;

  ModelQUICK.PropList:=Ofs(PR);
  ModelQUICK.EventList:=Ofs(EV);
End.
