Option Explicit
'
' Common API Declarations and Functions
'
  '
  '  OFSTRUCT Data Structure for OpenFile API Call
  '
    Type OFSTRUCT
      cBytes As String * 1
      fFixedDisk As String * 1
      nErrCode As Integer
      reserved As String * 4
      szPathName As String * 128
    End Type
  '
  ' API Declarations
  '
    '
    ' Menu API Declarations
    '
      Declare Function GetSystemMenu Lib "User" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
      Declare Function RemoveMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
    '
    ' OpenFile API Call
    '
      Declare Function OpenFile Lib "Kernel" (ByVal lpFileName As String, lpReOpenBuff As OFSTRUCT, ByVal wStyle As Integer) As Integer
  '
  ' API Constants
  '
    '
    ' Menu Constants
    '
      Const MF_BYPOSITION = &H400
    '
    ' OpenFile Constants
    '
      Const OF_EXIST = &H4000
      Const OF_READ = &H0
      Const OF_SHARE_COMPAT = &H0
  '
  ' Global API Related Constants
  '
      '
      ' IsFile() Routine
      '
        Global Const ISFILE_API = 0
        Global Const ISFILE_DIR = 1
  '
  ' Module Level Variables
  '
    Dim r As Variant      ' API Function Throwaway Return Value

Function IsFile (sFileName As String, Method As Integer) As Integer
  '
  ' True  = File Exists
  ' False = File does not exist
  '
  ' method = ISFILE_API = 0 = Use OpenFile API call
  ' method = ISFILE_DIR = 1 = Use DIR$ method
  '
  Dim iResult As Integer
  Dim Response As OFSTRUCT
  Dim sResult As String
  On Error GoTo IsFile_Err
  If Method = 0 Then
    iResult = OpenFile(sFileName, Response, OF_EXIST + OF_READ + OF_SHARE_COMPAT)
    If Response.nErrCode <> 0 Then
      Select Case Response.nErrCode
        Case &H2, &H3
          '
          ' Normal File doesn't exist errors, pass on thru
          '
        Case &H5
          MsgBox "You do not have appropriate rights to " & sFileName & ".", MB_ICONEXCLAMATION
        Case &H20, &H21
          MsgBox sFileName & " is in use by another user or process.  You may need to attempt this process at a later time.", MB_ICONEXCLAMATION
        Case &H35, &H36, &H39, &H3A, &H3B, &H3C, &H40, &H41, &H43, &H45, &H58
          MsgBox "Network Error #" & Hex$(Response.nErrCode) & " occured in OpenFile API function!", MB_ICONEXCLAMATION
        Case Else
          MsgBox "DOS/Windows Error #" & Hex$(Response.nErrCode) & " occured in OpenFile API function!", MB_ICONEXCLAMATION
      End Select
      iResult = False
    End If
  Else
    sResult = Dir$(sFileName, 0)
    If sResult = "" Then
      iResult = False
    Else
      iResult = True
    End If
  End If
  IsFile = iResult
  Exit Function

IsFile_Err:
  sResult = ""
  Resume Next

End Function

Sub SetDialogMenu (frm As Form)
  '
  ' Removes menu items from the System menu of the specified Form
  ' to achieve a standard dialog look.
  '
  Dim hSysMenu As Integer
  '
  ' Obtain the handle to the forms System menu
  '
  hSysMenu = GetSystemMenu(frm.hWnd, 0)
  '
  ' Remove all but the MOVE and CLOSE options.  The menu items
  ' must be removed starting with the last menu item.
  '
  r = RemoveMenu(hSysMenu, 8, MF_BYPOSITION)
  r = RemoveMenu(hSysMenu, 7, MF_BYPOSITION)
  r = RemoveMenu(hSysMenu, 5, MF_BYPOSITION)
End Sub

