VERSION 2.00
Begin Form QueueForm 
   Caption         =   "Queue Services Test"
   Height          =   4365
   Left            =   810
   LinkTopic       =   "Form1"
   ScaleHeight     =   3960
   ScaleWidth      =   6000
   Top             =   1185
   Width           =   6120
   Begin Timer RescanTimer 
      Interval        =   1000
      Left            =   4200
      Top             =   3360
   End
   Begin ListBox JobList 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2370
      Left            =   120
      TabIndex        =   5
      Top             =   360
      Width           =   5775
   End
   Begin ComboBox QueueNameBox 
      Height          =   288
      Left            =   1200
      TabIndex        =   3
      Top             =   3600
      Width           =   2412
   End
   Begin ComboBox ServerNameBox 
      Height          =   288
      Left            =   1200
      Sorted          =   -1  'True
      TabIndex        =   1
      Top             =   3240
      Width           =   2412
   End
   Begin CommandButton CloseButton 
      Caption         =   "&OK"
      Height          =   372
      Left            =   4800
      TabIndex        =   0
      Top             =   3360
      Width           =   972
   End
   Begin Label Label6 
      Caption         =   "Active"
      Height          =   252
      Left            =   840
      TabIndex        =   9
      Top             =   120
      Width           =   612
   End
   Begin Label Label5 
      Caption         =   "Size (bytes)"
      Height          =   252
      Left            =   4800
      TabIndex        =   8
      Top             =   120
      Width           =   1092
   End
   Begin Label Label4 
      Caption         =   "Owner [Station #]"
      Height          =   255
      Left            =   1680
      TabIndex        =   7
      Top             =   120
      Width           =   1695
   End
   Begin Label Label3 
      Caption         =   "Job #"
      Height          =   252
      Left            =   120
      TabIndex        =   6
      Top             =   120
      Width           =   732
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Queue:"
      Height          =   252
      Left            =   0
      TabIndex        =   4
      Top             =   3600
      Width           =   1092
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "File Server:"
      Height          =   252
      Left            =   0
      TabIndex        =   2
      Top             =   3240
      Width           =   1092
   End
End

Sub CheckQueue ()
    Dim queueName As String * 48
    Dim jobInfo As JOB_STRUCT
    Static jobNumbers(250) As Long
    maxJobs& = 250
    
    JobList.Clear
    queueName = String$(48, 0)
    searchName = QueueNameBox.Text
    ccode% = ScanBinderyObject(searchName, OT_PRINT_QUEUE, queueID&, queueName, oType%, oHasProps%, oFlag%, oSec%)

    ccode% = GetQueueJobList(queueID&, jobCount&, jobNumbers(0), maxJobs&)
    If ((ccode% = SUCCESSFUL) And (jobCount& > 0)) Then
        For job& = 0 To (jobCount& - 1)
            ccode% = ReadQueueJobEntry(queueID&, jobNumbers(job&), jobInfo)
            If (ccode% = SUCCESSFUL) Then
                clientName$ = String$(48, 0)
                ccode% = GetBinderyObjectName(jobInfo.clientIDNumber, clientName$, oType%)
                If (ccode% = SUCCESSFUL) Then
                    ccode% = GetQueueJobsFileSize(queueID&, jobNumbers(job&), fileSize&)
                    If (ccode% = SUCCESSFUL) Then
                        out$ = Format$(jobNumbers(job&), "#########   ")
                        If (jobInfo.serverIDNumber = 0) Then
                            out$ = out$ + "N     "
                        Else
                            out$ = out$ + "Y     "
                        End If
                        clientName$ = Left$(clientName$, InStr(clientName$, Chr$(0)) - 1)
                        out$ = out$ + Left$(clientName$, 20)
                        out$ = out$ + "[" + Format$(jobInfo.clientStation) + "]"
                        out$ = out$ + Space$(39 - Len(out$))
                        out$ = out$ + Format(fileSize&, "############")
                        JobList.AddItem out$
                    End If
                End If
            End If
        Next job&
    End If
End Sub

Sub CloseButton_Click ()
    Unload QueueForm
End Sub

Sub Form_Load ()
    For connID% = 1 To 8
        'for each connection in workstation's file server name table
        'get the table entry, then see if it's null
        
        fileServerName$ = String$(48, 0)
        If (IsConnectionIDInUse(connID%) = 1) Then
            GetFileServerName connID%, fileServerName$
            ServerNameBox.AddItem fileServerName$
        End If
    Next connID%

    'get name of default file server for combo box
    fileServerName$ = GetDefaultFileServerName()
    ServerNameBox.Text = fileServerName$
End Sub

Sub Form_Unload (Cancel As Integer)
    SetPreferredConnectionID (originalPrefConnID%)
End Sub

Sub QueueNameBox_Change ()
    CheckQueue
End Sub

Sub QueueNameBox_Click ()
    QueueNameBox_Change
End Sub

Sub RescanTimer_Timer ()
    CheckQueue
End Sub

Sub ScanQueues ()
    QueueNameBox.Clear
    oID& = -1
    Do
        queueName$ = String$(48, 0)
        ccode% = ScanBinderyObject("*", OT_PRINT_QUEUE, oID&, queueName$, oType%, oHasProps%, oFlag%, oSec%)
        If (ccode% = SUCCESSFUL) Then
            queueName$ = Left$(queueName$, InStr(queueName$, Chr$(0)) - 1)
            QueueNameBox.AddItem queueName$
        End If
    Loop While (ccode% = SUCCESSFUL)

    If (QueueNameBox.ListCount > 0) Then QueueNameBox.Text = QueueNameBox.List(0)
End Sub

Sub ServerNameBox_Change ()
    ServerNameBox_Click
End Sub

Sub ServerNameBox_Click ()
    prefServer$ = ServerNameBox.Text
    
    ccode% = GetConnectionID(prefServer$, connID%)
    If (ccode% = SUCCESSFUL) Then
        SetPreferredConnectionID (connID%)  'tell which file server to send
                                            'requests to
        Screen.MousePointer = 11
        ScanQueues                          'then go scan its bindery for queue objects
        Screen.MousePointer = 0
    Else
        MsgBox "Unable to get connection ID of server " + prefServer$, MB_OK, "Error"
    End If
End Sub

