VERSION 2.00
Begin Form FileInfoForm 
   Caption         =   "File Services Test"
   Height          =   4515
   Left            =   1020
   LinkTopic       =   "Form2"
   ScaleHeight     =   4110
   ScaleWidth      =   6930
   Top             =   1335
   Width           =   7050
   Begin Frame Frame2 
      Caption         =   "Extended File Attributes"
      Height          =   1455
      Left            =   3720
      TabIndex        =   4
      Top             =   1920
      Width           =   2415
      Begin CheckBox WABox 
         Caption         =   "Write audit"
         Height          =   255
         Left            =   480
         TabIndex        =   15
         Top             =   1080
         Width           =   1575
      End
      Begin CheckBox RABox 
         Caption         =   "Read audit"
         Height          =   255
         Left            =   480
         TabIndex        =   14
         Top             =   840
         Width           =   1575
      End
      Begin CheckBox IBox 
         Caption         =   "Indexed"
         Height          =   255
         Left            =   480
         TabIndex        =   13
         Top             =   600
         Width           =   1575
      End
      Begin CheckBox TBox 
         Caption         =   "Transactional"
         Height          =   255
         Left            =   480
         TabIndex        =   12
         Top             =   360
         Width           =   1575
      End
   End
   Begin Frame Frame1 
      Caption         =   "File Attributes"
      Height          =   2175
      Left            =   360
      TabIndex        =   3
      Top             =   1320
      Width           =   1695
      Begin CheckBox ShBox 
         Caption         =   "Sharable"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   1800
         Width           =   1455
      End
      Begin CheckBox ABox 
         Caption         =   "Archive"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   1560
         Width           =   1455
      End
      Begin CheckBox SubBox 
         Caption         =   "Subdirectory"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   1320
         Width           =   1455
      End
      Begin CheckBox XBox 
         Caption         =   "Execute only"
         Height          =   255
         Left            =   120
         TabIndex        =   8
         Top             =   1080
         Width           =   1455
      End
      Begin CheckBox SBox 
         Caption         =   "System"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   840
         Width           =   1455
      End
      Begin CheckBox HBox 
         Caption         =   "Hidden"
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   600
         Width           =   1455
      End
      Begin CheckBox ROBox 
         Caption         =   "Read-only"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   360
         Width           =   1455
      End
   End
   Begin CommandButton OKButton 
      Caption         =   "&OK"
      Height          =   375
      Left            =   2880
      TabIndex        =   0
      Top             =   3600
      Width           =   855
   End
   Begin Label OwnerLabel 
      Height          =   255
      Left            =   960
      TabIndex        =   27
      Top             =   840
      Width           =   2055
   End
   Begin Label Label7 
      Alignment       =   1  'Right Justify
      Caption         =   "Owner:"
      Height          =   255
      Left            =   120
      TabIndex        =   26
      Top             =   840
      Width           =   735
   End
   Begin Label LastArchivedLabel 
      Height          =   255
      Left            =   4680
      TabIndex        =   25
      Top             =   1560
      Width           =   2055
   End
   Begin Label Label6 
      Alignment       =   1  'Right Justify
      Caption         =   "Last archived:"
      Height          =   255
      Left            =   3240
      TabIndex        =   24
      Top             =   1560
      Width           =   1335
   End
   Begin Label LastUpdateLabel 
      Height          =   255
      Left            =   4680
      TabIndex        =   23
      Top             =   1320
      Width           =   2055
   End
   Begin Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Last updated:"
      Height          =   255
      Left            =   3240
      TabIndex        =   22
      Top             =   1320
      Width           =   1335
   End
   Begin Label LastAccessLabel 
      Height          =   255
      Left            =   4680
      TabIndex        =   21
      Top             =   1080
      Width           =   2055
   End
   Begin Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Last accessed:"
      Height          =   255
      Left            =   3240
      TabIndex        =   20
      Top             =   1080
      Width           =   1335
   End
   Begin Label CreatedLabel 
      Height          =   255
      Left            =   4680
      TabIndex        =   19
      Top             =   840
      Width           =   2055
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Created:"
      Height          =   255
      Left            =   3720
      TabIndex        =   18
      Top             =   840
      Width           =   855
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Size:"
      Height          =   255
      Left            =   240
      TabIndex        =   17
      Top             =   1080
      Width           =   615
   End
   Begin Label Label1 
      Caption         =   "Information for file:"
      Height          =   255
      Left            =   120
      TabIndex        =   16
      Top             =   120
      Width           =   2655
   End
   Begin Label FileSizeLabel 
      Height          =   255
      Left            =   960
      TabIndex        =   2
      Top             =   1080
      Width           =   1575
   End
   Begin Label FilePathLabel 
      Height          =   255
      Left            =   360
      TabIndex        =   1
      Top             =   360
      Width           =   6375
   End
End
Dim locked%

Sub ABox_Click ()
    If locked% Then
        locked% = False
        If (Abox.Value = 0) Then
            Abox.Value = 1
        Else
            Abox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub Form_Load ()
    locked% = False

    server$ = String$(48, 0)
    volume$ = String$(16, 0)
    dirs$ = String$(255, 0)

    dirPath$ = SelectFileForm.CurrDirLabel.Caption + "\" + SelectFileForm.FileNameBox.Text

    cCode% = ParsePath(dirPath$, server$, volume$, dirs$)
    
    volume$ = Left$(volume$, InStr(volume$, Chr$(0)) - 1)
    dirs$ = Left$(dirs$, InStr(dirs$, Chr$(0)) - 1)
    filePath$ = volume$ + ":/" + dirs$
    
    fileName$ = String$(15, 0)
    handle% = 0
    sequence% = -1
    cCode% = ScanFileInformation(handle%, filePath$, FA_NORMAL And FA_HIDDEN And FA_SYSTEM, sequence%, fileName$, attrib%, extAttrib%, size&, cDate%, lastAcc%, lastUpd&, lastArch&, ownerID&)
    If (cCode% <> SUCCESSFUL) Then
        MsgBox "Unable to get file information", MB_OK, "Error"
    Else
        'file path
        FilePathLabel.Caption = filePath$

        'attributes
        If (attrib% And FA_READ_ONLY) Then ROBox.Value = 1
        If (attrib% And FA_HIDDEN) Then HBox.Value = 1
        If (attrib% And FA_SYSTEM) Then SBox.Value = 1
        If (attrib% And FA_EXECUTE_ONLY) Then XBox.Value = 1
        If (attrib% And FA_DIRECTORY) Then SubBox.Value = 1
        If (attrib% And FA_ARCHIVE) Then Abox.Value = 1
        If (attrib% And FA_SHARABLE) Then ShBox.Value = 1

        'extended attributes
        If (extAttrib% And FA_TRANSACTIONAL) Then TBox.Value = 1
        If (extAttrib% And FA_INDEXED) Then IBox.Value = 1
        If (extAttrib% And FA_READ_AUDIT) Then RABox.Value = 1
        If (extAttrib% And FA_WRITE_AUDIT) Then WABox.Value = 1

        'Ignore the Purge, Copy Inhibit, Delete Inhibit, and Rename Inhibit bits for now

        'file size
        FileSizeLabel.Caption = Str$(size&)

        'creation date
        CreatedLabel.Caption = GetDate$(cDate%, 0)

        'last accessed date
        LastAccessLabel.Caption = GetDate$(lastAcc%, 0)

        'last update date and time
        theTime% = (lastUpd& And &HFFFF0000) / &H10000
        theDate% = lastUpd& - (lastUpd& And &HFFFF0000)
        LastUpdateLabel.Caption = GetDate$(theDate%, theTime%)

        'last archive date and time
        theTime% = (lastArch& And &HFFFF0000) / &H10000
        theDate% = lastArch& - (lastArch& And &HFFFF0000)
        LastArchivedLabel.Caption = GetDate$(theDate%, theTime%)

        'owner
        ownerName$ = String$(48, 0)
        cCode% = GetBinderyObjectName(ownerID&, ownerName$, OT_USER)
        If (cCode% <> SUCCESSFUL) Then ownerName$ = "Unknown user"
        OwnerLabel.Caption = ownerName$

    End If
    locked% = True
End Sub

Sub HBox_Click ()
    If locked% Then
        locked% = False
        If (HBox.Value = 0) Then
            HBox.Value = 1
        Else
            HBox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub IBox_Click ()
    If locked% Then
        locked% = False
        If (IBox.Value = 0) Then
            IBox.Value = 1
        Else
            IBox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub OKButton_Click ()
    Unload SelectFileForm
    Unload FileInfoForm
End Sub

Sub RABox_Click ()
    If locked% Then
        locked% = False
        If (RABox.Value = 0) Then
            RABox.Value = 1
        Else
            RABox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub ROBox_Click ()
    If locked% Then
        locked% = False
        If (ROBox.Value = 0) Then
            ROBox.Value = 1
        Else
            ROBox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub SBox_Click ()
    If locked% Then
        locked% = False
        If (SBox.Value = 0) Then
            SBox.Value = 1
        Else
            SBox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub ShBox_Click ()
    If locked% Then
        locked% = False
        If (ShBox.Value = 0) Then
            ShBox.Value = 1
        Else
            ShBox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub SubBox_Click ()
    If locked% Then
        locked% = False
        If (SubBox.Value = 0) Then
            SubBox.Value = 1
        Else
            SubBox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub TBox_Click ()
    If locked% Then
        locked% = False
        If (TBox.Value = 0) Then
            TBox.Value = 1
        Else
            TBox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub WABox_Click ()
    If locked% Then
        locked% = False
        If (WABox.Value = 0) Then
            WABox.Value = 1
        Else
            WABox.Value = 0
        End If
        locked% = True
    End If
End Sub

Sub XBox_Click ()
    If locked% Then
        locked% = False
        If (XBox.Value = 0) Then
            XBox.Value = 1
        Else
            XBox.Value = 0
        End If
        locked% = True
    End If
End Sub

