VERSION 2.00
Begin Form DirVolForm 
   Caption         =   "Directory Services Test (Volume APIs)"
   Height          =   4830
   Left            =   450
   LinkTopic       =   "Form1"
   ScaleHeight     =   4425
   ScaleWidth      =   8295
   Top             =   1110
   Width           =   8415
   Begin Frame Frame1 
      Caption         =   "Volume Information"
      Height          =   4215
      Left            =   3840
      TabIndex        =   5
      Top             =   120
      Width           =   4335
      Begin Label InUseLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   31
         Top             =   3735
         Width           =   1335
      End
      Begin Label VolRestrictLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   30
         Top             =   3420
         Width           =   1335
      End
      Begin Label Label15 
         Alignment       =   1  'Right Justify
         Caption         =   "Your volume usage (blocks):"
         Height          =   255
         Left            =   120
         TabIndex        =   29
         Top             =   3720
         Width           =   2535
      End
      Begin Label Label14 
         Alignment       =   1  'Right Justify
         Caption         =   "Your volume usage restrictions (blocks):"
         Height          =   375
         Left            =   360
         TabIndex        =   28
         Top             =   3240
         Width           =   2295
      End
      Begin Label VolumeNameLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   27
         Top             =   360
         Width           =   1335
      End
      Begin Label Label13 
         Alignment       =   1  'Right Justify
         Caption         =   "Name:"
         Height          =   255
         Left            =   1800
         TabIndex        =   26
         Top             =   360
         Width           =   855
      End
      Begin Label RemovableLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   25
         Top             =   3000
         Width           =   1335
      End
      Begin Label HashingLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   24
         Top             =   2760
         Width           =   1335
      End
      Begin Label BlockSizeLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   23
         Top             =   2520
         Width           =   1335
      End
      Begin Label MaxDirEntriesLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   22
         Top             =   2280
         Width           =   1335
      End
      Begin Label AvailDirEntriesLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   21
         Top             =   2040
         Width           =   1335
      End
      Begin Label TotalDirEntriesLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   20
         Top             =   1800
         Width           =   1335
      End
      Begin Label DeletedBlocksLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   19
         Top             =   1515
         Width           =   1335
      End
      Begin Label PurgableBlocksLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   18
         Top             =   1080
         Width           =   1335
      End
      Begin Label FreeBlocksLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   17
         Top             =   840
         Width           =   1335
      End
      Begin Label TotalBlocksLabel 
         Height          =   255
         Left            =   2760
         TabIndex        =   16
         Top             =   600
         Width           =   1335
      End
      Begin Label Label12 
         Alignment       =   1  'Right Justify
         Caption         =   "Removable media:"
         Height          =   255
         Left            =   840
         TabIndex        =   15
         Top             =   3000
         Width           =   1815
      End
      Begin Label Label11 
         Alignment       =   1  'Right Justify
         Caption         =   "Hashing enabled:"
         Height          =   255
         Left            =   840
         TabIndex        =   14
         Top             =   2760
         Width           =   1815
      End
      Begin Label Label10 
         Alignment       =   1  'Right Justify
         Caption         =   "Block size (bytes):"
         Height          =   255
         Left            =   600
         TabIndex        =   13
         Top             =   2520
         Width           =   2055
      End
      Begin Label Label9 
         Alignment       =   1  'Right Justify
         Caption         =   "Max directory entries used:"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   2280
         Width           =   2535
      End
      Begin Label Label8 
         Alignment       =   1  'Right Justify
         Caption         =   "Available directory entries:"
         Height          =   255
         Left            =   360
         TabIndex        =   11
         Top             =   2040
         Width           =   2295
      End
      Begin Label Label7 
         Alignment       =   1  'Right Justify
         Caption         =   "Total directory entries:"
         Height          =   255
         Left            =   600
         TabIndex        =   10
         Top             =   1800
         Width           =   2055
      End
      Begin Label Label6 
         Alignment       =   1  'Right Justify
         Caption         =   "Deleted, but not yet purgable blocks:"
         Height          =   375
         Left            =   840
         TabIndex        =   9
         Top             =   1320
         Width           =   1815
      End
      Begin Label Label5 
         Alignment       =   1  'Right Justify
         Caption         =   "Purgable blocks:"
         Height          =   255
         Left            =   1200
         TabIndex        =   8
         Top             =   1080
         Width           =   1455
      End
      Begin Label Label4 
         Alignment       =   1  'Right Justify
         Caption         =   "Free blocks:"
         Height          =   255
         Left            =   1440
         TabIndex        =   7
         Top             =   840
         Width           =   1215
      End
      Begin Label Label3 
         Alignment       =   1  'Right Justify
         Caption         =   "Total blocks:"
         Height          =   255
         Left            =   1320
         TabIndex        =   6
         Top             =   600
         Width           =   1335
      End
   End
   Begin ListBox VolumeList 
      Height          =   1005
      Left            =   1200
      TabIndex        =   3
      Top             =   960
      Width           =   2415
   End
   Begin CommandButton OKButton 
      Caption         =   "&OK"
      Height          =   375
      Left            =   1440
      TabIndex        =   2
      Top             =   3840
      Width           =   855
   End
   Begin ComboBox ServerNameBox 
      Height          =   300
      Left            =   1200
      Sorted          =   -1  'True
      TabIndex        =   0
      Text            =   "ServerNameBox"
      Top             =   360
      Width           =   2415
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Volumes:"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   960
      Width           =   975
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "File Server:"
      Height          =   255
      Left            =   0
      TabIndex        =   1
      Top             =   360
      Width           =   1095
   End
End

Sub Form_Load ()
    For connID% = 1 To 8
        fileServerName$ = String$(48, 0)
        If (IsConnectionIDInUse(connID%) = 1) Then
            GetFileServerName connID%, fileServerName$
            ServerNameBox.AddItem fileServerName$
        End If
    Next connID%

    'get name of default file server for combo box
    fileServerName$ = GetDefaultFileServerName()
    ServerNameBox.Text = fileServerName$
    ServerNameBox_Click
End Sub

Sub Form_Unload (Cancel As Integer)
    SetPreferredConnectionID (originalPrefConnID%)
End Sub

Sub OKButton_Click ()
    Unload DirVolForm
End Sub

Sub ServerNameBox_Click ()
    VolumeList.Clear
    prefServer$ = ServerNameBox.Text
    
    ccode% = GetConnectionID(prefServer$, connID%)
    If (ccode% = SUCCESSFUL) Then
        SetPreferredConnectionID (connID%)  'tell which file server to send
                                            'requests to
        For volume% = 0 To 31
            volumeName$ = String$(16, 0)
            ccode% = GetVolumeName(volume%, volumeName$)
            If ((ccode% = SUCCESSFUL) And (Asc(volumeName$) <> 0)) Then
                VolumeList.AddItem Str$(volume%) + "   " + volumeName$
            End If
        Next volume%

        UpdateVolumeStats
    Else
        MsgBox "Unable to get connection ID of server " + prefServer$, MB_OK, "Error"
    End If

End Sub

Sub ServerNameBox_KeyPress (KeyAscii As Integer)
    If (KeyAscii = 13) Then
        ServerNameBox_Click
    End If
End Sub

Sub UpdateVolumeStats ()
    Dim volumeUsage As NWVOL_USAGE
    Dim loginTime As DATE_AND_TIME

    If (VolumeList.ListIndex = -1) Then
        volume% = 0
    Else
        volume% = Val(VolumeList.ListIndex)
    End If

    connID% = GetDefaultConnectionID()
    ccode% = GetVolUsage(connID%, volume%, volumeUsage)

    TotalBlocksLabel.Caption = Str$(volumeUsage.totalBlocks)
    FreeBlocksLabel.Caption = Str$(volumeUsage.freeBlocks)
    PurgableBlocksLabel.Caption = Str$(volumeUsage.purgableBlocks)
    DeletedBlocksLabel.Caption = Str$(volumeUsage.notYetPurgableBlocks)
    TotalDirEntriesLabel.Caption = Str$(volumeUsage.totalDirEntries)
    AvailDirEntriesLabel.Caption = Str$(volumeUsage.availDirEntries)
    MaxDirEntriesLabel.Caption = Str$(volumeUsage.maxDirEntriesUsed)
    BlockSizeLabel.Caption = Str$(volumeUsage.blockSize)
    If (volumeUsage.isHashing <> Chr$(0)) Then
        HashingLabel.Caption = "Yes"
    Else
        HashingLabel.Caption = "No"
    End If
    If (volumeUsage.isRemovable <> Chr$(0)) Then
        RemovableLabel.Caption = "Yes"
    Else
        RemovableLabel.Caption = "No"
    End If
    VolumeNameLabel.Caption = volumeUsage.volName

    'Get user's volume disk space restrictions
    connNum& = GetConnectionNumber()
    myName$ = String$(48, 0)
    ccode% = GetConnectionInformation(connNum&, myName$, myType%, objID&, loginTime)
    ccode% = GetObjectDiskRestrictions(connID%, volume%, objID&, volRestrict&, inUse&)
    If (volRestrict& = &H40000000) Then
        VolRestrictLabel.Caption = "None"
    Else
        VolRestrictLabel.Caption = Str$(volRestrict&)
    End If
    InUseLabel.Caption = Str$(inUse&)
End Sub

Sub VolumeList_Click ()
    UpdateVolumeStats
End Sub

