VERSION 2.00
Begin Form AFPInfoForm 
   Caption         =   "AFP File Information"
   Height          =   5325
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   4920
   ScaleWidth      =   6855
   Top             =   1140
   Width           =   6975
   Begin Frame Frame3 
      Caption         =   "File Size"
      Height          =   735
      Left            =   120
      TabIndex        =   10
      Top             =   1440
      Width           =   6615
      Begin Label ResourceForkLengthLabel 
         Height          =   255
         Left            =   5160
         TabIndex        =   15
         Top             =   360
         Width           =   975
      End
      Begin Label DataForkLengthLabel 
         Height          =   255
         Left            =   1560
         TabIndex        =   14
         Top             =   360
         Width           =   975
      End
      Begin Label Label6 
         Alignment       =   1  'Right Justify
         Caption         =   "Resource Fork:"
         Height          =   255
         Left            =   3600
         TabIndex        =   12
         Top             =   360
         Width           =   1455
      End
      Begin Label Label5 
         Alignment       =   1  'Right Justify
         Caption         =   "Data Fork:"
         Height          =   255
         Left            =   360
         TabIndex        =   11
         Top             =   360
         Width           =   1095
      End
   End
   Begin Frame Frame1 
      Caption         =   "File Attributes"
      Height          =   1935
      Left            =   120
      TabIndex        =   8
      Top             =   2280
      Width           =   6615
      Begin Label IndexLabel 
         Height          =   255
         Left            =   4320
         TabIndex        =   34
         Top             =   1440
         Width           =   975
      End
      Begin Label TransLabel 
         Height          =   255
         Left            =   4320
         TabIndex        =   33
         Top             =   1200
         Width           =   975
      End
      Begin Label SearchLabel 
         Height          =   375
         Left            =   4320
         TabIndex        =   32
         Top             =   600
         Width           =   2175
      End
      Begin Label ArchiveLabel 
         Height          =   255
         Left            =   1800
         TabIndex        =   31
         Top             =   1560
         Width           =   975
      End
      Begin Label SharableLabel 
         Height          =   255
         Left            =   4320
         TabIndex        =   30
         Top             =   360
         Width           =   975
      End
      Begin Label SubdirLabel 
         Height          =   255
         Left            =   1800
         TabIndex        =   29
         Top             =   1320
         Width           =   975
      End
      Begin Label ExecuteLabel 
         Height          =   255
         Left            =   1800
         TabIndex        =   28
         Top             =   1080
         Width           =   975
      End
      Begin Label SysLabel 
         Height          =   255
         Left            =   1800
         TabIndex        =   27
         Top             =   840
         Width           =   975
      End
      Begin Label ROLabel 
         Height          =   255
         Left            =   1800
         TabIndex        =   26
         Top             =   360
         Width           =   975
      End
      Begin Label Label20 
         Alignment       =   1  'Right Justify
         Caption         =   "Index:"
         Height          =   255
         Left            =   3360
         TabIndex        =   25
         Top             =   1440
         Width           =   735
      End
      Begin Label Label19 
         Alignment       =   1  'Right Justify
         Caption         =   "Transactional:"
         Height          =   255
         Left            =   2760
         TabIndex        =   24
         Top             =   1200
         Width           =   1335
      End
      Begin Label Label18 
         Alignment       =   1  'Right Justify
         Caption         =   "Search mode:"
         Height          =   255
         Left            =   2880
         TabIndex        =   23
         Top             =   600
         Width           =   1215
      End
      Begin Label Label17 
         Alignment       =   1  'Right Justify
         Caption         =   "Sharable:"
         Height          =   255
         Left            =   3000
         TabIndex        =   22
         Top             =   360
         Width           =   1095
      End
      Begin Label Label16 
         Alignment       =   1  'Right Justify
         Caption         =   "Archive:"
         Height          =   255
         Left            =   720
         TabIndex        =   21
         Top             =   1560
         Width           =   855
      End
      Begin Label Label15 
         Alignment       =   1  'Right Justify
         Caption         =   "Subdirectory:"
         Height          =   255
         Left            =   360
         TabIndex        =   20
         Top             =   1320
         Width           =   1215
      End
      Begin Label Label14 
         Alignment       =   1  'Right Justify
         Caption         =   "Execute-only:"
         Height          =   255
         Left            =   240
         TabIndex        =   19
         Top             =   1080
         Width           =   1335
      End
      Begin Label Label13 
         Alignment       =   1  'Right Justify
         Caption         =   "System:"
         Height          =   255
         Left            =   720
         TabIndex        =   18
         Top             =   840
         Width           =   855
      End
      Begin Label Label12 
         Alignment       =   1  'Right Justify
         Caption         =   "Hidden:"
         Height          =   255
         Left            =   600
         TabIndex        =   17
         Top             =   600
         Width           =   975
      End
      Begin Label HiddenLabel 
         Height          =   255
         Left            =   1800
         TabIndex        =   16
         Top             =   600
         Width           =   975
      End
      Begin Label Label11 
         Alignment       =   1  'Right Justify
         Caption         =   "Read-only:"
         Height          =   255
         Left            =   360
         TabIndex        =   9
         Top             =   360
         Width           =   1215
      End
   End
   Begin CommandButton OKButton 
      Caption         =   "&OK"
      Height          =   495
      Left            =   2880
      TabIndex        =   1
      Top             =   4320
      Width           =   1095
   End
   Begin Label OwnerLabel 
      Height          =   255
      Left            =   2160
      TabIndex        =   13
      Top             =   1080
      Width           =   3735
   End
   Begin Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "File Owner:"
      Height          =   255
      Left            =   840
      TabIndex        =   7
      Top             =   1080
      Width           =   1215
   End
   Begin Label LongNameLabel 
      Height          =   255
      Left            =   2160
      TabIndex        =   6
      Top             =   840
      Width           =   4575
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Long Name:"
      Height          =   255
      Left            =   720
      TabIndex        =   5
      Top             =   840
      Width           =   1335
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Directory:"
      Height          =   255
      Left            =   1080
      TabIndex        =   4
      Top             =   480
      Width           =   975
   End
   Begin Label DirPathLabel 
      Height          =   255
      Left            =   2160
      TabIndex        =   3
      Top             =   480
      Width           =   4575
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "DOS file name:"
      Height          =   255
      Left            =   720
      TabIndex        =   2
      Top             =   240
      Width           =   1335
   End
   Begin Label FileNameLabel 
      Height          =   255
      Left            =   2160
      TabIndex        =   0
      Top             =   240
      Width           =   1815
   End
End

Sub Command1_Click ()
    
End Sub

Sub Form_Load ()
    Dim fileInfo As AFP_FILE_INFO

    server$ = String$(48, 0)
    volume$ = String$(16, 0)
    dirs$ = String$(255, 0)
    afpPath$ = String$(255, 0)

    FileNameLabel.Caption = UCase$(SelectFileForm.FileNameBox.Text)
    DirPathLabel.Caption = UCase$(SelectFileForm.DirBox.Path)

    dirPath$ = DirPathLabel.Caption + "\" + FileNameLabel.Caption

    ccode% = ParsePath(dirPath$, server$, volume$, dirs$)
    
    server$ = Left$(server$, InStr(server$, Chr$(0)) - 1)
    volume$ = Left$(volume$, InStr(volume$, Chr$(0)) - 1)
    dirs$ = Left$(dirs$, InStr(dirs$, Chr$(0)) - 1)
    dirPath$ = server$ + "/" + volume$ + ":\" + dirs$
    
    connID% = GetPreferredConnectionID()

    ccode% = AFPDirectoryEntry(connID%, 0, dirPath$)
    If (ccode% = 1) Then
        ccode% = GetVolumeNumber(volume$, volumeNum%)
        ccode% = AFPGetEntryIDFromPathName(connID%, 0, dirPath$, entryID&)

        afpPath$ = Chr$(0)
        ccode% = AFPGetFileInformation(connID%, volumeNum%, entryID&, &HFFFF, afpPath$, Len(fileInfo), fileInfo)
        If (ccode% <> SUCCESSFUL) Then
            MsgBox "Unable to get AFP information on selected file.", MB_OK, "Error"
        Else
            LongNameLabel.Caption = fileInfo.longName
            ownerName$ = String$(48, 0)
            ccode% = GetBinderyObjectName(fileInfo.ownerID, ownerName$, ownerType%)
            If (ccode% = SUCCESSFUL) Then
                OwnerLabel.Caption = ownerName$
            Else
                OwnerLabel.Caption = "Unknown User"
            End If
            DataForkLengthLabel.Caption = fileInfo.dataForkLength
            ResourceForkLengthLabel.Caption = fileInfo.resourceForkLength
            If (fileInfo.attributes And &H100) Then
                ROLabel.Caption = "Yes"
            Else
                ROLabel.Caption = "No"
            End If
            If (fileInfo.attributes And &H200) Then
                HiddenLabel.Caption = "Yes"
            Else
                HiddenLabel.Caption = "No"
            End If
            If (fileInfo.attributes And &H400) Then
                SysLabel.Caption = "Yes"
            Else
                SysLabel.Caption = "No"
            End If
            If (fileInfo.attributes And &H800) Then
                ExecuteLabel.Caption = "Yes"
            Else
                ExecuteLabel.Caption = "No"
            End If
            If (fileInfo.attributes And &H1000) Then
                SubdirLabel.Caption = "Yes"
            Else
                SubdirLabel.Caption = "No"
            End If
            If (fileInfo.attributes And &H2000) Then
                ArchiveLabel.Caption = "Yes"
            Else
                ArchiveLabel.Caption = "No"
            End If
            If (fileInfo.attributes And &H8000) Then
                SharableLabel.Caption = "Yes"
            Else
                SharableLabel.Caption = "No"
            End If
            If (fileInfo.attributes And &H10) Then
                TransLabel.Caption = "Yes"
            Else
                TransLabel.Caption = "No"
            End If
            If (fileInfo.attributes And &H20) Then
                IndexLabel.Caption = "Yes"
            Else
                IndexLabel.Caption = "No"
            End If
            If (fileInfo.attributes And 7) = 0 Then
                SearchLabel.Caption = "No mode"
            ElseIf (fileInfo.attributes And 7) = 1 Then
                SearchLabel.Caption = "Search on all opens with no path"
            ElseIf (fileInfo.attributes And 7) = 2 Then
                SearchLabel.Caption = "Do not search"
            ElseIf (fileInfo.attributes And 7) = 3 Then
                SearchLabel.Caption = "Search on RO opens with no path"
            ElseIf (fileInfo.attributes And 7) = 5 Then
                SearchLabel.Caption = "Search on all opens"
            ElseIf (fileInfo.attributes And 7) = 7 Then
                SearchLabel.Caption = "Search on all RO opens"
            Else
                SearchLabel.Caption = "Unknown"
            End If
        End If
    Else
        LongNameLabel.Caption = "No AFP information (not a Macintosh file)"
    End If
End Sub

Sub OKButton_Click ()
    Unload SelectFileForm
    Unload AFPInfoForm
End Sub

