VERSION 2.00
Begin Form DirDirForm 
   Caption         =   "Directory Services Test (Directory APIs)"
   Height          =   3855
   Left            =   1305
   LinkTopic       =   "Form1"
   ScaleHeight     =   3450
   ScaleWidth      =   4905
   Top             =   1320
   Width           =   5025
   Begin ListBox TrusteeList 
      Height          =   1005
      Left            =   240
      TabIndex        =   7
      Top             =   1920
      Width           =   4575
   End
   Begin CommandButton OKButton 
      Caption         =   "&OK"
      Height          =   375
      Left            =   2040
      TabIndex        =   0
      Top             =   3000
      Width           =   975
   End
   Begin Label EffectiveRightsLabel 
      Height          =   255
      Left            =   1680
      TabIndex        =   10
      Top             =   1440
      Width           =   2655
   End
   Begin Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Your effective rights:"
      Height          =   495
      Left            =   120
      TabIndex        =   9
      Top             =   1200
      Width           =   1455
   End
   Begin Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Trustees:"
      Height          =   255
      Left            =   240
      TabIndex        =   8
      Top             =   1680
      Width           =   855
   End
   Begin Label CreatedLabel 
      Height          =   255
      Left            =   1680
      TabIndex        =   6
      Top             =   960
      Width           =   1695
   End
   Begin Label OwnerLabel 
      Height          =   255
      Left            =   1680
      TabIndex        =   5
      Top             =   720
      Width           =   2655
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Created:"
      Height          =   255
      Left            =   720
      TabIndex        =   4
      Top             =   960
      Width           =   855
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Owner:"
      Height          =   255
      Left            =   960
      TabIndex        =   3
      Top             =   720
      Width           =   615
   End
   Begin Label DirPathLabel 
      Height          =   255
      Left            =   720
      TabIndex        =   2
      Top             =   360
      Width           =   5055
   End
   Begin Label Label1 
      Caption         =   "Information for directory:"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   120
      Width           =   2175
   End
End

Sub Form_Load ()
    Dim dirEntry As NWDIR_ENTRY
    Dim trustees3x As TRUSTEE_BUFFER_3X
    Dim trustees2x As TRUSTEE_BUFFER_2X

    server$ = String$(48, 0)
    volume$ = String$(16, 0)
    dirs$ = String$(255, 0)

    ccode% = ParsePath(dirPath$, server$, volume$, dirs$)
    
    volume$ = Left$(volume$, InStr(volume$, Chr$(0)) - 1)
    dirs$ = Left$(dirs$, InStr(dirs$, Chr$(0)) - 1)
    dirPath$ = volume$ + ":/" + dirs$
    
    connID% = GetDefaultConnectionID()

    ccode% = AllocTemporaryDirectoryHandle(0, dirPath$, Asc("["), handle%, mask%)

    If (ccode% <> SUCCESSFUL) Then
        MsgBox "Unable to allocate directory handle", MB_OK, "Error"
    Else
        ccode% = GetDirEntry(connID%, handle%, dirEntry)
        If (ccode% <> SUCCESSFUL) Then
            MsgBox "Unable to get directory information", MB_OK, "Error"
        Else
            oName$ = String$(48, 0)

            ccode% = GetBinderyObjectname(dirEntry.ownerID, oName$, ownerType%)
            If (ccode% = SUCCESSFUL) Then
                OwnerLabel.Caption = oName$
            Else
                OwnerLabel.Caption = "Unknown User"
            End If

            DirPathLabel = dirPath$
            CreatedLabel.Caption = GetDate$(dirEntry.creationDate, dirEntry.creationTime)

            sequence% = 0
            dirName$ = String$(16, 0)
            tRights$ = String$(5, 0)
            
            'Would get the rights mask from the trustee buffer,
            '   but there is a bug in the v1.30 NWNETAPI.DLL, and
            '   ScanEntryForTrustees doesn't copy the rights mask
            '   to the buffer correctly
            Do
                ver3x% = IsV3Supported(connID%)
                If (ver3x% = 1) Then
                    ccode% = ScanEntryForTrustees(connID%, 0, dirPath$, trustees3x, sequence%, numTrusteeEntries)
                    If (ccode% = SUCCESSFUL) Then
                        sequence% = sequence% + 1
                        For i = 0 To (Asc(trustees3x.numEntriesReturned) - 1)
                            gotName% = GetBinderyObjectname(trustees3x.oID(i), oName$, oType%)
                            If (gotName% <> 0) Then oName$ = "Unknown User"
                            TrusteeList.AddItem oName$
                        Next i
                    End If
                Else
                    ccode% = ScanEntryForTrustees(connID%, 0, dirPath$, trustees2x, sequence%, numTrusteeEntries)
                    If (ccode% = SUCCESSFUL) Then
                        sequence% = sequence% + 1
                        For i = 0 To 4
                            If (trustees2x.oID(i) = 0) Then Exit For
                            gotName% = GetBinderyObjectname(trustees2x.oID(i), oName$, oType%)
                            If (gotName% <> 0) Then oName$ = "Unknown User"
                            TrusteeList.AddItem oName$
                        Next i
                    End If
                End If
            Loop Until (ccode% <> SUCCESSFUL)
        End If
        
        ccode% = GetEffectiveRights(connID%, 0, dirPath$, rights%)
        If (ccode% = SUCCESSFUL) Then
            EffectiveRightsLabel.Caption = GetRights(rights%)
        Else
            EffectiveRightsLabel.Caption = "Unable to obtain"
        End If

        ccode% = DeallocateDirectoryHandle(handle%)
        If (ccode% <> SUCCESSFUL) Then
            MsgBox "Unable to deallocate directory handle", MB_OK, "Error"
        End If
    End If
End Sub

Function GetRights (rightsMask%)
    If (rightsMask% And TR_SUPERVISOR) Then
        rights$ = "S"
    Else
        rights$ = " "
    End If

    If (rightsMask% And TR_MODIFY) Then
        rights$ = rights$ + "M"
    Else
        rights$ = rights$ + " "
    End If

    If (rightsMask% And TR_FILE) Then
        If (IsV3Supported(connID%) = 1) Then
            rights$ = rights$ + "F"
        Else
            rights$ = rights$ + "S"
        End If
    Else
        rights$ = rights$ + " "
    End If

    If (rightsMask% And TR_ACCESS) Then
        If (IsV3Supported(connID%) = 1) Then
            rights$ = rights$ + "A"
        Else
            rights$ = rights$ + "P"
        End If
    Else
        rights$ = rights$ + " "
    End If

    If (rightsMask% And TR_ERASE) Then
        If (IsV3Supported(connID%) = 1) Then
            rights$ = rights$ + "E"
        Else
            rights$ = rights$ + "D"
        End If
    Else
        rights$ = rights$ + " "
    End If

    If (rightsMask% And TR_CREATE) Then
        rights$ = rights$ + "C"
    Else
        rights$ = rights$ + " "
    End If

    If (IsV3Supported(connID%) <> 1) Then
        If (rightsMask% And TA_OPEN) Then
            rights$ = rights$ + "O"
        Else
            rights$ = rights$ + " "
        End If
    End If

    If (rightsMask% And TR_WRITE) Then
        rights$ = rights$ + "W"
    Else
        rights$ = rights$ + " "
    End If

    If (rightsMask% And TR_READ) Then
        rights$ = rights$ + "R"
    Else
        rights$ = rights$ + " "
    End If

    GetRights = rights$
End Function

Sub OKButton_Click ()
    Unload DirDirForm
End Sub

