'NWPSERV.BAS  NetWare Print Server Services Interface for Visual Basic For Windows
'Version 1.0
'Novell Systems Research Department, Novell, Inc.
'Copyright (c) 1993, Novell, Inc.
'This interface is not supported through Novell's regular
'support channels.  See README.TXT for more information.

'Print server status
Global Const RUNNING = 0
Global Const GOING_DOWN = 1
Global Const DOWN = 2
Global Const INITIALIZING = 3

'Printer status
Global Const PRINTER_RUNNING = 0
Global Const PRINTER_OFFLINE = 1
Global Const PRINTER_PAPER_OUT = 2

'printControlFlags
Global Const SUPPRESS_FF = &H800
Global Const NOTIFY_USER = &H1000
Global Const TEXT_MODE = &H4000
Global Const PRINT_BANNER = &H8000

'Queue service modes
Global Const QUEUE_ONLY = 0
Global Const QUEUE_BEFORE_FORM = 1
Global Const FORM_ONLY = 2
Global Const FORM_BEFORE_QUEUE = 3

'Port configuration values
Global Const BAUD_RATE_0300 = 0
Global Const BAUD_RATE_0600 = 1
Global Const BAUD_RATE_1200 = 2
Global Const BAUD_RATE_2400 = 3
Global Const BAUD_RATE_4800 = 4
Global Const BAUD_RATE_9600 = 5

Global Const STOP_BITS_1 = 0
Global Const STOP_BITS_1_5 = 1
Global Const STOP_BITS_2 = 2

Global Const PARITY_NONE = 0
Global Const PARITY_EVEN = 1
Global Const PARITY_ODD = 2

'Printer types
Global Const P_PAR_1 = 0
Global Const P_PAR_2 = 1
Global Const P_PAR_3 = 2
Global Const P_SER_1 = 3
Global Const P_SER_2 = 4
Global Const P_SER_3 = 5
Global Const P_SER_4 = 6
Global Const P_REM_PAR_1 = 7
Global Const P_REM_PAR_2 = 8
Global Const P_REM_PAR_3 = 9
Global Const P_REM_SER_1 = 10
Global Const P_REM_SER_2 = 11
Global Const P_REM_SER_3 = 12
Global Const P_REM_SER_4 = 13
Global Const P_REM_OTHER = 14
Global Const P_ELSEWHERE = 15

'ObjectType for job owner (for notify object APIs)
Global Const JOB_OWNER = -1

'Job outcomes
Global Const PLACE_ON_HOLD = 0
Global Const RETURN_TO_QUEUE = 1
Global Const THROW_AWAY = 2

'Remote printer modes
Global Const REMOTE_SHARED = 0
Global Const REMOTE_PRIVATE = 1

'Printer status
Global Const PSTAT_WAITING_FOR_JOB = 0
Global Const PSTAT_WAITING_FOR_FORM = 1
Global Const PSTAT_PRINTING_JOB = 2
Global Const PSTAT_PAUSED = 3
Global Const PSTAT_STOPPED = 4
Global Const PSTAT_MARK_EJECT = 5
Global Const PSTAT_READY_TO_GO_DOWN = 6
Global Const PSTAT_NOT_CONNECTED = 7
Global Const PSTAT_PRIVATE = 8

'Print server communication errors
Global Const PSC_NO_AVAILABLE_SPX_CONNECTS = &H40
Global Const PSC_SPX_NOT_INITIALIZED = &H41
Global Const PSC_NO_SUCH_PRINT_SERVER = &H42
Global Const PSC_UNABLE_TO_GET_SERVER_ADDR = &H43
Global Const PSC_UNABLE_TO_CONNECT_TO_SERVER = &H44
Global Const PSC_NO_AVAILABLE_IPX_SOCKETS = &H45
Global Const PSC_ALREADY_ATTACHED_TO_PSERVER = &H46
Global Const PSC_IPX_NOT_INITIALIZED = &H47

'Print server error codes
Global Const PSE_TOO_MANY_FILE_SERVERS = &H101
Global Const PSE_UNKNOWN_FILE_SERVER = &H102
Global Const PSE_BINDERY_LOCKED = &H103
Global Const PSE_SERVER_MAXED_OUT = &H104
Global Const PSE_NO_RESPONSE = &H105
Global Const PSE_ALREADY_ATTACHED = &H106
Global Const PSE_CANT_ATTACH = &H107
Global Const PSE_NO_ACCOUNT_BALANCE = &H108
Global Const PSE_NO_CREDIT_LEFT = &H109
Global Const PSE_INTRUDER_DETECTION_LOCK = &H10A
Global Const PSE_TOO_MANY_CONNECTIONS = &H10B
Global Const PSE_ACCOUNT_DISABLED = &H10C
Global Const PSE_UNAUTHORIZED_TIME = &H10D
Global Const PSE_UNAUTHORIZED_STATION = &H10E
Global Const PSE_NO_MORE_GRACE = &H10F
Global Const PSE_LOGIN_DISABLED = &H110
Global Const PSE_ILLEGAL_ACCT_NAME = &H111
Global Const PSE_PASSWORD_HAS_EXPIRED = &H112
Global Const PSE_ACCESS_DENIED = &H113
Global Const PSE_CANT_LOGIN = &H114
Global Const PSE_NO_SUCH_QUEUE = &H200
Global Const PSE_NOT_AUTHORIZED_FOR_QUEUE = &H201
Global Const PSE_QUEUE_HALTED = &H202
Global Const PSE_UNABLE_TO_ATTACH_TO_QUEUE = &H203
Global Const PSE_TOO_MANY_QUEUE_SERVERS = &H204
Global Const PSE_INVALID_REQUEST = &H300
Global Const PSE_NOT_ENOUGH_MEMORY = &H301
Global Const PSE_NO_SUCH_PRINTER = &H302
Global Const PSE_INVALID_PARAMETER = &H303
Global Const PSE_PRINTER_BUSY = &H304
Global Const PSE_CANT_DETACH_PRIMARY_SERVER = &H305
Global Const PSE_GOING_DOWN = &H306
Global Const PSE_NOT_CONNECTED = &H307
Global Const PSE_ALREADY_IN_USE = &H308
Global Const PSE_NO_JOB_ACTIVE = &H309
Global Const PSE_NOT_ATTACHED_TO_SERVER = &H30A
Global Const PSE_ALREADY_IN_LIST = &H30B
Global Const PSE_DOWN = &H30C
Global Const PSE_NOT_IN_LIST = &H30D
Global Const PSE_NO_RIGHTS = &H30E
Global Const PSE_UNABLE_TO_VERIFY_IDENTITY = &H400
Global Const PSE_NOT_REMOTE_PRINTER = &H401

'Client privilege levels for print server
Global Const PS_LIMITED = 0                ' Limited access only
Global Const PS_USER = 1                   ' User access
Global Const PS_OPERATOR = 2               ' Operator access


Type PS_INFO
    status As String * 1
    numPrinters As String * 1
    numModes As String * 1
    majorVersion As String * 1
    minorVersion As String * 1
    revision As String * 1
    serialNumber As String * 4
    serverType As String * 1
End Type

Type REMOTE_INFO
    printerType As Integer
    useInterrupts As Integer
    irqNumber As Integer
    numBlocks As Integer
    useXonXoff As Integer
    baudRate As Integer
    dataBits As Integer
    stopBits As Integer
    parity As Integer
    socket As Integer
End Type

Declare Function PSAbortPrintJob Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal jobOutcome%) As Integer
Declare Function PSAddNotifyObject Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal fileServer$, ByVal objectName$, ByVal objectType%, ByVal firstNotif%, ByVal nextNotif%) As Integer
Declare Function PSAddQueueToPrinter Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal fileServer$, ByVal queue$, ByVal priority%) As Integer
Declare Function PSAttachPrintServerToFileServer Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal fileServer$, ByVal password$) As Integer
Declare Function PSAttachToPrintServer Lib "NWPSERV.DLL" (ByVal printServerName$, connectionID%) As Integer
Declare Function PSCancelDownRequest Lib "NWPSERV.DLL" (ByVal spxConn%) As Integer
Declare Function PSChangeNotifyInterval Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal fileServer$, ByVal objectName$, ByVal objectType%, ByVal firstNotif%, ByVal nextNotif%) As Integer
Declare Function PSChangeQueuePriority Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal fileServer$, ByVal queue$, ByVal priority%) As Integer
Declare Function PSChangeServiceMode Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal serviceMode%) As Integer
Declare Function PSDeleteNotifyObject Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal fileServer$, ByVal objectName$, ByVal objectType%) As Integer
Declare Function PSDeleteQueueFromPrinter Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal fileServer$, ByVal queue$, ByVal immed%, ByVal jobOutcome%) As Integer
Declare Function PSDetachFromPrintServer Lib "NWPSERV.DLL" (ByVal connID%) As Integer
Declare Function PSDetachPrtServerFromFileServer Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal fileServer$, ByVal immed%, ByVal jobOutcome%) As Integer
Declare Function PSDownPrintServer Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal immed%, ByVal jobOutcome%) As Integer
Declare Function PSEjectForm Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%) As Integer
Declare Function PSGetAttachedServers Lib "NWPSERV.DLL" (ByVal spxConn%, sequence%, ByVal fileServer$) As Integer
Declare Function PSGetNextRemotePrinter Lib "NWPSERV.DLL" (ByVal spxConn%, printer%, printerType%, ByVal printerName$) As Integer
Declare Function PSGetNotifyObject Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, sequence%, ByVal fileServer$, ByVal objectName$, objectType%, firstNotif%, nextNotif%) As Integer
'printerList% must be initialized to maxPrinters% bytes
Declare Function PSGetPrintersServicingQueue Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal fileServer$, ByVal queue$, ByVal maxPrinter%, numPrinters%, printerList%) As Integer
Declare Function PSGetPrinterStatus Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, status%, problem%, hasJob%, serviceMode%, formNumber%, ByVal formName$, ByVal printerName) As Integer
Declare Function PSGetPrintJobStatus Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal fileServer$, ByVal queueName$, jobNumber%, ByVal jobDesc$, copiesToPrint%, jobSize&, copyiesDone%, bytesIntoCopy&, neededForm%, text%) As Integer
Declare Function PSGetPrintServerInfo Lib "NWPSERV.DLL" (ByVal spxConn%, info As PS_INFO, ByVal size%) As Integer
Declare Function PSGetQueuesServiced Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, sequence%, ByVal fileServer$, ByVal queue$, priority%) As Integer
Declare Function PSLoginToPrintServer Lib "NWPSERV.DLL" (ByVal spxConn%, clientAccessLevel%) As Integer
Declare Function PSMarkTopOfForm Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal character%) As Integer
Declare Function PSRequestRemotePrinter Lib "NWPSERV.DLL" (ByVal spxConn%, printerInfo As REMOTE_INFO) As Integer
Declare Function PSRewindPrintJob Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal byPage%, ByVal relative%, ByVal copy%, ByVal offset&) As Integer
Declare Function PSSetMountedForm Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal formNumber%) As Integer
Declare Function PSSetRemoteMode Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal mode%) As Integer
Declare Function PSStartPrinter Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%) As Integer
Declare Function PSStopPrinter Lib "NWPSERV.DLL" (ByVal spxConn%, ByVal printer%, ByVal jobOutcome%) As Integer

