VERSION 2.00
Begin Form MidiForm 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "MIDI Setup"
   ClientHeight    =   2730
   ClientLeft      =   2295
   ClientTop       =   2505
   ClientWidth     =   4230
   ControlBox      =   0   'False
   Height          =   3135
   Left            =   2235
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2730
   ScaleWidth      =   4230
   Top             =   2160
   Width           =   4350
   Begin SSPanel Z 
      AutoSize        =   3  'AutoSize Child To Panel
      BackColor       =   &H00C0C0C0&
      BevelInner      =   1  'Inset
      BevelOuter      =   0  'None
      BevelWidth      =   3
      BorderWidth     =   0
      Font3D          =   0  'None
      ForeColor       =   &H00FF0000&
      Height          =   555
      Index           =   10
      Left            =   1530
      TabIndex        =   2
      Top             =   2010
      Width           =   1095
      Begin SSCommand cmdOK 
         BevelWidth      =   3
         Caption         =   "&OK"
         Font3D          =   0  'None
         ForeColor       =   &H00FF0000&
         Height          =   465
         Left            =   45
         Outline         =   0   'False
         TabIndex        =   3
         Top             =   45
         Width           =   1005
      End
   End
   Begin SSPanel Z 
      Alignment       =   6  'Center - TOP
      BackColor       =   &H00C0C0C0&
      BevelInner      =   2  'Raised
      BevelOuter      =   0  'None
      BevelWidth      =   2
      BorderWidth     =   0
      Caption         =   "MIDI Out Device"
      Font3D          =   3  'Inset w/light shading
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   795
      Index           =   1
      Left            =   150
      TabIndex        =   1
      Top             =   1050
      Width           =   3915
      Begin SSPanel Z 
         Alignment       =   6  'Center - TOP
         AutoSize        =   3  'AutoSize Child To Panel
         BackColor       =   &H00C0C0C0&
         BevelInner      =   1  'Inset
         BevelOuter      =   0  'None
         BevelWidth      =   2
         BorderWidth     =   0
         Font3D          =   3  'Inset w/light shading
         ForeColor       =   &H00FF0000&
         Height          =   360
         Index           =   3
         Left            =   120
         TabIndex        =   6
         Top             =   300
         Width           =   3645
         Begin ComboBox OutList 
            Height          =   300
            Left            =   30
            Style           =   2  'Dropdown List
            TabIndex        =   7
            TabStop         =   0   'False
            Top             =   30
            Width           =   3585
         End
      End
   End
   Begin SSPanel Z 
      Alignment       =   6  'Center - TOP
      BackColor       =   &H00C0C0C0&
      BevelInner      =   2  'Raised
      BevelOuter      =   0  'None
      BevelWidth      =   2
      BorderWidth     =   0
      Caption         =   "MIDI In Device"
      Font3D          =   3  'Inset w/light shading
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   765
      Index           =   0
      Left            =   150
      TabIndex        =   0
      Top             =   150
      Width           =   3915
      Begin SSPanel Z 
         Alignment       =   6  'Center - TOP
         AutoSize        =   3  'AutoSize Child To Panel
         BackColor       =   &H00C0C0C0&
         BevelInner      =   1  'Inset
         BevelOuter      =   0  'None
         BevelWidth      =   2
         BorderWidth     =   0
         Font3D          =   3  'Inset w/light shading
         ForeColor       =   &H00FF0000&
         Height          =   360
         Index           =   2
         Left            =   120
         TabIndex        =   4
         Top             =   300
         Width           =   3645
         Begin ComboBox InList 
            Height          =   300
            Left            =   30
            Style           =   2  'Dropdown List
            TabIndex        =   5
            TabStop         =   0   'False
            Top             =   30
            Width           =   3585
         End
      End
   End
End
Option Explicit

Sub cmdOK_Click ()
    Midi_SaveIni
    Hide
End Sub

Sub Form_Activate ()
    Midi_LoadIni
End Sub

Sub Form_Load ()
     Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
End Sub

Sub InList_Click ()
    If InList.ListIndex > -1 Then
        InDevice = InList.ListIndex
        MidiIn_Open (InDevice)
    End If
End Sub

Sub Midi_LoadIni ()
    Dim FileData, Msg As String, ap As String
    Dim Fnum, ii, jj

    On Error GoTo Midi_LoadIniError

    Fnum = FreeFile     'MTC.INI ha d'estar
                        'al mateix directori que l'aplicaci

    ap = App.Path
    If Right$(ap, 1) <> "\" Then ap = ap & "\"
    Open ap & "MTC.INI" For Input As Fnum

    jj = 1
    Do While Not EOF(Fnum)
        Line Input #Fnum, FileData
        If Left$(FileData, 1) = "*" Then
            ii = Mid$(FileData, 2)
            Select Case jj
                Case 1
                    OutDevice = Val(ii)
                    If MidiForm.OutList.ListCount > OutDevice + 1 Then
                        MidiForm.OutList.ListIndex = OutDevice + 1
                    Else
                        OutDevice = -2
                        MidiForm.OutList.ListIndex = -1
                    End If

                Case 2
                    InDevice = Val(ii)
                    If MidiForm.InList.ListCount > InDevice Then
                        MidiForm.InList.ListIndex = InDevice
                    Else
                        InDevice = -1
                        MidiForm.InList.ListIndex = -1
                    End If

            End Select
            jj = jj + 1
        End If
    Loop

Midi_LoadIniEnd:
    Close Fnum
    Exit Sub

Midi_LoadIniError:
    'Valors per defecte

    If MidiForm.OutList.ListCount > 0 Then
        MidiForm.OutList.ListIndex = 0
        OutDevice = -1
    Else
        MidiForm.OutList.ListIndex = -1
        OutDevice = -2
    End If

    If MidiForm.InList.ListCount > 0 Then
        MidiForm.InList.ListIndex = 0
        InDevice = 0
    Else
        MidiForm.InList.ListIndex = -1
        InDevice = -1
    End If

    Resume Midi_LoadIniEnd
End Sub

Sub Midi_SaveIni ()
    Dim Msg As String, ap As String
    Dim Fnum, i

    On Error GoTo Midi_SaveIniError

    Fnum = FreeFile

    ap = App.Path
    If Right$(ap, 1) <> "\" Then ap = ap & "\"
    Open ap & "MTC.INI" For Output As Fnum    'If file doesn't exists it's created

    Print #Fnum, "[MidiOut Device]"
    Print #Fnum, "*" & Format$(OutDevice)
    Print #Fnum,
    
    Print #Fnum, "[MidiIn Device]"
    Print #Fnum, "*" & Format$(InDevice)
    Print #Fnum,


Midi_SaveIniEnd:
    Close Fnum
    Exit Sub

Midi_SaveIniError:
    Msg = "'MTC.INI' not created!"
    Dlg_Alert Msg
    Resume Midi_SaveIniEnd

End Sub

Sub OutList_Click ()
    If OutList.ListIndex > -1 Then
        OutDevice = OutList.ListIndex - 1
        MidiOut_Open (OutDevice)
    End If
End Sub

