/*------------------------------------------------------------------------------* 
 |                                                                              |
 |                          File Name: CIRC1.CPP                                |
 |                                                                              |
 | Description:  This file contains all the functions that are used by the      |
 |               VBX control using the Microsoft Foundation Classes.            |
 |                                                                              |
 | History:      Date              Author                Comment                |
 |              03/23/93      Pran Punniamoorthy         Created                |
 |                                                                              |
 *------------------------------------------------------------------------------*/

#define _USRDLL             // Export a "C" interface
#include <afxwin.h> 

extern "C"                  // Avoid name mangling of these "C" header files
{
#include <vbapi.h>
#include "circ1.h"          // Contains the VB Property, Event & MODEL definitions
} 

#include "mfcvbx.h"         // Contains the MFC Class definitions

////////////////////////  CWinApp Object functions ////////////////////////////////////////////

CVBDLL theApp;  // Do all the MFC initializations and also call LibMain()    

BOOL CVBDLL::InitInstance()  // Do any of your one time intializations here
{return TRUE;} 

int  CVBDLL::ExitInstance()  // Do any of your one time cleanup here.
{return 0;}

/*------------------------------------------------------------------------------*
 |                       Constructor For class CVBCtlWnd                        |
 |                                                                              |
 | Description:  In the constructor, the hwnd of the control is attached to the |
 |               object that is created.  The m_hCtl member is initialized to   |
 |               the hctl that was passed to the control procedure.             |
 |                                                                              |
 | Parameters :  hwnd - Hwnd of the VBX control                                 |
 |                                                                              |
 | Returns    :  void                                                           |
 |                                                                              |
 *------------------------------------------------------------------------------*/

CVBCtlWnd::CVBCtlWnd(HWND hwnd)
{      
    Attach(hwnd);
    m_hCtl = ::VBGetHwndControl(hwnd);
}

/*------------------------------------------------------------------------------*
 |                       CVBCtlWnd::OnLButtonDown()                             |
 |                                                                              |
 | Description:  This function displays a MessageBox containing the point when  |
 |               the user presses the Left Mouse Button.                        |
 |                                                                              |
 | Parameters :  Flag - UINT    - Contains the flag                             |
 |               pt   - CPoint  - Contains the Point                            |
 |                                                                              |
 | Returns    :  void                                                           |
 |                                                                              |
 *------------------------------------------------------------------------------*/

void CVBCtlWnd::OnRButtonDown(UINT Flag, CPoint pt)
{
   char buf[25];
   wsprintf(buf,"Point = (%d,%d)",pt.x,pt.y);
   MessageBox(buf,"Right Button Down",MB_OK);
}


/*------------------------------------------------------------------------------*
 |                       CVBCtlWnd::DefWindowProc()                             |
 |                                                                              |
 | Description:  This function simply passes the unprocessed message to         |
 |               VBDefControlProc()                                             |
 |                                                                              |
 | Parameters :  msg - UINT    - The Message                                    |
 |               wp  - WPARAM  - The WPARAM                                     |
 |               lp  - LPARAM  - The LPARAM                                     | 
 |                                                                              |
 | Returns    :  LRESULT                                                        |
 |                                                                              |
 *------------------------------------------------------------------------------*/

LRESULT CVBCtlWnd::DefWindowProc(UINT msg,WPARAM wp,LPARAM lp)
{                                            
    return ::VBDefControlProc(m_hCtl,m_hWnd,msg,wp,lp); // call VBDefControlProc with the last message
}                   


/////////////////////////  Message Map of CVBCtlWnd Class  //////////////////////////////////////////

BEGIN_MESSAGE_MAP(CVBCtlWnd, CWnd)
    //{{AFX_MSG_MAP(CVBCtlWnd)
    ON_WM_RBUTTONDOWN()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()



/*------------------------------------------------------------------------------*
 |                       Function:: CircleCtlProc                               |
 |                                                                              |
 | Description:  This function is the control procedure defined in the MODEL    |
 |               structure's control procedure field which is the 3rd field     |
 |               of this structure.                                             |
 |                                                                              |
 | Parameters :  hctl - HCTL    - The handle to the HCTL structure              |
 |               hwnd - HWND    - The handle to the hwnd of the control         |
 |               msg  - USHORT  - The Message                                   |
 |               wp   - WPARAM  - The WPARAM                                    |
 |               lp   - LPARAM  - The LPARAM                                    | 
 |                                                                              |
 | Returns    :  LONG                                                           |
 |                                                                              |
 *------------------------------------------------------------------------------*/

extern "C" LONG FAR PASCAL _export CircleCtlProc(HCTL hctl,HWND hwnd,USHORT msg,USHORT wp,LONG lp)
{
    if(hwnd == FALSE)                     // If hwnd == 0 then no point going further
      return ::VBDefControlProc(hctl,hwnd,msg,wp,lp);
    
    theApp.OnIdle(0L);                    // Allow MFC to cleanup any temporary objects created.
    
    CVBCtlWnd* pCtl = (CVBCtlWnd*)CWnd::FromHandlePermanent(hwnd); 
    
    if(pCtl == NULL)                      // Only create CVBCtlWnd Object once per instance of Control.
      pCtl = new CVBCtlWnd(hwnd);
    
    return (pCtl->WindowProc(msg,wp,lp)); // This will eventually call ::VBDefControlProc()       
}

/*------------------------------------------------------------------------------*
 |                       Function::VBINITCC()                                   |
 |                                                                              |
 | Description:  This function initializes and registers the model used for the |
 |               VBX control.                                                   |
 |                                                                              |
 | Parameters :  USHORT - Not used                                              |
 |               BOOL   - Not used                                              |
 |                                                                              |
 | Returns    :  BOOL                                                           |
 |                                                                              |
 *------------------------------------------------------------------------------*/

extern "C" BOOL FAR PASCAL _export VBINITCC(USHORT,BOOL)
{   
    return ::VBRegisterModel(AfxGetInstanceHandle(), &modelCircle);   // Register the Control Class
}   


