Option Explicit
Type LinkedListType
   Forward As Integer
   Backward As Integer
   Data As String * 100
End Type
Global Const LLSIZE = 100
Global LL(1 To LLSIZE) As LinkedListType
Global Const TITLE = "Linked List Demo"
Global FirstItem As Integer
Global LastItem As Integer

Sub ClearLinkedList ()
Dim x As Integer

For x = 1 To LLSIZE
   LL(x).Forward = -1
   LL(x).Backward = -1
Next x
FirstItem = -1
LastItem = -1

End Sub

Sub Main ()

ClearLinkedList
Form1.Caption = TITLE
Form1.Show

End Sub

Function NextFreeElement () As Integer
Dim x As Integer

For x = 1 To LLSIZE
   If LL(x).Forward = -1 And LL(x).Backward = -1 And (FirstItem <> x) Then
      NextFreeElement = x
      Exit Function
   End If
Next x

NextFreeElement = -1

End Function

Sub SetPointers (NewListItem As Integer)
Dim TestItem As Integer
Dim PositionFound As Integer
Dim NewBackward As Integer

If FirstItem = -1 Then
   FirstItem = NewListItem
   LastItem = NewListItem
   Exit Sub
End If

TestItem = FirstItem
PositionFound = False

Do While Not PositionFound

   If LL(NewListItem).Data < LL(TestItem).Data Then
      
      Select Case TestItem
         Case FirstItem
            LL(NewListItem).Forward = FirstItem
            LL(NewListItem).Backward = -1
            LL(FirstItem).Backward = NewListItem
            FirstItem = NewListItem
            PositionFound = True
         Case Else
            LL(NewListItem).Forward = TestItem
            NewBackward = LL(TestItem).Backward
            LL(NewListItem).Backward = NewBackward
            LL(NewBackward).Forward = NewListItem
            LL(TestItem).Backward = NewListItem
            PositionFound = True
      End Select

   Else

      If TestItem = LastItem Then
         LL(NewListItem).Forward = -1
         LL(NewListItem).Backward = LastItem
         LL(LastItem).Forward = NewListItem
         LastItem = NewListItem
         PositionFound = True
      Else
         TestItem = LL(TestItem).Forward
      End If

   End If

Loop

End Sub

