VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Kalendar Settings"
   ClientHeight    =   4095
   ClientLeft      =   3195
   ClientTop       =   345
   ClientWidth     =   6375
   Height          =   4500
   Left            =   3135
   LinkTopic       =   "Form1"
   ScaleHeight     =   4095
   ScaleWidth      =   6375
   Top             =   0
   Width           =   6495
   Begin ComboBox cmbDOWAlignment 
      BackColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   4440
      Style           =   2  'Dropdown List
      TabIndex        =   13
      Top             =   3225
      Width           =   1845
   End
   Begin ComboBox cmbHeadingAlign 
      BackColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   4440
      Style           =   2  'Dropdown List
      TabIndex        =   11
      Top             =   2685
      Width           =   1845
   End
   Begin CheckBox chkShowAllDays 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Show All Days"
      Height          =   225
      Left            =   4440
      TabIndex        =   10
      Top             =   3825
      Width           =   1815
   End
   Begin CheckBox chkFixed 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Fixed Day Height"
      Height          =   225
      Left            =   4440
      TabIndex        =   8
      Top             =   3570
      Width           =   1815
   End
   Begin ComboBox cmbAlignment 
      BackColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   4440
      Style           =   2  'Dropdown List
      TabIndex        =   7
      Top             =   2175
      Width           =   1845
   End
   Begin ComboBox cmbFirstDOW 
      BackColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   4440
      Style           =   2  'Dropdown List
      TabIndex        =   4
      Top             =   1635
      Width           =   1845
   End
   Begin ComboBox cmbStyle 
      BackColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   4440
      Style           =   2  'Dropdown List
      TabIndex        =   2
      Top             =   1095
      Width           =   1845
   End
   Begin Kalendar Kalendar1 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      DateDispStyle   =   0  'Normal
      DayAlignment    =   8  'Bottom Right
      DOWAlign        =   2  'Center
      DOWBackColor    =   &H00C0C0C0&
      DOWBorder       =   -1  'True
      DOWDispStyle    =   2  'Medium
      DOWFontBold     =   -1  'True
      DOWFontItalic   =   0   'False
      DOWFontName     =   "MS Sans Serif"
      DOWFontSize     =   8.25
      DOWFontStrikeThru=   0   'False
      DOWFontUnderline=   0   'False
      DOWForeColor    =   &H00000000&
      EnableKeys      =   -1  'True
      FirstDOW        =   0  'Sunday
      FixedDayHeight  =   0   'False
      ForeColor       =   &H00000000&
      Height          =   3645
      Left            =   0
      LineColor       =   &H00000000&
      MonAlign        =   0  'Left
      MonBackColor    =   &H00C0C0C0&
      MonDispStyle    =   2  'Month/Year
      MonFontBold     =   -1  'True
      MonFontItalic   =   0   'False
      MonFontName     =   "Arial"
      MonFontSize     =   12
      MonFontStrikeThru=   0   'False
      MonFontUnderline=   0   'False
      MonForeColor    =   &H00000000&
      OtherMonBackColor=   &H00C0C0C0&
      OtherMonForeColor=   &H00FFFFFF&
      SelDayBackColor =   &H00C0C0C0&
      SelDayForeColor =   &H00000000&
      ShowAllDays     =   0   'False
      ShowArrows      =   -1  'True
      ShowLines       =   -1  'True
      ShowSelection   =   -1  'True
      TabIndex        =   0
      TabStop         =   0   'False
      Text            =   "06/11/94"
      Top             =   360
      Width           =   4230
   End
   Begin Label Label7 
      BackColor       =   &H00C0C0C0&
      Caption         =   "DOW Alignment"
      Height          =   195
      Left            =   4440
      TabIndex        =   14
      Top             =   3030
      Width           =   1350
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "Label1"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   13.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   315
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   4245
   End
   Begin Label Label6 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Month Alignment"
      Height          =   195
      Left            =   4440
      TabIndex        =   12
      Top             =   2505
      Width           =   1425
   End
   Begin Label Label5 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Here is just a sampling of the properties that Kalendar provides."
      Height          =   855
      Left            =   4440
      TabIndex        =   9
      Top             =   -15
      Width           =   1830
   End
   Begin Label Label4 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Day Alignment"
      Height          =   195
      Left            =   4440
      TabIndex        =   6
      Top             =   1980
      Width           =   1230
   End
   Begin Label Label3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "First Day of Week"
      Height          =   195
      Left            =   4440
      TabIndex        =   5
      Top             =   1455
      Width           =   1545
   End
   Begin Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Display Style"
      Height          =   195
      Left            =   4440
      TabIndex        =   3
      Top             =   885
      Width           =   1110
   End
End

Option Explicit

Dim lastScroll As Integer

Sub chkFixed_Click ()
    Kalendar1.FixedDayHeight = chkFixed.Value
End Sub

Sub chkShowAllDays_Click ()
    Kalendar1.ShowAllDays = chkShowAllDays.Value
End Sub

Sub cmbAlignment_Click ()
    Kalendar1.DayAlignment = cmbAlignment.ListIndex
End Sub

Sub cmbDOWAlignment_Click ()
    Kalendar1.DOWAlign = cmbDOWAlignment.ListIndex
End Sub

Sub cmbFirstDOW_Click ()
    Kalendar1.FirstDOW = cmbFirstDOW.ListIndex
End Sub

Sub cmbHeadingAlign_Click ()
    Kalendar1.MonAlign = cmbHeadingAlign.ListIndex
End Sub

Sub cmbStyle_Click ()

    If cmbStyle.ListIndex = 0 Then
        ' Get back the original colors.
        Kalendar1.BackColor = RGB(255, 255, 255)
        Kalendar1.ForeColor = 0
        Kalendar1.SelDayBackColor = RGB(192, 192, 192)
        Kalendar1.SelDayForeColor = 0
        Kalendar1.LineColor = 0
    End If
    Kalendar1.DateDispStyle = cmbStyle.ListIndex
End Sub

Sub Command1_Click ()
    Form3.Show
End Sub

Sub Command2_Click ()
    Form2.Show
End Sub

Sub Form_Activate ()
    SetDescription Sample1Description()
End Sub

Sub Form_DblClick ()
    'Form2.Show 1
End Sub

Sub Form_Load ()
Dim i As Integer
    lastScroll = 0

    Kalendar1.Text = Date

    SetUpCombos

End Sub

Sub Kalendar1_ClickDay ()
    Label1.Caption = "Date: " & Kalendar1.Text
End Sub

Sub Kalendar1_DblClickDay ()
    MsgBox "A Double Click! " & Kalendar1.Text
End Sub

Sub Kalendar1_DragDrop (Source As Control, x As Single, y As Single)
Dim tmpDay As String

    Kalendar1.PointX = x
    Kalendar1.PointY = y

    tmpDay = Kalendar1.DateAtPoint
    If tmpDay <> "" Then
        Kalendar1.Text = Kalendar1.DateAtPoint
        MsgBox "You dropped " & Source.Caption
    End If
End Sub

Sub Kalendar1_DragOver (Source As Control, x As Single, y As Single, State As Integer)
Dim tmpDay As String
    Kalendar1.PointX = x
    Kalendar1.PointY = y

    tmpDay = Kalendar1.DateAtPoint
    If tmpDay <> "" Then
        Kalendar1.Text = Kalendar1.DateAtPoint
    End If
End Sub

Sub Kalendar1_DrawDay (hdc As Integer, State As Integer, theDay As Long, x As Single, y As Single, x2 As Single, y2 As Single, Cancel As Integer)
Dim DOW As Integer

    DOW = Format(theDay, "w")

    Select Case State
        Case KAL_STATE_NOT_SELECTED:
            If DOW = 1 Or DOW = 7 Then
                Kalendar1.BackColor = RGB(128, 0, 128)
            Else
                Kalendar1.BackColor = RGB(255, 0, 255)
                Kalendar1.LineColor = RGB(255, 0, 255)
            End If
    
        Case KAL_STATE_SELECTED_WITH, KAL_STATE_SELECTED_WITHOUT:
            If DOW = 1 Or DOW = 7 Then
                Kalendar1.SelDayBackColor = RGB(255, 0, 0)
                Kalendar1.LineColor = RGB(255, 0, 0)
            Else
                Kalendar1.SelDayBackColor = RGB(192, 0, 0)
                Kalendar1.LineColor = RGB(192, 0, 0)
            End If

        Case KAL_STATE_OTHERMONTH:
            If DOW = 1 Or DOW = 7 Then
                Kalendar1.OtherMonBackColor = RGB(128, 0, 128)
            Else
                Kalendar1.OtherMonBackColor = RGB(255, 0, 255)
            End If
    End Select

    If DOW = 1 Or DOW = 7 Then
        Kalendar1.DayAlignment = 8
        Kalendar1.LineColor = RGB(0, 255, 0)
        Kalendar1.ForeColor = RGB(255, 255, 255)
    Else
        Kalendar1.DayAlignment = 0
        Kalendar1.LineColor = RGB(0, 255, 255)
        Kalendar1.ForeColor = RGB(0, 0, 0)
    End If

End Sub

Function Sample1Description () As String
Dim CR As String
Dim s As String

    s = "This sample highlights some of the flexibilty of a Kalendar."
    s = s & "The most interesting property is the Display Style (DayDispStyle), by setting this property you can: " & CR
    s = s & "   1) Let the custom control draw itself based on the selected properties. (Ho hum)" & CR
    s = s & "   2) Let the custom control draw the day boxes like 3-D buttons. (Yipee)" & CR
    s = s & "   3) Draw the day boxes yourself. (Cool!)"
    s = s & "When you select the user defined drawing method (number 3), you have several options for affecting how a day box is drawn. "
    s = s & "This sample simply changes the background color of a day and the day alignment based on the day of the week. "
    s = s & "Other samples in this demo show how you can draw on top of each day box, or even draw the entire day box itself."

    Sample1Description = s
End Function

Sub SetUpCombos ()
    cmbStyle.AddItem "Normal"
    cmbStyle.AddItem "3D"
    cmbStyle.AddItem "User-Defined"

    cmbStyle.ListIndex = 0

    cmbFirstDOW.AddItem "Sunday"
    cmbFirstDOW.AddItem "Monday"
    cmbFirstDOW.AddItem "Tuesday"
    cmbFirstDOW.AddItem "Wednesday"
    cmbFirstDOW.AddItem "Thursday"
    cmbFirstDOW.AddItem "Friday"
    cmbFirstDOW.AddItem "Saturday"
    cmbFirstDOW.ListIndex = 0

    cmbAlignment.AddItem "Upper Left"
    cmbAlignment.AddItem "Upper Center"
    cmbAlignment.AddItem "Upper Right"
    cmbAlignment.AddItem "Mid Left"
    cmbAlignment.AddItem "Mid Center"
    cmbAlignment.AddItem "Mid Right"
    cmbAlignment.AddItem "Lower Left"
    cmbAlignment.AddItem "Lower Center"
    cmbAlignment.AddItem "Lower Right"
    cmbAlignment.ListIndex = 0

    cmbHeadingAlign.AddItem "Left"
    cmbHeadingAlign.AddItem "Right"
    cmbHeadingAlign.AddItem "Center"
    cmbHeadingAlign.ListIndex = 2

    cmbDOWAlignment.AddItem "Left"
    cmbDOWAlignment.AddItem "Right"
    cmbDOWAlignment.AddItem "Center"
    cmbDOWAlignment.ListIndex = 2

End Sub

