VERSION 2.00
Begin Form Form1 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Webster's Dictionary"
   ClientHeight    =   4545
   ClientLeft      =   630
   ClientTop       =   1875
   ClientWidth     =   9405
   Height          =   4950
   Icon            =   WEBSTER.FRX:0000
   Left            =   570
   LinkTopic       =   "Form1"
   ScaleHeight     =   4545
   ScaleWidth      =   9405
   Top             =   1530
   Width           =   9525
   Begin CommandButton btnDone 
      Cancel          =   -1  'True
      Caption         =   "Done"
      Height          =   375
      Left            =   90
      TabIndex        =   4
      Top             =   4095
      Width           =   1050
   End
   Begin CommandButton btnDefine 
      Caption         =   "Define"
      Default         =   -1  'True
      Height          =   375
      Left            =   7920
      TabIndex        =   3
      Top             =   45
      Width           =   1365
   End
   Begin TextBox txtWord 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   360
      Left            =   675
      TabIndex        =   0
      Top             =   90
      Width           =   4245
   End
   Begin TextBox txtDesc 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   3480
      Left            =   90
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      Top             =   540
      Width           =   9195
   End
   Begin dsSocket dsSocket1 
      DataSize        =   2048
      Left            =   1305
      Linger          =   0   'False
      LocalPort       =   0
      RemoteDotAddr   =   ""
      RemoteHost      =   ""
      RemotePort      =   0
      ServiceName     =   ""
      Timeout         =   0
      Top             =   4095
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Word:"
      Height          =   195
      Left            =   90
      TabIndex        =   2
      Top             =   135
      Width           =   525
   End
End
DefInt A-Z

Dim Connected

Sub btnDefine_Click ()
    
    On Error GoTo ConnectError:
    
    '-- Clear the description
    txtDesc = ""
    
    '-- Are we already connected?
    If dsSocket1.Socket = 0 Then
        '-- No. Connect to the Webster Server
        dsSocket1.RemotePort = 2627
        dsSocket1.RemoteHost = "grouchy.cs.indiana.edu"
        '-- Connect
        dsSocket1.Action = DSSOCK_CONNECT
        '-- Temporarily disable the txtWord field
        txtWord.Enabled = False
        Screen.MousePointer = 11
        '-- Wait until we've connected
        Do
            DoEvents
        Loop Until Connected
    End If
    
    '-- Send the definition request
    dsSocket1.Send = "DEFINE " & txtWord & Chr$(10)

    Exit Sub

ConnectError:

    MsgBox Error

End Sub

Sub btnDone_Click ()
    '-- Unload the form
    Unload Me
End Sub

Sub dsSocket1_Connect ()
    '-- Set the Connect flag to True.
    Connected = True
End Sub

Sub dsSocket1_Exception (ErrorCode As Integer, ErrorDesc As String)
'-- An exception (error) has occurred
    If ErrorCode = 0 Then
        '-- We were disconnected
        Connected = False
    End If
    MsgBox ErrorDesc
End Sub

Sub dsSocket1_Receive (receiveData As String)
    '-- Data has been received by sockets
    
    '-- Add this data to the description
    txtDesc = txtDesc & Left$(receiveData, Len(receiveData) - 1)
    
    '-- Re-enable and clear the word field, and
    '   set focus to it.
    Screen.MousePointer = 0
    txtWord.Enabled = True
    txtWord = ""
    txtWord.SetFocus

End Sub

Sub Form_Unload (Cancel As Integer)
    '-- Close any open connection (very important)
    If dsSocket1.Socket Then
        dsSocket1.Action = DSSOCK_CLOSE
    End If
    End
End Sub

