Option Explicit

'used to store the file name that receives the update...
'File=x.x...where x.x is the file name to update...
'  eg. WIN.INI updates the WIN.INI file in the users windows
'              directory
'      ODBC.INI updates the ODBC.INI file in the users windows
'              directory
'      C:\NET\BIN\NET.INI updates the NET.INI file in the
'              C:\NET\BIN directory
Global sgFileName As String

'flag indicating if the sgFileName to update is a private INI file...
'True=it is
'False=the target sgFileName is WIN.INI
Global sgPrivate As Integer

'stores the application section name...
'Application=...indicates the section to look for in the INI
'               file...sections are those enclosed in []
Global sgApp As String

'stores the key name...
'Key=...indicates the key name to look for within the specified
'       section...key names are on the left side of the =
Global sgKey As String

'stores the default value for the target key name...
'Default=...indicates the key value to verify/update within the
'           specified section and key name...key values are on
'           on the right side of the =
Global sgDefault As String

'stores the log file name...
'FileName=x.x...where x.x is the file name to update...the file
'               is always located in the applications startup
'               directory
Global sgLogFile As String

'flag used to track if the app runs
'in interactive mode...
'Interactive=-1...show modal message boxes when errors occur
'                 (this requires user input before continuing)
'Interactive=0....do not show any message boxes when errors
'                 occur, except when the INIUPD.INI file can't
'                 be found.
Global ngInter As Integer

'message box stop icon...
Global Const MB_ICONSTOP = 16

Declare Function FindWindow% Lib "user" (ByVal lpClassName As Any, ByVal lpCaption As Any)
Declare Function ShowWindow Lib "User" (ByVal hWnd As Integer, ByVal nCmdShow As Integer) As Integer
Declare Function SFocus% Lib "User" Alias "SetFocus" (ByVal Handle As Integer)
Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer

Declare Function WriteProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lplFileName As String) As Integer

Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer

Declare Function GetProfileInt Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal nDefault As Integer) As Integer
Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer

