Option Explicit

Function nCheckUnique (sCaption As String) As Integer
    'checks to see if another instance of passed
    'caption/app exists
    '
    'pass string sCaption containing the caption
    'of the window your trying to find
    '
    'nCheckUnique returns:
    '   True = if no previous instance is found
    '   False = if a previous instance is found
    '

    Dim nFHandle As Integer
    Dim nX As Integer
    
    'does it exist?
    nFHandle = FindWindow(0&, sCaption)

    'FindWindow returns 0 if instance not found...
    '           or the handle if an instance is found.
    If nFHandle = 0 Then
        
        'set return to true...no found
        nCheckUnique = True

    Else
        'found it...bring it to the top
        nX = ShowWindow(nFHandle, 1)

        'set the focus on the previous instance
        nX = SFocus(nFHandle)

        'set return to false...found
        nCheckUnique = False

    End If

End Function

