'**********************************************************************
'*
'*   NAME
'*      GetHelp.bas
'*
'*   DESCRIPTION
'*      Combs through all the forms in the directory and produces a
'*      file that has all the context sensitive help fields listed
'*      (for easy reference).
'*      This assumes one project per directory, of course.
'*
'*   INPUT
'*      All the *.frm files in the current directory.
'*
'*   OUTPUT
'*      HelpID.Txt - A list of all form controls with a help id.
'*      HelpID.H   - The help id's in a format suitable for #including
'*                   in the help project file.
'*
'*   HISTORY
'*      08-02-93 JL Created.
'*
'*      Copyright (c) 1993 Graceland Research.  All Rights Reserved.
'**********************************************************************

DEFINT A-Z

DECLARE FUNCTION FCount(Spec$)
DECLARE FUNCTION FUsing$ (work$, image$)
DECLARE FUNCTION NULL (work$)

CONST TRUE  = -1
CONST FALSE = 0

' read the files on the disk

spec$ = "*.FRM"

' find out how many files there are

count = FCount(Spec$)

DIM ARRAY$(0 TO Count)

' pad the array with spaces

FOR idx = 1 TO count

    array$(idx) = space$(12)

NEXT idx

' get the list of file names

array$(0) = Spec$

CALL ReadFile(BYVAL VARPTR(Array$(0)))

' alphabetize them

IF count > 1 THEN

	DO

        sw = 0

		FOR idx = 1 TO count - 1

			IF array$(idx) > array$(idx + 1) THEN
				SWAP array$(idx), array$(idx + 1)

                sw = 1

			END IF

		NEXT idx

	LOOP UNTIL sw = 0

END IF

CLS

numlines& = 0
lastid = 0

OPEN "O", 2, "helpid.txt"
OPEN "O", 3, "helpid.h"

FOR idx = 1 TO count

    locate 1,1,0: print "Processing File " + Array$(idx)

	indent = 0
	formtype = 0
	addblank = FALSE
    formname$ = "(Unknown)!"
    controltype$ = ""
	controlname$ = ""
    helpid = 0

	OPEN "I", 1, Array$(idx)

	LINE INPUT #1, a$

	' make sure we can id the file
	IF LEFT$(a$, 7) <> "VERSION" THEN
		print #2, array$(idx) + " is not saved as text"
		print #2, ""
	ELSE
		numlines& = numlines& + 1

		' parse the form information
        DO UNTIL EOF(1)

			LINE INPUT #1, a$

			numlines& = numlines& + 1

            IF LTRIM$(RTRIM$(a$)) = "End" THEN
                indent = indent - 1

                ' if the form information is over, then exit
                IF indent <= 0 THEN
                    EXIT DO
                END IF
            END IF

            formtype = 0

            x = INSTR(a$, "Begin")

			IF x THEN
                ' bump our indent counter
                indent = indent + 1

                ' "Begin" is 5 characters wide, so start right after it
                start = x + 6

                ' look for the form name, control name, whatever
                x = INSTR(start, a$, " ")

                IF x THEN
                    controltype$ = MID$(a$, start, x - start)
                    controlname$ = RTRIM$(MID$(a$, x + 1))

                    IF controltype$ = "MDIForm" THEN
                        formtype = 2
                    ELSEIF controltype$ = "Form" THEN
                        formtype = 1
                    END IF

                    ' this is a new form, so put it's name in the file list
                    IF formtype THEN
                        formname$ = controlname$
                        controlname$ = ""
                        print #2, "File: " + LCASE$(array$(idx)) + "    Form: " + formname$
                    END IF
                END IF
			END IF

            ' look for the controls with a help context id
            x = INSTR(a$, "HelpContextID")

			IF x THEN

                ' find out what the id is
                start = x + 1

				x = INSTR(start, a$, "=")

				IF x THEN
                    helpid = VAL(LTRIM$(RTRIM$(MID$(a$, x + 2))))
				ELSE
                    helpid = 0
				END IF

                ' keep track of what the greatest helpid used in the file is
                IF helpid > lastid THEN
                    lastid = helpid
                END IF

                ' pad the name so things line up better
                IF LEN(controltype$) < 8 THEN
                    pad$ = SPACE$(8 - LEN(controltype$))
                ELSE
                    pad$ = ""
                END IF

                ' generate the name part of the line
                helpline$ = "    (" + controltype$ + ") " + pad$ + controlname$

                IF LEN(helpline$) < 33 THEN
                    helpline$ = helpline$ + SPACE$(33 - LEN(helpline$))
                END IF

                print #2, helpline$ + "=" + FUSING$(STR$(helpid), "####")

                ' generate the #include for the helpid.h file
                IF NULL(controlname$) THEN
                    define$ = "id_" + formname$
                ELSE
                    define$ = "id_" + formname$ + "_" + controlname$
                END IF

                IF LEN(define$) < 29 THEN
                    define$ = define$ + SPACE$(29 - LEN(define$))
                END IF

                print #3, "#define " + define$ + FUSING$(STR$(helpid), "####")

                addblank = TRUE

			END IF

			' a keystroke will abort the process
			IF len(inkey$) THEN
				CLOSE
				END
			END IF

		LOOP

		IF addblank THEN
			print #2, ""
		END IF
	END IF

	CLOSE #1

NEXT idx

' put the last id used at the end of the file
print #2, STRING$(38, "-")
print #2, "Last ID is" + STR$(lastid)
print #2, STRING$(38, "-")
print #2, ""

CLOSE

' print out summary information to the screen
print
print "Processed" + STR$(numlines&)+" lines in" + STR$(count) + " files."
print "HelpID.Txt, HelpID.H written. Last ID used was" + STR$(lastid)
print

END


