' DemoCt3D.Bas - Routines used with DemoCt3D.Mak
' 94/10/27 Copyright 1994, Larry Rebich, The Bridge, Inc.
    Option Explicit
    DefInt A-Z
    Type OfStruct
        cBytes As String * 1
        fFixedDisk As String * 1
        nErrCode As Integer
        Reserved As String * 4
        szPathName As String * 128
    End Type

    Declare Function OpenFile Lib "Kernel" (ByVal lpFileName As String, lpReOpenBuff As OfStruct, ByVal wStyle As Integer) As Integer

    Global Const OF_EXIST = &H4000      'used to get date time last updated

Sub GetFileFullNameAndDateTime (FileName As String, FileFullName As String, FileDateAndTime As Double)
    Const HFile_Error = -1      'error
    Dim R As OfStruct           'variable as this type
    Dim r1 As String * 1        'Reserved word
    Dim r2 As String * 1
    Dim r3 As String * 1
    Dim r4 As String * 1
    Dim Fe
    Dim Da, Mo, Yr
    Dim Hr, Mi, Se
    Dim Temp As Long
    Dim TempString As String    'full file name in here
    Fe = OpenFile(FileName, R, OF_EXIST)        'API call, open then close
    If Fe <> HFile_Error Then
        r1 = Mid$(R.Reserved, 1, 1)             'reserved first byte
        r2 = Mid$(R.Reserved, 2, 1)             'reserved second byte
        r3 = Mid$(R.Reserved, 3, 1)             'reserved third byte
        r4 = Mid$(R.Reserved, 4, 1)             'reserved fourth byte
        Temp& = Asc(r2) * 256& + Asc(r1)
        Da = (Temp& And &H1F)                   'day
        Mo = (Temp& And &H1E0) \ &H20           'month
        Yr = (Temp& And &HFE00) \ &H200 + 1980  'year
        Temp& = Asc(r4) * 256& + Asc(r3)
        Se = (Temp& And &H1F) * 2               'second
        Mi = (Temp& And &H7E0) \ &H20           'minute
        Hr = (Temp& And &HF800) \ &H800         'hour
        FileDateAndTime = DateSerial(Yr, Mo, Da) + TimeSerial(Hr, Mi, Se)
        TempString = RTrim$(R.szPathName)       'get file name
        If InStr(TempString, Chr$(0)) > 0 Then  'dump ending null
            TempString = Left$(TempString, InStr(TempString, Chr$(0)) - 1)
        End If
        FileFullName = TempString
    Else
        FileDateAndTime = 0
        FileFullName = ""
    End If
End Sub

