VERSION 2.00
Begin Form MainForm 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Free System Resources"
   ClientHeight    =   2865
   ClientLeft      =   1680
   ClientTop       =   1770
   ClientWidth     =   5115
   Height          =   3270
   Icon            =   FSR.FRX:0000
   Left            =   1620
   LinkTopic       =   "Form1"
   ScaleHeight     =   2865
   ScaleWidth      =   5115
   Top             =   1425
   Width           =   5235
   Begin CommandButton Command1 
      Caption         =   "Update"
      Height          =   375
      Left            =   1920
      TabIndex        =   14
      Top             =   2400
      Width           =   1215
   End
   Begin CheckBox Check1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Enabled"
      Height          =   255
      Left            =   360
      TabIndex        =   13
      Top             =   480
      Width           =   1335
   End
   Begin CheckBox Check2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "AutoWarn"
      Height          =   255
      Left            =   1920
      TabIndex        =   12
      Top             =   480
      Width           =   1335
   End
   Begin CheckBox Check3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Compact"
      Height          =   255
      Left            =   3360
      TabIndex        =   11
      Top             =   480
      Width           =   1455
   End
   Begin TextBox Threshold 
      BackColor       =   &H00C0C0C0&
      Height          =   285
      Index           =   2
      Left            =   3720
      TabIndex        =   9
      Top             =   1800
      Width           =   615
   End
   Begin TextBox Threshold 
      BackColor       =   &H00C0C0C0&
      Height          =   285
      Index           =   1
      Left            =   2160
      TabIndex        =   8
      Top             =   1800
      Width           =   615
   End
   Begin SpinButton Spin1 
      Delay           =   125
      Height          =   285
      Index           =   2
      Left            =   4320
      Top             =   1800
      Width           =   255
   End
   Begin SpinButton Spin1 
      Delay           =   125
      Height          =   285
      Index           =   1
      Left            =   2760
      Top             =   1800
      Width           =   255
   End
   Begin SpinButton Spin1 
      Delay           =   125
      Height          =   285
      Index           =   0
      Left            =   1200
      Top             =   1800
      Width           =   255
   End
   Begin TextBox Threshold 
      BackColor       =   &H00C0C0C0&
      Height          =   285
      Index           =   0
      Left            =   600
      TabIndex        =   7
      Top             =   1800
      Width           =   615
   End
   Begin Monitor Monitor1 
      AutoWarn        =   0   'False
      Compact         =   0   'False
      Enabled         =   -1  'True
      GDIThreshold    =   0
      Interval        =   0
      Left            =   1080
      MemoryThreshold =   0
      TabIndex        =   3
      Top             =   2280
      UserThreshold   =   0
   End
   Begin Gauge Gauge3 
      Autosize        =   -1  'True
      Height          =   660
      InnerBottom     =   5
      InnerLeft       =   2
      InnerRight      =   5
      InnerTop        =   10
      Left            =   3480
      Max             =   100
      NeedleWidth     =   1
      Picture         =   FSR.FRX:0302
      Style           =   2  ''Semi' Needle
      TabIndex        =   2
      Top             =   840
      Width           =   1305
   End
   Begin Gauge Gauge2 
      Autosize        =   -1  'True
      Height          =   660
      InnerBottom     =   5
      InnerLeft       =   2
      InnerRight      =   5
      InnerTop        =   10
      Left            =   1920
      Max             =   100
      NeedleWidth     =   1
      Picture         =   FSR.FRX:0B0C
      Style           =   2  ''Semi' Needle
      TabIndex        =   1
      Top             =   840
      Width           =   1305
   End
   Begin Gauge Gauge1 
      Autosize        =   -1  'True
      BackColor       =   &H00FFFFFF&
      ForeColor       =   &H00FFFFFF&
      Height          =   660
      InnerBottom     =   5
      InnerLeft       =   2
      InnerRight      =   5
      InnerTop        =   10
      Left            =   360
      Max             =   100
      NeedleWidth     =   1
      Picture         =   FSR.FRX:1316
      Style           =   2  ''Semi' Needle
      TabIndex        =   0
      Top             =   840
      Width           =   1305
   End
   Begin Label Title1 
      BackStyle       =   0  'Transparent
      Caption         =   "Microsoft Windows"
      Height          =   255
      Left            =   240
      TabIndex        =   10
      Top             =   120
      Width           =   4575
   End
   Begin Label Label3 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "0%"
      Height          =   255
      Left            =   3480
      TabIndex        =   4
      Top             =   1560
      Width           =   1335
   End
   Begin Label Label2 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "0%"
      Height          =   255
      Left            =   1920
      TabIndex        =   5
      Top             =   1560
      Width           =   1335
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "0%"
      Height          =   255
      Left            =   360
      TabIndex        =   6
      Top             =   1560
      Width           =   1335
   End
End

Sub Check1_Click ()
    Monitor1.Enabled = Check1.Value
End Sub

Sub Check2_Click ()
    Monitor1.AutoWarn = Check2.Value
End Sub

Sub Check3_Click ()
    Monitor1.Compact = Check3.Value
End Sub

Sub Command1_Click ()
    UpdateGauges
End Sub

Sub Form_Load ()
    Dim I As Integer

    '
    ' Clear the default thresholds
    '
    For I = 0 To 2
        SetThreshold I, 0
    Next I
    
    Title1.Caption = "Microsoft Windows " & Monitor1.WindowsVersion
    If Monitor1.SystemCPU > 286 Then
        Title1.Caption = Title1.Caption & " (386 Enhanced Mode)"
    End If
    
    Check1.Value = 1
    Check2.Value = 0
    Check3.Value = 0

    '
    ' Check available resources every second
    '
    Monitor1.Interval = 1000
    Monitor1.Enabled = True
    
    '
    ' Update the gauge display
    '
    UpdateGauges
End Sub

Sub Monitor1_Timer ()
    UpdateGauges
End Sub

Sub Monitor1_Warning (Resource As Integer, Percent As Integer)
    MsgBox "Resource " & Resource & " at " & Percent & "%"
End Sub

Sub SetThreshold (Index As Integer, Value As Integer)
    Threshold(Index).Text = Str(Value)
    Threshold(Index).SelStart = 0
    Threshold(Index).SelLength = Len(Threshold(Index).Text)
    
    Select Case Index
    Case 0
        Monitor1.MemoryThreshold = Value
    Case 1
        Monitor1.GDIThreshold = Value
    Case 2
        Monitor1.UserThreshold = Value
    End Select
End Sub

Sub Spin1_SpinDown (Index As Integer)
    Dim Value As Integer

    Value = Val(Threshold(Index).Text)
    If Value < 1 Then
        Beep
    Else
        SetThreshold Index, Value - 1
    End If
End Sub

Sub Spin1_SpinUp (Index As Integer)
    Dim Value As Integer

    Value = Val(Threshold(Index).Text)
    If Value > 99 Then
        Beep
    Else
        SetThreshold Index, Value + 1
    End If
End Sub

Sub Threshold_GotFocus (Index As Integer)
    Threshold(Index).SelStart = 0
    Threshold(Index).SelLength = Len(Threshold(Index).Text)
End Sub

Sub Threshold_LostFocus (Index As Integer)
    SetThreshold Index, Val(Threshold(Index).Text)
End Sub

Sub UpdateGauges ()
    Gauge1.Value = Monitor1.MemoryFree
    Label1.Caption = "Memory - " & Gauge1.Value & "%"
    Gauge2.Value = Monitor1.GDIHeapFree
    Label2.Caption = "GDI - " & Gauge2.Value & "%"
    Gauge3.Value = Monitor1.UserHeapFree
    Label3.Caption = "User - " & Gauge3.Value & "%"
End Sub

