'   This is an idea I stole from CorelDraw.  The spin button
' starts slow, then speeds up.  (You can set the speeds by
' changing constants, below.)

'   It also has an alternate mode:
' pushing the middle segment of the button then dragging
' the mouse up or down is like an invisible thumbwheel on
' a scroll bar.

'   Right clicks spin by tens instead of by ones. This can be
' changed to other values if you wish (see constants below)

'   To create an enhanced spin button, you need to load
' FrmESpin at startup (Sub Main or Form_Load).  Then just
' place an image control on your form, size it and give it a
' border, set the picture property to SPINP0.BMP, and put
' subroutine calls in its MouseDown, MouseUp, and MouseMove
' events.  Not quite as easy as a VBX, but not bad.

Option Explicit

Global SpinDir As Integer  'mag and direction of spin jump
Global SpinDest As Control 'the e.g. textbox to spin
Global SpinBut As Image    'the image control used as spin button
Global MousePos As Integer 'where the last mousemove was on SpinBut
Global OldMousePos As Integer 'the previous one

Global TwipsY As Integer    'holds TwipsY
Global TimerCount As Integer 'for changing speed
Global Jump As Integer

Global Const INITDELAY = 150   'start slow
Global Const OTHDELAY = 20     'speed up
Global Const CHANGEDELAY = 7   'after seven slow ones
Global Const LEFTSPIN = 1      'jump 1 for left mouse
Global Const RIGHTSPIN = 10    'jump by 10 for right mouse

Sub JDMouseDown (Button As Integer, Y As Single, Img As Image, Txt As Control)
  Dim hgt As Integer

' jump 1 for left, 10 for right button pressed (see constants)
  If Button = 1 Then
    Jump = LEFTSPIN
  ElseIf Button = 2 Then
    Jump = RIGHTSPIN
  End If
' set timer interval to slow
  FrmESpin.Timer1.Interval = INITDELAY
' set the picture to make it look pressed
  hgt = Img.Height
  If Y < hgt / 3 Then
  ' pressed up button
    Img.Picture = FrmESpin.Image2(1).Picture
    SpinDir = Jump          'spin up
  ElseIf Y > hgt * 2 / 3 Then
  ' pressed down button
    Img.Picture = FrmESpin.Image2(3).Picture
    SpinDir = -1 * Jump       'spin down
  Else
  ' using invisible thumbwheel
    Img.Picture = FrmESpin.Image2(2).Picture
    SpinDir = 0          'spin with the mouse
    MousePos = Y / TwipsY
    OldMousePos = MousePos  'mouse hasn't moved since the button was pressed
    FrmESpin.Timer1.Interval = 25  'a good value for mousemoves
  End If
' set globals, so routines know who's spinning who
  Set SpinDest = Txt
  Set SpinBut = Img
' spin the e.g. textbox
  SpinIt       '1st spin
  TimerCount = 0
  FrmESpin.Timer1.Enabled = True  'subsequent spins

End Sub

Sub JDMouseMove (Y As Single, Img As Image, Button As Integer)
  Dim hgt As Integer
' bail if a mouse button is down
  If Button Then
  ' just store the mouse position
    OldMousePos = MousePos
    MousePos = Y / TwipsY
    Exit Sub
  End If
' change the mousepointer if on center button
  hgt = Img.Height
  If Y < hgt / 3 Then
    Img.MousePointer = 0
  ElseIf Y > hgt * 2 / 3 Then
    Img.MousePointer = 0
  Else
    Img.MousePointer = 7
  End If

End Sub

Sub JDMouseUp ()
' stop spinning
  FrmESpin.Timer1.Enabled = False
  If SpinBut Is Nothing Then Exit Sub
' set button back to unpressed picture
  SpinBut.Picture = FrmESpin.Image2(0).Picture
' set back to ready to do another
  Set SpinDest = Nothing
  Set SpinBut = Nothing
  MousePos = 0
  OldMousePos = 0
  TimerCount = 0
  FrmESpin.Timer1.Interval = INITDELAY

End Sub

Sub SpinIt ()
  Dim tmp As Single

' get the current value of the e.g. textbox
  tmp = Val(SpinDest)
  If SpinDir Then
  ' spin up or down
    tmp = tmp + SpinDir '+1 or -1 or etc.
    SpinDest = Trim$(Str$(tmp))
  Else
  ' spin with the mouse
    tmp = tmp + (OldMousePos - MousePos) * Jump
    SpinDest = Trim$(Str$(tmp))
    OldMousePos = MousePos
  End If
' increment count
  TimerCount = TimerCount + 1
' speed up if it's time to
  If TimerCount > CHANGEDELAY Then FrmESpin.Timer1.Interval = OTHDELAY
  
End Sub

