Program TPDemo1;
uses WinCrt;

Procedure DXFOpen(FileName:PChar); far; external 'TURBODXF' index 1;
Procedure DXFHeader(X1,Y1,X2,Y2:double); far; external 'TURBODXF' index 2;
Procedure DXFStartTables(NumLayers : integer); far; external 'TURBODXF' index 3;
Procedure DXFAddLayer(LayerName : PChar; LayerColor : integer); far; external 'TURBODXF' index 4;
Procedure DXFStartViewTable(NumViews:integer); far; external 'TURBODXF' index 5;
Procedure DXFAddView(ViewName: PChar;
			Height,Width,CentreX,CentreY : double);far; external 'TURBODXF' index 6;
Procedure DXFEndTables; far; external 'TURBODXF' index 7;
Procedure DXFAddText10(X1,Y1,Z1,Height,Rotate : double; Txt,LayerName : PChar); far; external 'TURBODXF'index 9;
Procedure DXFAddPoint(X1,Y1,Z1 : double; Layer : PChar); far; external 'TURBODXF' index 10;
Procedure DXFAddArc( X1,Y1,Z1,Radius,StartAngle,EndAngle : double;Layer : PChar); far; external 'TURBODXF' index 11;
Procedure DXFAddSolid( X1,Y1,Z1,
                       X2,Y2,Z2,
                       X3,Y3,Z3,
                       X4,Y4,Z4 : double;
                       Layer : PChar);far; external 'TURBODXF' index 12;

Procedure DXFAddLine(X1,Y1,Z1,X2,Y2,Z2: double;LayerName : PChar); far; external 'TURBODXF' index 13;

Procedure DXFAddPoly(Layer : PChar);far; external 'TURBODXF' index 14;

Procedure DXFAddVertex( X1, Y1, Z1, StartWidth, EndWidth : double;
                        Layer : PChar);far; external 'TURBODXF' index 15;

Procedure DXFEndPoly; far; external 'TURBODXF' index 16;

procedure DXFAdd3DFace(X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,X4,Y4,Z4:double;
           Layer:PChar);far; external 'TURBODXF' index 17;

Procedure DXFAddCircle(X1,Y1,Z1,Radius,Extrusion:double; LayerName:PChar); far; external 'TURBODXF' index 18;

Procedure DXFClose; far; external 'TURBODXF' index 19;

Procedure DXFAddBar(X1,Y1,Width,Height:double; Layer:PChar);far; external 'TURBODXF' index 20;

Procedure DXFAddXAxis(X1,Y1,X2:double;NumTicks:integer;Layer:PChar);far; external 'TURBODXF' index 21;

Procedure DXFAddYAxis(X1,Y1,Y2:double;NumTicks:integer;Layer:PChar);far; external 'TURBODXF' index 22;
{=========================================================================================}

var
  i : integer;
  DXFFileName : PChar;

begin
  DXFFileName := 'TPDEMO1.DXF';
  Writeln('Testing TURBODXF DLL. Creating DXF file: ',DXFFileName);
  DXFOpen(DXFFileName);

  DXFHeader(1,1,10,10);

  DXFStartTables(5);

  DXFADDLayer('LINES',1);
  DXFADDLayer('TEXT',7);
  DXFADDLayer('ARC',1);
  DXFADDLayer('SOLID',5);
  DXFADDLayer('POLY',7);

  DXFStartViewTable(0);

  DXFEndTables;

  DXFAddBar(-2,-2,15,16,'POLY');

  for I := 1 to 5 do
  	DXFAddBar(I*2,1,1,I*2,'SOLID');

  for I := 1 to 5 do
  	DXFAddBar(I*2-1,1,1,I*2-1,'LINES');

  DXFAddPoly('POLY');
   DXFAddVertex(3,1,0,0.5,0.25,'POLY');
   DXFAddVertex(4,3,0,0.35,0.5,'POLY');
   DXFAddVertex(5,3,0,0.75,0.15,'POLY');
   DXFAddVertex(7,5,0,0.25,0.25,'POLY');
  DXFEndPoly;

  DXFAddLine(0,0.5,0,10,0.5,0,'LINES');

  DXFAddLine(0,0.5,0,0,8,0,'LINES');

  DXFAddText10(2,12,0,0.5,0,'TurboDXF! from Ideal','TEXT');

  DXFAddCircle(3,3,0,2,0,'ARC');

  for I := 1 to 8 do
    DXFAddText10(3,7,0,0.25,I*45,'TurboDXF!','TEXT');

  DXFAddArc(6,5,0,5,-10,110,'ARC');

  DXFAddSolid(7.5,1,0,9.5,1,0,9.5,6,0,7.5,3,0,'TEXT');

  DXFAddXAxis(0,0,10,10,'TEXT');

  DXFAddYAxis(0,0,10,10,'TEXT');

  DXFClose;

  Writeln('Test Complete. DXF file closed.');
  writeln('Use Corel Draw, Micrografx Designer etc to view.');

end.

