VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Demo CTL3DV2.DLL"
   ClientHeight    =   3495
   ClientLeft      =   900
   ClientTop       =   1635
   ClientWidth     =   8220
   ControlBox      =   0   'False
   Height          =   3900
   Icon            =   DEMOCT3D.FRX:0000
   Left            =   840
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3495
   ScaleWidth      =   8220
   Top             =   1290
   Width           =   8340
   Begin OptionButton Option1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "3D Effects &Off"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   1
      Left            =   4560
      TabIndex        =   6
      Top             =   120
      Width           =   1800
   End
   Begin OptionButton Option1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "3&D Effects On"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   0
      Left            =   2160
      TabIndex        =   5
      Top             =   120
      Value           =   -1  'True
      Width           =   1800
   End
   Begin CommonDialog CMDialog1 
      Left            =   7080
      Top             =   0
   End
   Begin CommandButton Command1 
      Caption         =   "&Help"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   495
      Index           =   3
      Left            =   120
      TabIndex        =   4
      Top             =   2280
      Width           =   7935
   End
   Begin CommandButton Command1 
      Caption         =   "&Common Dialog"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   495
      Index           =   2
      Left            =   120
      TabIndex        =   2
      Top             =   1680
      Width           =   7935
   End
   Begin CommandButton Command1 
      Cancel          =   -1  'True
      Caption         =   "E&xit"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   495
      Index           =   4
      Left            =   120
      TabIndex        =   3
      Top             =   2880
      Width           =   7935
   End
   Begin CommandButton Command1 
      Caption         =   "&Input Box"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   495
      Index           =   1
      Left            =   120
      TabIndex        =   1
      Top             =   1080
      Width           =   7935
   End
   Begin CommandButton Command1 
      Caption         =   "&Message Box"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   495
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   480
      Width           =   7935
   End
End
' DemoCt3D.Frm - Demo calling Ctl3D.DLL/Ctl3DV2.DLL
' 94/08/06 Copyright 1994, Larry Rebich, The Bridge, Inc., CIS 71662,205
' 94/10/27 Clean-up and Bug in Determining if Ctl3Dv2.Dll on user's system
' 95/03/26 Use Ctl3D.DLL is Ctl3DV2 not found

    Option Explicit
    DefInt A-Z

' Command Indexes
    Const IndexMsgBox = 0
    Const IndexInputBox = 1
    Const IndexCMDialog = 2
    Const IndexHelp = 3
    Const IndexExit = 4

' Toggle 3D Effect
    Dim Is3DOn As Integer   'True if 3D on

' Option Buttons
    Const IndexOption3DOn = 0
    Const IndexOption3DOff = 1

Sub Command1_Click (Index As Integer)
    ' process samples
    Select Case Index
        Case IndexMsgBox
            MsgBox "Sample Message", 32, "The Title"
        Case IndexInputBox
            Dim Inpt As String
            Inpt = InputBox("Sample Message:", "The Title", "Default Value")
        Case IndexCMDialog
            DoCmDialog
        Case IndexHelp
            DoHelpMessage           'some info
        Case IndexExit
            Unload Me               'bye and unregister if needed
    End Select
End Sub

Sub DoApp3D (Action)
' Toggle 3D Effect based upon the Action setting
    Const SetCap = "&Set 3D "
    Const SetOff = "Off"
    Const SetOn = "On"
    Const s3D = "3D &"
    Const sStd = "Std &"
    Const sMsg = "Message"
    Const sInputBox = "InputBox"
    Const sCommonDialog = "Command Dialog"
    Const sHelpMessage = "Help Message"

    If Action Then          'true
        Ctl3D_Start         'start 3D effect
        Is3DOn = True
        Command1(IndexMsgBox).Caption = s3D & sMsg
        Command1(IndexInputBox).Caption = s3D & sInputBox
        Command1(IndexCMDialog).Caption = s3D & sCommonDialog
        Command1(IndexHelp).Caption = s3D & sHelpMessage
        BackColor = RGB(192, 192, 192)
    Else                    'false
        Ctl3D_End           'end 3D effect
        Is3DOn = False      'set switch
        Command1(IndexMsgBox).Caption = sStd & sMsg
        Command1(IndexInputBox).Caption = sStd & sInputBox
        Command1(IndexCMDialog).Caption = sStd & sCommonDialog
        Command1(IndexHelp).Caption = sStd & sHelpMessage
        BackColor = RGB(255, 255, 255)
    End If
    Option1(0).BackColor = BackColor
    Option1(1).BackColor = BackColor
End Sub

Sub DoCmDialog ()
' Common File Open Dialog that does nothing
    Dim Fltr As String                  'temporary filter
    CmDialog1.DialogTitle = "Does Absolutely Nothing"
    CmDialog1.Filename = "ctl3d.bas"
    Fltr = "All (*.*)|*.*|Text (*.txt)|*.txt|"
    Fltr = Fltr & "Forms (*.frm)|*.frm|"
    Fltr = Fltr & "VB Projects (*.mak)|*.mak"
    CmDialog1.Filter = Fltr             'file filter
    CmDialog1.InitDir = App.Path        'initial path
    CmDialog1.Action = 1    'open
End Sub

Sub DoEndingMessage ()
' Add warning message that Ctl3DV2.DLL not Installed
    Dim Msg As String
    Dim Ttl As String
    Dim Cr As String
    Cr = Chr$(13)
    Msg = "Ctl3DV2.DLL was not found on your system." & Cr
    Msg = Msg & "Unable to demonstrate 3D effects without it." & Cr
    Msg = Msg & "Contact the author [71662,205] if you have " & Cr
    Msg = Msg & "trouble finding this DLL." & Cr & Cr
    Msg = Msg & "Will End Now."
    Ttl = "Ctl3DV2.DLL not Found"
    MsgBox Msg, 16, Ttl
    End
End Sub

Sub DoHelpMessage ()
    Dim Msg As String       'Message
    Dim Ttl As String       'Title
    Dim Cr As String * 1    'Carriage return
    Cr = Chr$(13)
    Msg = "This simple application demonstrates using Ctl3D.DLL or Ctl3DV2.DLL. "
    Msg = Msg & "Ctl3DV2.DLL is used if found. Then Ctl3D.DLL. "
    Msg = Msg & "The version used is shown in the form's caption." & Cr & Cr
    Msg = Msg & "Click the option buttons to turn on or off "
    Msg = Msg & "3D effects. "
    Msg = Msg & Cr & Cr
    Msg = Msg & "Click the Message, Input Box, or Common Dialog command "
    Msg = Msg & "to see standard or 3D effects. "
    Msg = Msg & Cr & Cr
    Msg = Msg & "This demo is based upon work done by an unidentified author, CIS: 74047,2155." & Cr
    Msg = Msg & "The demo was created on August 6, 1994"
    Msg = Msg & " and updated on October 28,1994, "
    Msg = Msg & "and March 26, 1995 "
    Msg = Msg & "by Larry Rebich, CIS: 71662,205."
    Ttl = "Demo Ctl3D Information"
    MsgBox Msg, 64, Ttl
End Sub

Sub Form_Load ()
    If DoesCtl3DEitherExist() Then  'test for existance of Ctl3Dv2.Dll
        DoApp3D True                'set 3D effect on
    Else
        DoEndingMessage
    End If
    'setup the forms
    SetupForm
    'center the form
    Move (Screen.Width - Width) \ 2, (Screen.Height - Height) \ 2
    DoHelpMessage
End Sub

Sub Form_Unload (Cancel As Integer)
    ' Warning, Be Sure to end this with the Exit Button
    ' or the Control Box, Close Menu Item or by using Alt-F4
    If Is3DOn Then      'if 3D Effect on then turn it off
        Ctl3D_End       'if not done then a GPF can occur
    End If
End Sub

Sub Option1_Click (Index As Integer)
    If Index = IndexOption3DOn Then
        DoApp3D True
    Else
        DoApp3D False
    End If
End Sub

Sub SetupForm ()
    Dim i As Integer
    Dim a As String
    Dim c31h As Integer, c31l As Integer    'version numbers saved here
    Dim c32h As Integer, c32l As Integer
    Dim c31 As Single
    Dim c32 As Single
    WordToTwoIntegers VerV1, c31h, c31l     'get version numbers
    WordToTwoIntegers VerV2, c32h, c32l
    c31 = Val(Hex$(c31h)) + Val(Hex$(c31l)) / 100
    c32 = Val(Hex$(c32h)) + Val(Hex$(c32l)) / 100
    Const mm = "#0.00"
    For i = IndexExit To IndexMsgBox Step -1
        Command1(i).TabIndex = 0
    Next
    Dim ff As String, fd As Double
    If DoesCtl3DExist(FileNameCtl3DV2) Then
        GetFileFullNameAndDateTime FileNameCtl3DV2, ff, fd
        a = Format$(c32, mm)
    Else
        GetFileFullNameAndDateTime FileNameCtl3DV1, ff, fd
        a = Format$(c31, mm)
    End If
    Caption = "Using " & LCase$(ff) & ", " & a & ", " & Format$(fd, "ddddd, ttttt")
End Sub

Sub WordToTwoIntegers (TheWord As Integer, TheIntHigh As Integer, TheIntLow As Integer)
    TheIntHigh = TheWord \ 256
    TheIntLow = TheWord - (256 * TheIntHigh)
End Sub

