Option Explicit

'*********************************************************
'   Misc. flags and data areas.
'*********************************************************
Global DDESHRD_Loaded As Integer
Global rc As Integer

'*********************************************************
'   NDDE Access Flags.
'*********************************************************
Global Const NDDEACCESS_REQUEST = 1
Global Const NDDEACCESS_ADVISE = 2
Global Const NDDEACCESS_POKE = 4
Global Const NDDEACCESS_EXECUTE = 8
Global Const NDDEACCESS_START_APP = 16

'*********************************************************
'   NDDE Constants.
'*********************************************************
Global Const NDDE_NO_ERROR = 0
Global Const MAX_NDDESHARENAME = 64
Global Const MAX_PASSWORD = 15
Global Const MAX_APPNAME = 255
Global Const MAX_TOPICNAME = 255
Global Const MAX_ITEMNAME = 255

'*********************************************************
'   Passable ShareInfo structure.
'*********************************************************
Type PASSSHAREINFO
AppName             As String * 256    ' MAX_APPNAME+1
Topic               As String * 256    ' MAX_TOPICNAME+1
Item                As String * 256    ' MAX_ITEMNAME+1
Password1           As String * 15     ' MAX_PASSWORD
Permissions1        As Long
Password2           As String * 15     ' MAX_PASSWORD
Permissions2        As Long
End Type

'*********************************************************
'   External functions.
'*********************************************************
Declare Function VBGetNodeName Lib "DDESH.dll" () As String
Declare Function VBShareDel Lib "DDESH.dll" (ByVal szShareName$) As Integer
Declare Function VBShareEnum Lib "DDESH.dll" (ByVal hWnd As Integer) As Integer
Declare Function VBShareGetInfo Lib "DDESH.dll" (ByVal szShareName As String, PShare As PASSSHAREINFO) As Integer
Declare Function VBShareUpdate Lib "DDESH.dll" (ByVal szShareName$, ByVal szAppName$, ByVal szTopName$, ByVal szItemName$, ByVal szPswd1$, ByVal szPswd2$, ByVal Perm1&, ByVal Perm2&) As Integer

Declare Function GetPrivateProfileString Lib "kernel" (ByVal szSection$, ByVal szEntry$, ByVal szDefault$, ByVal szReturnBuffer$, ByVal cbReturnBuffer%, ByVal lpszFilename$) As Integer
Declare Function WritePrivateProfileString Lib "kernel" (ByVal szSection$, ByVal szEntry$, ByVal szString$, ByVal szFilename$) As Integer

Sub DeleteShare (ByVal szShareName As String)
    Screen.MousePointer = 11
    rc = VBShareDel(szShareName)
    If rc <> NDDE_NO_ERROR Then
        MsgBox "Delete of share entry gave a return code of" + Str$(rc) + ".", 48, "DDEShare Error"
    Else
        DDESHRM!lblStatus.Caption = szShareName + " has been deleted."
        DDESHRM!ShareList.RemoveItem DDESHRM!ShareList.ListIndex
    End If
    Unload DDESHRD
    Screen.MousePointer = 0
End Sub

Function EditShare () As String
    Dim PShare As PASSSHAREINFO
    Dim i As Integer
    Dim AccAccum As Integer

    DDESHRD!txtShareName.Text = UCase$(Trim$(DDESHRD!txtShareName.Text))
    If DDESHRD!txtShareName.Text = "" Then
        EditShare = "A Share Name must be specified."
        DDESHRD!txtShareName.SetFocus
        Exit Function
    End If

    If Not DDESHRD!btnDelete.Enabled Then
        rc = VBShareGetInfo(DDESHRD!txtShareName.Text, PShare)
        If rc = NDDE_NO_ERROR Then
            EditShare = DDESHRD!txtShareName.Text + " already exists."
            DDESHRD!txtShareName.SetFocus
            Exit Function
        End If
    End If

    If DDESHRD!txtAppName.Text = "" Then
        EditShare = "An Application Name must be specified."
        DDESHRD!txtAppName.SetFocus
        Exit Function
    End If

    For i = 0 To 4
        AccAccum = AccAccum + DDESHRD!chkLvl1(i).Value + DDESHRD!chkLvl2(i).Value
    Next i
    If AccAccum = 0 Then
        EditShare = "No Authority has been granted on either access level."
        Exit Function
    End If

    DDESHRD!txtLvl1Pswd.Text = UCase$(DDESHRD!txtLvl1Pswd.Text)
    DDESHRD!txtLvl2Pswd.Text = UCase$(DDESHRD!txtLvl2Pswd.Text)
End Function

Sub ModifyShare (ByVal szShare As String)
    Dim PShare As PASSSHAREINFO
    Screen.MousePointer = 11
    rc = DoEvents()
    DDESHRM!lblStatus.Caption = ""
    If DDESHRD_Loaded Then Unload DDESHRD
    Load DDESHRD
    DDESHRD!txtShareName.Text = szShare
    If szShare <> " " Then
        DDESHRD!txtShareName.Enabled = False
        DDESHRD!btnDelete.Enabled = True
    Else
        DDESHRD!btnDelete.Enabled = False
    End If
    DDESHRD.Show
    If szShare <> " " Then
        rc = VBShareGetInfo(szShare, PShare)
        DDESHRD!chkLvl1(0).Value = Abs((PShare.Permissions1 And NDDEACCESS_REQUEST) <> 0)
        DDESHRD!chkLvl1(1).Value = Abs((PShare.Permissions1 And NDDEACCESS_ADVISE) <> 0)
        DDESHRD!chkLvl1(2).Value = Abs((PShare.Permissions1 And NDDEACCESS_POKE) <> 0)
        DDESHRD!chkLvl1(3).Value = Abs((PShare.Permissions1 And NDDEACCESS_EXECUTE) <> 0)
        DDESHRD!chkLvl1(4).Value = Abs((PShare.Permissions1 And NDDEACCESS_START_APP) <> 0)
        DDESHRD!chkLvl2(0).Value = Abs((PShare.Permissions2 And NDDEACCESS_REQUEST) <> 0)
        DDESHRD!chkLvl2(1).Value = Abs((PShare.Permissions2 And NDDEACCESS_ADVISE) <> 0)
        DDESHRD!chkLvl2(2).Value = Abs((PShare.Permissions2 And NDDEACCESS_POKE) <> 0)
        DDESHRD!chkLvl2(3).Value = Abs((PShare.Permissions2 And NDDEACCESS_EXECUTE) <> 0)
        DDESHRD!chkLvl2(4).Value = Abs((PShare.Permissions2 And NDDEACCESS_START_APP) <> 0)
        DDESHRD!txtLvl1Pswd.Text = Trim$(PShare.Password1)
        DDESHRD!txtLvl2Pswd.Text = Trim$(PShare.Password2)
        DDESHRD!txtAppName.Text = Trim$(PShare.AppName)
        DDESHRD!txtTopName.Text = Trim$(PShare.Topic)
        DDESHRD!txtItemName.Text = Trim$(PShare.Item)
        DDESHRD!txtAppName.SetFocus
    Else
        DDESHRD!txtShareName.SetFocus
    End If
    Screen.MousePointer = 0
End Sub

Sub SetAuthFocusMsg (AuthIndex As Integer, ByVal currValue As Integer)
    Dim AuthType As String
    Select Case AuthIndex
        Case 0
            AuthType = "execute a request."
        Case 1
            AuthType = "start an advise loop."
        Case 2
            AuthType = "poke data."
        Case 3
            AuthType = "issue executes."
        Case 4
            AuthType = "start the application on connect."
    End Select
    If currValue = 0 Then
        DDESHRD!lblStatus.Caption = "Do not allow the destination application to " + AuthType
    Else
        DDESHRD!lblStatus.Caption = "Allow the destination application to " + AuthType
    End If
End Sub

Sub UpdateShare ()
    Dim mbmsg As String
    Dim Perm1 As Long
    Dim Perm2 As Long
    Dim ProfStr As String
    Dim NewProfStr As String
    Screen.MousePointer = 11
    rc = DoEvents()
    If DDESHRD!txtTopName.Text = "" Then
        mbmsg = "A blank topic will cause connections to all topics to be honored." + Chr$(13) + Chr$(10)
        mbmsg = mbmsg + "This will work but is not documented or supported." + Chr$(13) + Chr$(10)
        mbmsg = mbmsg + "The updating will take place outside of normal NDDE protocol." + Chr$(13) + Chr$(10) + Chr$(13) + Chr$(10)
        mbmsg = mbmsg + "Do you want to proceed?"
        If MsgBox(mbmsg, 32 + 4, "") <> 6 Then
            Screen.MousePointer = 0
            Exit Sub
        End If
        DDESHRD!txtTopName.Text = "*"
    Else
        DDESHRD!txtTopName.Text = Trim$(DDESHRD!txtTopName.Text)
    End If
    DDESHRD!txtShareName.Text = Trim$(DDESHRD!txtShareName.Text)
    DDESHRD!txtAppName.Text = Trim$(DDESHRD!txtAppName.Text)
    DDESHRD!txtItemName.Text = Trim$(DDESHRD!txtItemName.Text)
    DDESHRD!txtLvl1Pswd.Text = Trim$(DDESHRD!txtLvl1Pswd.Text)
    DDESHRD!txtLvl2Pswd.Text = Trim$(DDESHRD!txtLvl2Pswd.Text)
    Perm1 = 0
    Perm2 = 0
    Perm1 = Perm1 + (DDESHRD!chkLvl1(0).Value * NDDEACCESS_REQUEST)
    Perm1 = Perm1 + (DDESHRD!chkLvl1(1).Value * NDDEACCESS_ADVISE)
    Perm1 = Perm1 + (DDESHRD!chkLvl1(2).Value * NDDEACCESS_POKE)
    Perm1 = Perm1 + (DDESHRD!chkLvl1(3).Value * NDDEACCESS_EXECUTE)
    Perm1 = Perm1 + (DDESHRD!chkLvl1(4).Value * NDDEACCESS_START_APP)
    Perm2 = Perm2 + (DDESHRD!chkLvl2(0).Value * NDDEACCESS_REQUEST)
    Perm2 = Perm2 + (DDESHRD!chkLvl2(1).Value * NDDEACCESS_ADVISE)
    Perm2 = Perm2 + (DDESHRD!chkLvl2(2).Value * NDDEACCESS_POKE)
    Perm2 = Perm2 + (DDESHRD!chkLvl2(3).Value * NDDEACCESS_EXECUTE)
    Perm2 = Perm2 + (DDESHRD!chkLvl2(4).Value * NDDEACCESS_START_APP)
    rc = VBShareUpdate(DDESHRD!txtShareName.Text, DDESHRD!txtAppName.Text, DDESHRD!txtTopName.Text, DDESHRD!txtItemName.Text, DDESHRD!txtLvl1Pswd.Text, DDESHRD!txtLvl2Pswd.Text, Perm1, Perm2)
    If rc <> NDDE_NO_ERROR Then
        MsgBox "Update of share entry gave a return code of" + Str$(rc) + ".", 48, "DDEShare Error"
    Else
        DDESHRM!lblStatus.Caption = Trim$(DDESHRD!txtShareName.Text) + " has been updated."
        If Not DDESHRD!btnDelete.Enabled Then DDESHRM!ShareList.AddItem DDESHRD!txtShareName.Text
        If DDESHRD!txtTopName.Text = "*" Then
            ProfStr = Space$(255)
            rc = GetPrivateProfileString("DDEShares", DDESHRD!txtShareName.Text, "-1", ProfStr, Len(ProfStr), "SYSTEM.INI")
            If rc < 1 Then
                Beep
                MsgBox "Failed to set topic to NULL."
                Exit Sub
            End If
            NewProfStr = Left$(ProfStr, InStr(ProfStr, ","))
            NewProfStr = NewProfStr + Mid$(ProfStr, Len(NewProfStr) + 2)
            rc = WritePrivateProfileString("DDEShares", DDESHRD!txtShareName.Text, NewProfStr, "SYSTEM.INI")
            If rc < 1 Then
                Beep
                MsgBox "Failed to set topic to NULL."
                Exit Sub
            End If
        End If
    End If
    Unload DDESHRD
    Screen.MousePointer = 0
End Sub

