//*************************************************************************
//	DDESH.DLL
//
//	DDEShare functions for Visual Basic.
//
//	Software Assist Corporation - 1992
//
//*************************************************************************
#include <windows.h>
#include <nddeapi.h>
#include <vbapi.h>
#include <string.h>

typedef struct PassShareInfo_tag
    {
    char			szAppName[MAX_APPNAME+1];
    char			szTopicName[MAX_TOPICNAME+1];
    char			szItemName[MAX_ITEMNAME+1];
    char		    	szPassword1[MAX_PASSWORD];
    DWORD                   	dwPermissions1;
    char		    	szPassword2[MAX_PASSWORD];
    DWORD                   	dwPermissions2;
    } PASSSHAREINFO, *PPASSSHAREINFO, FAR *LPPASSSHAREINFO;


//*************************************************************************
// 	LibMain -
//   		Standard DLL constructor.
//		Allocate local memory to store Global handles to
//		FileCon entries for each file.
//*************************************************************************

#pragma argsused
int FAR pascal LibMain(HANDLE hModule,
			WORD wDataSeg,
			WORD cbHeapSize,
			LPSTR lpszCmdLine)
{
    if (cbHeapSize > 0)
	UnlockData(0);		
    return (1);
}

//*************************************************************************
// 	WEP -                                                                 
//   		Standard DLL destructor.  Free up local memory and quit.            
//*************************************************************************
#pragma argsused
int FAR pascal WEP(int bSystemExit)
{
    return (1);
}

//************************************************************************
//	VBGetNodeName
//	Return a string containing the node name.
//*************************************************************************
HLSTR FAR pascal _export VBGetNodeName(void)
{
char	szNodeName[MAX_DOMAINNAME+1];

	if (NDdeGetNodeName(&szNodeName[0],MAX_DOMAINNAME+1)!=NDDE_NO_ERROR)
		return(VBCreateTempHlstr(NULL,NULL));
	return(VBCreateTempHlstr(&szNodeName[0],lstrlen(&szNodeName[0])));
}

//************************************************************************
//	VBShareDel
//	Delete a share name.
//*************************************************************************
int FAR pascal _export VBShareDel(LPSTR pszShareName)
{

	return(NDdeShareDel(NULL,pszShareName,NULL));
} 

//************************************************************************
//	VBShareEnum
//	Return a list of currently defined shares.
//*************************************************************************
int FAR pascal _export VBShareEnum(HANDLE hWnd)
{
HGLOBAL		hGbl;
LPBYTE		pBuff;
DWORD		nNames;
DWORD		nRemain;
DWORD		i;
int	       	rc;

	hGbl=GlobalAlloc(GHND,10000);
	if (hGbl==NULL)
		return(NDDE_OUT_OF_MEMORY);
	pBuff=GlobalLock(hGbl);

	rc=NDdeShareEnum(0,0,pBuff,10000,&nNames,&nRemain);
	for(i=1; i<=nNames; i++)
	{
		SendMessage(hWnd,LB_ADDSTRING,NULL,(LONG)(LPSTR)pBuff);
		pBuff=pBuff+lstrlen(pBuff)+1;
	}
	GlobalUnlock(hGbl);
	GlobalFree(hGbl);
	return(rc);
}

//************************************************************************
//	VBShareGetInfo
//     	Get information on an existing share entry.
//*************************************************************************
int FAR pascal _export VBShareGetInfo(LPSTR pszShareName,
				PPASSSHAREINFO pPShare)
{
NDDESHAREINFO		AShare;
HGLOBAL			hGbl;
LPBYTE			pBuff;
DWORD			nBuff;
int			rc;
DWORD			nBytes;
WORD			nItems;
LPBYTE			tChar;

	nBuff=sizeof(AShare)+(MAX_PASSWORD*2)+2
		+MAX_DOMAINNAME+1
		+MAX_APPNAME+1
		+MAX_TOPICNAME+1
		+MAX_ITEMNAME+1;
	hGbl=GlobalAlloc(GHND,nBuff);
	if (hGbl==NULL)
		return(NDDE_OUT_OF_MEMORY);
	pBuff=GlobalLock(hGbl);

	rc=NDdeShareGetInfo(NULL,pszShareName,2,
		(PNDDESHAREINFO)pBuff,nBuff,&nBytes,&nItems);
	if (rc!=NDDE_NO_ERROR)
        {
		GlobalUnlock(hGbl);
                GlobalFree(hGbl);
		return(rc);
	}
	hmemcpy(&AShare,pBuff,sizeof(AShare));
	_fmemset(pPShare->szPassword1,' ',MAX_PASSWORD);
        if (AShare.cbPassword1>0)
		hmemcpy(pPShare->szPassword1,AShare.lpbPassword1,AShare.cbPassword1);
	pPShare->dwPermissions1=AShare.dwPermissions1;
	_fmemset(pPShare->szPassword2,' ',MAX_PASSWORD);
        if (AShare.cbPassword2>0)
		hmemcpy(pPShare->szPassword2,AShare.lpbPassword2,AShare.cbPassword2);
	pPShare->dwPermissions2=AShare.dwPermissions2;
	_fmemset(pPShare->szAppName,' ',MAX_APPNAME+1);
	lstrcpy(pPShare->szAppName,AShare.lpszTargetApp);
	tChar=(LPBYTE)pPShare->szAppName+lstrlen(AShare.lpszTargetApp);
        *tChar=' ';
	_fmemset(pPShare->szTopicName,' ',MAX_TOPICNAME+1);
	lstrcpy(pPShare->szTopicName,AShare.lpszTargetTopic);
	tChar=(LPBYTE)pPShare->szTopicName+lstrlen(AShare.lpszTargetTopic);
	*tChar=' ';
	_fmemset(pPShare->szItemName,' ',MAX_ITEMNAME+1);
	lstrcpy(pPShare->szItemName,AShare.lpszItem);
	tChar=(LPBYTE)pPShare->szItemName+lstrlen(AShare.lpszItem);
	*tChar=' ';
	GlobalUnlock(hGbl);
	GlobalFree(hGbl);
	return(rc);
}

//************************************************************************
//	VBShareUpdate
//	Update a share entry.
//*************************************************************************
int FAR pascal _export VBShareUpdate(LPSTR pszShareName,
				LPSTR pszAppName,
				LPSTR pszTopName,
				LPSTR pszItemName,
				LPSTR pszPswd1,
				LPSTR pszPswd2,
				DWORD Perm1,
                                DWORD Perm2)
{
NDDESHAREINFO		AShare;

	NDdeShareDel(NULL,pszShareName,NULL);

	_fstrcpy(AShare.szShareName,pszShareName);
	AShare.lpszTargetApp=pszAppName;
	AShare.lpszTargetTopic=pszTopName;
	AShare.lpbPassword1=pszPswd1;
	AShare.cbPassword1=lstrlen(pszPswd1);
	AShare.lpbPassword2=pszPswd2;
	AShare.cbPassword2=lstrlen(pszPswd2);
	AShare.dwPermissions1=Perm1;
	AShare.dwPermissions2=Perm2;
	AShare.lpszItem=pszItemName;
	AShare.cAddItems=0;
        AShare.lpNDdeShareItemInfo=NULL;

	return(NDdeShareAdd(NULL,2,&AShare,sizeof(AShare)));
}