Option Explicit

Global PatchDB As Database, InputDB As Database
Global PatchDBName As String, InputDBName As String
Global PatchTable As Table, InputTable As Table
Global PatchDBOpen As Integer, InputDBOpen As Integer
Global PatchFields(0) As Field, InputFields(0) As Field
Global MSAccessPath As String, ProceedChoice As Integer

Global Const TABLE_OBJ = 0
Global Const QUERY_OBJ = 1
Global Const FORM_OBJ = 2
Global Const REPORT_OBJ = 3
Global Const MACRO_OBJ = 4
Global Const MODULE_OBJ = 5

Sub CloseInputDB ()
   On Error Resume Next
   'InputTable.Close
   'InputDB.Close
   MainForm.InputLink.LinkMode = LM_NONE
   InputDBOpen = False
   InputDBName = ""
   On Error GoTo 0
End Sub

Sub ClosePatchDB ()
   On Error Resume Next
   'PatchTable.Close
   'PatchDB.Close
   MainForm.PatchLink.LinkMode = LM_NONE
   PatchDBOpen = False
   PatchDBName = ""
   On Error GoTo 0
End Sub

Sub DBClose ()
   ClosePatchDB
   CloseInputDB
End Sub

Sub GetList (DBName As String, lnkCtrl As TextBox, lstCtrl As ListBox, lstType As String)
   Dim StartPos As Integer, Pos As Integer
   lnkCtrl.LinkMode = LM_NONE
   lnkCtrl.LinkTopic = "MSAccess|" + DBName
   lnkCtrl.LinkItem = lstType
   lnkCtrl.LinkMode = LM_MANUAL
   lnkCtrl.LinkRequest
   lnkCtrl.LinkMode = LM_NONE
   StartPos = 1
   Do
      Pos = InStr(StartPos, lnkCtrl.Text, Chr$(9))
      If Pos = 0 Then
	 If StartPos < Len(lnkCtrl.Text) Then
	    Pos = Len(lnkCtrl.Text) + 1
	 Else
	    Exit Do
	 End If
      End If
      lstCtrl.AddItem Mid$(lnkCtrl.Text, StartPos, Pos - StartPos)
      StartPos = Pos + 1
   Loop
End Sub

Function InList (ListCtrl As ListBox, TestStr As String) As Integer
   Dim I As Integer
   InList = False
   For I = 0 To (ListCtrl.ListCount - 1) Step 1
      If ListCtrl.List(I) = TestStr Then
	 InList = True
	 Exit For
      End If
   Next I
End Function

Sub LocateMSAccess ()
   Dim ErrSave As Integer
   Dim MBType1 As Integer, MBType2 As Integer, MBType3 As Integer, Msg As String
   Dim Msg1 As String, Msg2 As String, Msg3 As String, Msg4 As String
   Msg1 = "Invalid Database File Name." & Chr(10) & "The file you specified ("
   Msg2 = ") does not exist."
   Msg3 = "Error opening database file "
   Msg4 = "." & Chr(10) & "The database may already be in use by another user."
   MBType1 = MB_RETRYCANCEL + MB_ICONEXCLAMATION + MB_DEFBUTTON1 + MB_APPLMODAL
   MBType2 = MB_OK + MB_ICONSTOP + MB_DEFBUTTON1 + MB_APPLMODAL
   MBType3 = MB_YESNOCANCEL + MB_ICONQUESTION + MB_DEFBUTTON1 + MB_APPLMODAL
   On Error GoTo LocateMSAccessErrorHandler
   CommonForm.CMDialog1.InitDir = PathNamePart(MSAccessPath)
   CommonForm.CMDialog1.Filename = FileNamePart(MSAccessPath)
   CommonForm.CMDialog1.DialogTitle = "Specify MSARN200.EXE or MSACCESS.EXE Location"
   CommonForm.CMDialog1.FilterIndex = 6
   CommonForm.CMDialog1.Flags = OFN_FILEMUSTEXIST + OFN_PATHMUSTEXIST
LocateMSAccessTryAgain:
   CommonForm.CMDialog1.Action = 1
   On Error GoTo 0
   MSAccessPath = CommonForm.CMDialog1.Filename
   Screen.MousePointer = HOURGLASS
   If MSAccessPath <> "" And FileExist(MSAccessPath) Then
      'Do Nothing
   ElseIf PatchDBName <> "" Then
      MsgBox Msg1 & MSAccessPath & Msg2, MBType2, "IPS DB Patch"
   End If

LocateMSAccessExit:
   Screen.MousePointer = DEFAULT
Exit Sub

LocateMSAccessError:
   ErrSave = Err
   MsgBox Msg3 & MSAccessPath & Msg4 & Chr$(10) & Error$, MBType2, "IPS DB Patch"
   Screen.MousePointer = DEFAULT
   Exit Sub


LocateMSAccessErrorHandler:
   ErrSave = Err
   DBFNum = 0
   If ErrSave = CDERR_CANCEL Then
      Resume LocateMSAccessExit
   ElseIf ErrSave = CDERR_DISKNOTREADY Then
      Msg = Error$ & Chr(10) & Chr(10) & "Make sure the disk is ready and select 'RETRY', or select 'CANCEL'"
      Select Case MsgBox(Msg, MBType1, "IPS DB Patch")
      Case IDCANCEL
	 Resume LocateMSAccessExit
      Case IDRETRY
	 Resume LocateMSAccessTryAgain
      End Select
   Else
      Screen.MousePointer = DEFAULT
      Exit Sub
   End If

End Sub

Sub OpenInputDB ()
   Dim ErrSave As Integer
   Dim MBType1 As Integer, MBType2 As Integer, MBType3 As Integer, Msg As String
   Dim Msg1 As String, Msg2 As String, Msg3 As String, Msg4 As String
   Msg1 = "Invalid Database File Name." & Chr(10) & "The file you specified ("
   Msg2 = ") does not exist."
   Msg3 = "Error opening database file "
   Msg4 = "." & Chr(10) & "The database may already be in use by another user."
   MBType1 = MB_RETRYCANCEL + MB_ICONEXCLAMATION + MB_DEFBUTTON1 + MB_APPLMODAL
   MBType2 = MB_OK + MB_ICONSTOP + MB_DEFBUTTON1 + MB_APPLMODAL
   MBType3 = MB_YESNOCANCEL + MB_ICONQUESTION + MB_DEFBUTTON1 + MB_APPLMODAL
   If InputDBOpen Then
      CloseInputDB
   End If
   If InputDBOpen Then
      GoTo OpenInputDBExit
   End If
   On Error GoTo OpenInputDBErrorHandler
   CommonForm.CMDialog1.InitDir = CurDir$
   CommonForm.CMDialog1.Filename = "PATCHINP.MDB"
   CommonForm.CMDialog1.DialogTitle = "Identify Input Database"
   CommonForm.CMDialog1.FilterIndex = 2
   CommonForm.CMDialog1.Flags = OFN_FILEMUSTEXIST + OFN_PATHMUSTEXIST
OpenInputDBTryAgain:
   CommonForm.CMDialog1.Action = 1
   On Error GoTo 0
   InputDBName = CommonForm.CMDialog1.Filename
   Screen.MousePointer = HOURGLASS
   If InputDBName <> "" And FileExist(InputDBName) Then
'Open the MS Access Database.
      On Error GoTo OpenInputDBError
      'Set InputDB = OpenDatabase(InputDBName, True, False)
      On Error GoTo 0
      InputDBOpen = True
   ElseIf InputDBName <> "" Then
      MsgBox Msg1 & InputDBName & Msg2, MBType2, "IPS DB Patch"
   End If

OpenInputDBExit:
   Screen.MousePointer = DEFAULT
Exit Sub

OpenInputDBError:
   ErrSave = Err
   MsgBox Msg3 & InputDBName & Msg4 & Chr$(10) & Error$, MBType2, "IPS DB Patch"
   Screen.MousePointer = DEFAULT
   Exit Sub


OpenInputDBErrorHandler:
   ErrSave = Err
   DBFNum = 0
   If ErrSave = CDERR_CANCEL Then
      Resume OpenInputDBExit
   ElseIf ErrSave = CDERR_DISKNOTREADY Then
      Msg = Error$ & Chr(10) & Chr(10) & "Make sure the disk is ready and select 'RETRY', or select 'CANCEL'"
      Select Case MsgBox(Msg, MBType1, "IPS DB Patch")
      Case IDCANCEL
	 Resume OpenInputDBExit
      Case IDRETRY
	 Resume OpenInputDBTryAgain
      End Select
   Else
      Screen.MousePointer = DEFAULT
      Exit Sub
   End If

End Sub

Sub OpenPatchDB ()
   Dim ErrSave As Integer
   Dim MBType1 As Integer, MBType2 As Integer, MBType3 As Integer, Msg As String
   Dim Msg1 As String, Msg2 As String, Msg3 As String, Msg4 As String
   Msg1 = "Invalid Database File Name." & Chr(10) & "The file you specified ("
   Msg2 = ") does not exist."
   Msg3 = "Error opening database file "
   Msg4 = "." & Chr(10) & "The database may already be in use by another user."
   MBType1 = MB_RETRYCANCEL + MB_ICONEXCLAMATION + MB_DEFBUTTON1 + MB_APPLMODAL
   MBType2 = MB_OK + MB_ICONSTOP + MB_DEFBUTTON1 + MB_APPLMODAL
   MBType3 = MB_YESNOCANCEL + MB_ICONQUESTION + MB_DEFBUTTON1 + MB_APPLMODAL
   If PatchDBOpen Then
      ClosePatchDB
   End If
   If PatchDBOpen Then
      GoTo OpenPatchDBExit
   End If
   On Error GoTo OpenPatchDBErrorHandler
   CommonForm.CMDialog1.InitDir = "C:\IPSLABOR"
   CommonForm.CMDialog1.Filename = "IPSLABOR.MDB"
   CommonForm.CMDialog1.DialogTitle = "Identify Database to Patch"
   CommonForm.CMDialog1.FilterIndex = 2
   CommonForm.CMDialog1.Flags = OFN_FILEMUSTEXIST + OFN_PATHMUSTEXIST
OpenPatchDBTryAgain:
   CommonForm.CMDialog1.Action = 1
   On Error GoTo 0
   PatchDBName = CommonForm.CMDialog1.Filename
   Screen.MousePointer = HOURGLASS
   If PatchDBName <> "" And FileExist(PatchDBName) Then
'Open the MS Access Database.
      On Error GoTo OpenPatchDBError
      'Set InputDB = OpenDatabase(PatchDBName, True, False)
      On Error GoTo 0
      PatchDBOpen = True
   ElseIf PatchDBName <> "" Then
      MsgBox Msg1 & PatchDBName & Msg2, MBType2, "IPS DB Patch"
   End If

OpenPatchDBExit:
   Screen.MousePointer = DEFAULT
Exit Sub

OpenPatchDBError:
   ErrSave = Err
   MsgBox Msg3 & PatchDBName & Msg4 & Chr$(10) & Error$, MBType2, "IPS DB Patch"
   Screen.MousePointer = DEFAULT
   Exit Sub


OpenPatchDBErrorHandler:
   ErrSave = Err
   DBFNum = 0
   If ErrSave = CDERR_CANCEL Then
      Resume OpenPatchDBExit
   ElseIf ErrSave = CDERR_DISKNOTREADY Then
      Msg = Error$ & Chr(10) & Chr(10) & "Make sure the disk is ready and select 'RETRY', or select 'CANCEL'"
      Select Case MsgBox(Msg, MBType1, "IPS DB Patch")
      Case IDCANCEL
	 Resume OpenPatchDBExit
      Case IDRETRY
	 Resume OpenPatchDBTryAgain
      End Select
   Else
      Screen.MousePointer = DEFAULT
      Exit Sub
   End If
End Sub

Sub PatchDatabase ()
   Dim iRet As Integer, InputPos As Integer, PatchPos As Integer, ShellCmd As String
   Dim MBType1 As Integer, MBType2 As Integer, MBType3 As Integer, Msg As String
   Dim Msg1 As String, Msg2 As String, Msg3 As String, Msg4 As String, I As Integer
   Dim ItemStr As String, ItemName As String
   Msg1 = "MS Access is already running."
   Msg2 = "Please Terminate all copies of MS Access, then return here and select 'Retry'."
   Msg3 = "Error opening database file "
   Msg4 = "." & Chr(10) & "The database may already be in use by another user."
   MBType1 = MB_RETRYCANCEL + MB_ICONEXCLAMATION + MB_DEFBUTTON1 + MB_APPLMODAL
   MBType2 = MB_OK + MB_ICONSTOP + MB_DEFBUTTON1 + MB_APPLMODAL
   MBType3 = MB_YESNOCANCEL + MB_ICONQUESTION + MB_DEFBUTTON1 + MB_APPLMODAL
   InputDBName = CurDir$ + "\PATCHINP.MDB"
   If Not FileExist(InputDBName) Then OpenInputDB
   'Select DB File to be patched.
   OpenPatchDB
   MSAccessPath = PathNamePart(PatchDBName) + "\MSARN200.EXE"
   LocateMSAccess
StartMSAccess:
   On Error Resume Next
   DoEvents
   MainForm.InputLink.LinkTimeout = 300
   MainForm.InputLink.LinkTopic = "MSACCESS|System"
   MainForm.InputLink.LinkItem = "Status"
   MainForm.InputLink.LinkMode = LM_MANUAL
   MainForm.InputLink.LinkRequest
   If (MainForm.InputLink.Text = "Ready") Then
      'pop an OK/CANCEL box asking user to shutdown MSACCESS first, then return here and press OK
      Msg = Msg1 & Chr(10) & Chr(10) & Msg2
      Select Case MsgBox(Msg, MBType1, "IPS DB Patch")
      Case IDCANCEL
	 Exit Sub
      Case IDRETRY
	 Resume StartMSAccess
      End Select
   End If
   MainForm.InputLink.LinkMode = LM_NONE
   On Error GoTo 0
   If FileExist(MSAccessPath) Then
      StatusDlg.Show
      MainForm.Visible = False
      StatusDlg.Label2.Caption = "Identifying Objects being Patched..."
      StatusDlg.Label1.Caption = "Please Be Patient..."
      StatusDlg.Refresh
      Screen.MousePointer = HOURGLASS
      ShellCmd = MSAccessPath + " " + InputDBName
      If Shell(ShellCmd, MINIMIZEDWITHOUTFOCUS) Then
	 On Error Resume Next
	 MainForm.InputLink.LinkTopic = "MSACCESS|System"
	 MainForm.InputLink.LinkItem = "Status"
	 MainForm.InputLink.LinkMode = LM_MANUAL
	 While MainForm.InputLink.Text <> "Ready"
	    DoEvents
	    MainForm.InputLink.LinkTopic = "MSACCESS|System"
	    MainForm.InputLink.LinkItem = "Status"
	    MainForm.InputLink.LinkMode = LM_MANUAL
	    MainForm.InputLink.LinkRequest
	 Wend
	 MainForm.InputLink.LinkMode = LM_NONE
	 On Error GoTo 0
      Else
	 MsgBox "Can't Start MS Access for Patch Input Database, Patch cannot be performed"
	 Exit Sub
      End If
      Call GetList(InputDBName, MainForm.InputLink, MainForm.InputTables, "TableList")
      Call GetList(InputDBName, MainForm.InputLink, MainForm.InputQueries, "QueryList")
      Call GetList(InputDBName, MainForm.InputLink, MainForm.InputForms, "FormList")
      Call GetList(InputDBName, MainForm.InputLink, MainForm.InputReports, "ReportList")
      Call GetList(InputDBName, MainForm.InputLink, MainForm.InputMacros, "MacroList")
      Call GetList(InputDBName, MainForm.InputLink, MainForm.InputModules, "ModuleList")
      MainForm.InputLink.LinkTopic = "MSACCESS|System"
      MainForm.InputLink.LinkMode = LM_MANUAL
      MainForm.InputLink.LinkExecute "[Quit]"
      MainForm.InputLink.LinkMode = LM_NONE
      
      DoEvents
      
      StatusDlg.Label2.Caption = "Identifying Existing Database Objects..."
      StatusDlg.Refresh
      ShellCmd = MSAccessPath + " " + PatchDBName
      If Shell(ShellCmd, MINIMIZEDWITHOUTFOCUS) Then
	 On Error Resume Next
	 While MainForm.PatchLink.Text <> "Ready"
	    DoEvents
	    MainForm.PatchLink.LinkTimeout = 300
	    MainForm.PatchLink.LinkTopic = "MSACCESS|System"
	    MainForm.PatchLink.LinkItem = "Status"
	    MainForm.PatchLink.LinkMode = LM_MANUAL
	    MainForm.PatchLink.LinkRequest
	 Wend
	 MainForm.PatchLink.LinkMode = LM_NONE
	 On Error GoTo 0
      Else
	 MsgBox "Can't Start MS Access for Database being patched, Patch cannot be performed"
	 Exit Sub
      End If
      Call GetList(PatchDBName, MainForm.PatchLink, MainForm.PatchTables, "TableList")
      Call GetList(PatchDBName, MainForm.PatchLink, MainForm.PatchQueries, "QueryList")
      Call GetList(PatchDBName, MainForm.PatchLink, MainForm.PatchForms, "FormList")
      Call GetList(PatchDBName, MainForm.PatchLink, MainForm.PatchReports, "ReportList")
      Call GetList(PatchDBName, MainForm.PatchLink, MainForm.PatchMacros, "MacroList")
      Call GetList(PatchDBName, MainForm.PatchLink, MainForm.PatchModules, "ModuleList")
      
      If ProceedWithUpdate() Then
	 'Patch the DB
	 StatusDlg.Label1.Caption = "Updating Database Objects in " + PatchDBName
	 StatusDlg.Label2.Caption = " "
	 StatusDlg.Refresh
      
	 For I = 0 To (UpdateNotice.UpdateList.ListCount - 1) Step 1
	    ItemStr = UpdateNotice.UpdateList.List(I)
	    StatusDlg.Label2.Caption = ItemStr
	    StatusDlg.Refresh
	    If InStr(1, ItemStr, "Table Add ") = 1 Then
	       ItemName = Mid$(ItemStr, 16)
	       Call PatchObject(TABLE_OBJ, ItemName, False)
	    ElseIf InStr(1, ItemStr, "Table Update ") = 1 Then
	       ItemName = Mid$(ItemStr, 16)
	       Call PatchObject(TABLE_OBJ, ItemName, True)
	    ElseIf InStr(1, ItemStr, "Query Add ") = 1 Then
	       ItemName = Mid$(ItemStr, 16)
	       Call PatchObject(QUERY_OBJ, ItemName, False)
	    ElseIf InStr(1, ItemStr, "Query Update ") = 1 Then
	       ItemName = Mid$(ItemStr, 16)
	       Call PatchObject(QUERY_OBJ, ItemName, True)
	    ElseIf InStr(1, ItemStr, "Form Add ") = 1 Then
	       ItemName = Mid$(ItemStr, 15)
	       Call PatchObject(FORM_OBJ, ItemName, False)
	    ElseIf InStr(1, ItemStr, "Form Update ") = 1 Then
	       ItemName = Mid$(ItemStr, 15)
	       Call PatchObject(FORM_OBJ, ItemName, True)
	    ElseIf InStr(1, ItemStr, "Report Add ") = 1 Then
	       ItemName = Mid$(ItemStr, 17)
	       Call PatchObject(REPORT_OBJ, ItemName, False)
	    ElseIf InStr(1, ItemStr, "Report Update ") = 1 Then
	       ItemName = Mid$(ItemStr, 17)
	       Call PatchObject(REPORT_OBJ, ItemName, True)
	    ElseIf InStr(1, ItemStr, "Macro Add ") = 1 Then
	       ItemName = Mid$(ItemStr, 16)
	       Call PatchObject(MACRO_OBJ, ItemName, False)
	    ElseIf InStr(1, ItemStr, "Macro Update ") = 1 Then
	       ItemName = Mid$(ItemStr, 16)
	       Call PatchObject(MACRO_OBJ, ItemName, True)
	    ElseIf InStr(1, ItemStr, "Module Add ") = 1 Then
	       ItemName = Mid$(ItemStr, 17)
	       Call PatchObject(MODULE_OBJ, ItemName, False)
	    ElseIf InStr(1, ItemStr, "Module Update ") = 1 Then
	       ItemName = Mid$(ItemStr, 17)
	       Call PatchObject(MODULE_OBJ, ItemName, True)
	    End If
	    'UpdateNotice.UpdateList.AddItem ItemStr
	 Next I
	 
      End If
      
      
      Unload UpdateNotice
      
      On Error Resume Next
      MainForm.PatchLink.LinkTopic = "MSACCESS|System"
      MainForm.PatchLink.LinkMode = LM_MANUAL
      MainForm.PatchLink.LinkExecute "[Quit]"
      MainForm.PatchLink.LinkMode = LM_NONE
      On Error GoTo 0
      Unload StatusDlg
      Screen.MousePointer = DEFAULT
      AboutBox.ProgLabel.Caption = "IPSLABOR Patch Update Completed!"
      AboutBox.VersionLabel.Caption = " "
      AboutBox.DBLabel.Caption = " "
      AboutBox.Show MODAL
      Unload MainForm
   Else
      MsgBox "Can't find MS Access, Patch cannot be performed"
      Exit Sub
   End If
End Sub

Sub PatchObject (Obj_Type As Integer, ItemName As String, Del_Existing As Integer)
   Dim XfrString As String, ClsString As String, DelString As String
   If Del_Existing Then
      ClsString = "[Close " + Str$(Obj_Type) + " ,""" + ItemName + """]"
      DelString = "[DeleteObject " + Str$(Obj_Type) + " ,""" + ItemName + """]"
      MainForm.PatchLink.LinkTopic = "MSAccess|" + PatchDBName
      MainForm.PatchLink.LinkMode = LM_MANUAL
      MainForm.PatchLink.LinkExecute ClsString
      MainForm.PatchLink.LinkExecute DelString
      MainForm.PatchLink.LinkMode = LM_NONE
   End If
   XfrString = "[TransferDatabase , ""Microsoft Access"", """ + InputDBName + """ ," + Str$(Obj_Type) + ", """ + ItemName + """, """ + ItemName + """]"
   MainForm.PatchLink.LinkTopic = "MSAccess|" + PatchDBName
   MainForm.PatchLink.LinkMode = LM_MANUAL
   MainForm.PatchLink.LinkExecute XfrString
   MainForm.PatchLink.LinkMode = LM_NONE
End Sub

Function ProceedWithUpdate () As Integer
   Dim I As Integer, ItemStr As String
   For I = 0 To (MainForm.InputForms.ListCount - 1) Step 1
      ItemStr = MainForm.InputForms.List(I)
      If InList(MainForm.PatchForms, ItemStr) Then
	 ItemStr = "Form Update - " + ItemStr
      Else
	 ItemStr = "Form Add    - " + ItemStr
      End If
      UpdateNotice.UpdateList.AddItem ItemStr
   Next I
   
   For I = 0 To (MainForm.InputReports.ListCount - 1) Step 1
      ItemStr = MainForm.InputReports.List(I)
      If InList(MainForm.PatchReports, ItemStr) Then
	 ItemStr = "Report Update - " + ItemStr
      Else
	 ItemStr = "Report Add    - " + ItemStr
      End If
      UpdateNotice.UpdateList.AddItem ItemStr
   Next I
   
   For I = 0 To (MainForm.InputMacros.ListCount - 1) Step 1
      ItemStr = MainForm.InputMacros.List(I)
      If InList(MainForm.PatchMacros, ItemStr) Then
	 ItemStr = "Macro Update - " + ItemStr
      Else
	 ItemStr = "Macro Add    - " + ItemStr
      End If
      UpdateNotice.UpdateList.AddItem ItemStr
   Next I
   
   For I = 0 To (MainForm.InputTables.ListCount - 1) Step 1
      ItemStr = MainForm.InputTables.List(I)
      If InList(MainForm.PatchTables, ItemStr) Then
	 ItemStr = "Table Update - " + ItemStr
      Else
	 ItemStr = "Table Add    - " + ItemStr
      End If
      UpdateNotice.UpdateList.AddItem ItemStr
   Next I
   
   For I = 0 To (MainForm.InputQueries.ListCount - 1) Step 1
      ItemStr = MainForm.InputQueries.List(I)
      If InList(MainForm.PatchQueries, ItemStr) Then
	 ItemStr = "Query Update - " + ItemStr
      Else
	 ItemStr = "Query Add    - " + ItemStr
      End If
      UpdateNotice.UpdateList.AddItem ItemStr
   Next I
   
   For I = 0 To (MainForm.InputModules.ListCount - 1) Step 1
      ItemStr = MainForm.InputModules.List(I)
      If InList(MainForm.PatchModules, ItemStr) Then
	 ItemStr = "Module Update - " + ItemStr
      Else
	 ItemStr = "Module Add    - " + ItemStr
      End If
      UpdateNotice.UpdateList.AddItem ItemStr
   Next I

   Screen.MousePointer = NORMAL
   UpdateNotice.Show MODAL
   Screen.MousePointer = HOURGLASS

   ProceedWithUpdate = ProceedChoice

End Function

Function TableOpen (db As Database, tbl As Table, tblName As String) As Integer
   Dim MBType1 As Integer, Msg1 As String, Msg2 As String, ErrSave As Integer
   MBType1 = MB_OK + MB_ICONSTOP + MB_DEFBUTTON1 + MB_APPLMODAL
   Msg1 = "Error opening Database Table "
   Msg2 = "." & Chr(10) & "The table may already be in use by another user."
   TableOpen = False
   On Error GoTo TBLOpenError
   'Set tbl = db.OpenTable(tblName)
   TableOpen = True
   Exit Function

TBLOpenError:
   ErrSave = Err
   MsgBox Msg1 & tblName & Msg2 & Chr$(10) & Chr$(10) & Error$, MBType1, "IPS DB Patch"
   Exit Function
End Function

