'-----------------------------------------------------------------------
' IPS Time and MDB Patch Tool (TALAS), Version 1.0
' Copyright 1995 (Unpublished) Integrated Planning Systems, inc.
' All Rights Reserved.
'
' Integrated Planning Systems Proprietary Rights are included in this
' Software, in the data or documentation relating thereto, and in the
' information disclosed therein.  Neither this software, regardless of
' the form in which it exists, nor such data or information may be
' used by or disclosed to others for any purpose except as specifically
' authorized in writing by Integrated Planning Systems, inc.
'
' This software was developed exclusively at private expense
' as defined in DFARS 252.227-7013(a)(12).
'
' This software was developed under IPS General and Administrative
' Account A1035LAS.
'-----------------------------------------------------------------------

Option Explicit

Global Filename As String, FDir As String, FNum As Integer, HomeDir As String
Global WinDir As String, WinAPIReturn As Integer, WinAPIBuffer As String * 16384
Global WinINISect As String * 30, WinINIVar As String * 30, WindwState As Integer
Global WindowWidth As Integer, WindowHeight As Integer, WindowLeft As Integer, WindowTop As Integer
Global HelpFilePath As String, PicFileName As String

Global DBFilename As String, DBFNum As Integer, DBDir As String
Global PEL2TWIPSX As Integer, PEL2TWIPSY As Integer, SuspendRepaint As Integer

Global Const INISectionName = "IPS DB Patch"

Type RECT
   Left As Integer
   Top As Integer
   right As Integer
   bottom As Integer
End Type

Global Const TableObject = 1
Global Const QueryObject = 2
Global Const FormObject = 3
Global Const ReportObject = 4
Global Const MacroObject = 5
Global Const ModuleObject = 6

Global Const KeyStat_Toggled = 1

'----------------------------------------------------------------------------
' Windows API Routines
'----------------------------------------------------------------------------
Declare Function GetProfileString Lib "Kernel" (ByVal lpSection As String, ByVal lpEntry As String, ByVal lpDefault As String, ByVal Buffer As String, ByVal cbBuffer As Integer) As Integer
Declare Function WriteProfileString Lib "Kernel" (ByVal lpSection As String, ByVal lpEntry As Any, ByVal lpString As Any) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lplFileName As String) As Integer
Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Sub GetClientRect Lib "User" (ByVal hWnd As Integer, lpRect As RECT)
Declare Function GetKeyState Lib "User" (ByVal nVirtKey As Integer) As Integer
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
Declare Function WinHelp Lib "User" (ByVal hWnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, dwData As Any) As Integer
Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)

'Windows constants
Global Const HWND_TOPMOST = -1
Global Const SWP_NOMOVE = &H2
Global Const SWP_NOSIZE = &H1

'Constants for referencing picClip Graphic Cells for CCNSelect Pictures:
'Global Const Normal = 0      'Commented out because Normal is already defined as zero
Global Const NormalActive = 1
Global Const NormalDisabled = 2
Global Const NormalSelected = 3
Global Const Modified = 4
Global Const ModifiedActive = 5
Global Const ModifiedDisabled = 6
Global Const ModifiedSelected = 7
Global Const NewLine = 8
Global Const NewLineActive = 9
Global Const NewLineDisabled = 10
Global Const NewLineSelected = 11

'Help Constants
Global Const HELP_CONTEXT = &H1           'Display topic in ulTopic
Global Const HELP_QUIT = &H2              'Terminate help
Global Const HELP_INDEX = &H3             'Display index
Global Const HELP_CONTENTS = &H3
Global Const HELP_HELPONHELP = &H4        'Display help on using help
Global Const HELP_SETINDEX = &H5          'Set the current Index for multi index help
Global Const HELP_SETCONTENTS = &H5
Global Const HELP_CONTEXTPOPUP = &H8
Global Const HELP_FORCEFILE = &H9
Global Const HELP_KEY = &H101             'Display topic for keyword in offabData
Global Const HELP_COMMAND = &H102
Global Const HELP_PARTIALKEY = &H105      'call the search engine in winhelp

'Error Constants
Global Const File_Not_Found = 53
Global Const Disk_Full = 61

' Show parameters
Global Const MODAL = 1
Global Const MODELESS = 0

' Arrange Method
' for MDI Forms
Global Const CASCADE = 0
Global Const TILE_HORIZONTAL = 1
Global Const TILE_VERTICAL = 2
Global Const ARRANGE_ICONS = 3

'ZOrder Method
Global Const BRINGTOFRONT = 0
Global Const SENDTOBACK = 1

' Key Codes
Global Const KEY_LBUTTON = &H1
Global Const KEY_RBUTTON = &H2
Global Const KEY_CANCEL = &H3
Global Const KEY_MBUTTON = &H4    ' NOT contiguous with L & RBUTTON
Global Const KEY_BACK = &H8
Global Const KEY_TAB = &H9
Global Const KEY_CLEAR = &HC
Global Const KEY_RETURN = &HD
Global Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11
Global Const KEY_MENU = &H12
Global Const KEY_PAUSE = &H13
Global Const KEY_CAPITAL = &H14
Global Const KEY_ESCAPE = &H1B
Global Const KEY_SPACE = &H20
Global Const KEY_PRIOR = &H21
Global Const KEY_NEXT = &H22
Global Const KEY_END = &H23
Global Const KEY_HOME = &H24
Global Const KEY_LEFT = &H25
Global Const KEY_UP = &H26
Global Const KEY_RIGHT = &H27
Global Const KEY_DOWN = &H28
Global Const KEY_SELECT = &H29
Global Const KEY_PRINT = &H2A
Global Const KEY_EXECUTE = &H2B
Global Const KEY_SNAPSHOT = &H2C
Global Const KEY_INSERT = &H2D
Global Const KEY_DELETE = &H2E
Global Const KEY_HELP = &H2F

' KEY_A thru KEY_Z are the same as their ASCII equivalents: 'A' thru 'Z'
' KEY_0 thru KEY_9 are the same as their ASCII equivalents: '0' thru '9'

Global Const KEY_NUMPAD0 = &H60
Global Const KEY_NUMPAD1 = &H61
Global Const KEY_NUMPAD2 = &H62
Global Const KEY_NUMPAD3 = &H63
Global Const KEY_NUMPAD4 = &H64
Global Const KEY_NUMPAD5 = &H65
Global Const KEY_NUMPAD6 = &H66
Global Const KEY_NUMPAD7 = &H67
Global Const KEY_NUMPAD8 = &H68
Global Const KEY_NUMPAD9 = &H69
Global Const KEY_MULTIPLY = &H6A
Global Const KEY_ADD = &H6B
Global Const KEY_SEPARATOR = &H6C
Global Const KEY_SUBTRACT = &H6D
Global Const KEY_DECIMAL = &H6E
Global Const KEY_DIVIDE = &H6F
Global Const KEY_F1 = &H70
Global Const KEY_F2 = &H71
Global Const KEY_F3 = &H72
Global Const KEY_F4 = &H73
Global Const KEY_F5 = &H74
Global Const KEY_F6 = &H75
Global Const KEY_F7 = &H76
Global Const KEY_F8 = &H77
Global Const KEY_F9 = &H78
Global Const KEY_F10 = &H79
Global Const KEY_F11 = &H7A
Global Const KEY_F12 = &H7B
Global Const KEY_F13 = &H7C
Global Const KEY_F14 = &H7D
Global Const KEY_F15 = &H7E
Global Const KEY_F16 = &H7F

Global Const KEY_NUMLOCK = &H90
Global Const KEY_SCROLLOCK = &H91

' Colors
Global Const BLACK = &H0&
Global Const RED = &HFF&
Global Const GREEN = &HFF00&
Global Const YELLOW = &HFFFF&
Global Const BLUE = &HFF0000
Global Const MAGENTA = &HFF00FF
Global Const CYAN = &HFFFF00
Global Const WHITE = &HFFFFFF
Global Const GRAY = &HC0C0C0

' System Colors
Global Const SCROLL_BARS = &H80000000           ' Scroll-bars gray area.
Global Const DESKTOP = &H80000001               ' Desktop.
Global Const ACTIVE_TITLE_BAR = &H80000002      ' Active window caption.
Global Const INACTIVE_TITLE_BAR = &H80000003    ' Inactive window caption.
Global Const MENU_BAR = &H80000004              ' Menu background.
Global Const WINDOW_BACKGROUND = &H80000005     ' Window background.
Global Const WINDOW_FRAME = &H80000006          ' Window frame.
Global Const MENU_TEXT = &H80000007             ' Text in menus.
Global Const WINDOW_TEXT = &H80000008           ' Text in windows.
Global Const TITLE_BAR_TEXT = &H80000009        ' Text in caption, size box, scroll-bar arrow box..
Global Const ACTIVE_BORDER = &H8000000A         ' Active window border.
Global Const INACTIVE_BORDER = &H8000000B       ' Inactive window border.
Global Const APPLICATION_WORKSPACE = &H8000000C ' Background color of multiple document interface (MDI) applications.
Global Const Highlight = &H8000000D             ' Items selected item in a control.
Global Const HIGHLIGHT_TEXT = &H8000000E        ' Text of item selected in a control.
Global Const BUTTON_FACE = &H8000000F           ' Face shading on command buttons.
Global Const BUTTON_SHADOW = &H80000010         ' Edge shading on command buttons.
Global Const GRAY_TEXT = &H80000011             ' Grayed (disabled) text.  This color is set to 0 if the current display driver does not support a solid gray color.
Global Const BUTTON_TEXT = &H80000012           ' Text on push buttons.
Global Const BUTTON_HIGHLIGHT = &HFFFFFF

' MousePointer
Global Const DEFAULT = 0        ' 0 - Default
Global Const ARROW = 1          ' 1 - Arrow
Global Const CROSSHAIR = 2      ' 2 - Cross
Global Const IBEAM = 3          ' 3 - I-Beam
Global Const ICON_POINTER = 4   ' 4 - Icon
Global Const SIZE_POINTER = 5   ' 5 - Size
Global Const SIZE_NE_SW = 6     ' 6 - Size NE SW
Global Const SIZE_N_S = 7       ' 7 - Size N S
Global Const SIZE_NW_SE = 8     ' 8 - Size NW SE
Global Const SIZE_W_E = 9       ' 9 - Size W E
Global Const UP_ARROW = 10      ' 10 - Up Arrow
Global Const HOURGLASS = 11     ' 11 - Hourglass
Global Const NO_DROP = 12       ' 12 - No drop

'Shell command constants
Global Const NORMALWITHFOCUS = 1
Global Const MINIMIZEDWITHFOCUS = 2
Global Const MAXIMIZEDWITHFOCUS = 3
Global Const NORMALWITHOUTFOCUS = 4
Global Const MINIMIZEDWITHOUTFOCUS = 6

'DDE Link Mode Constants
Global Const LM_NONE = 0
Global Const LM_AUTOMATIC = 1
Global Const LM_MANUAL = 2
Global Const LM_NOTIFY = 3

' WindowState
Global Const Normal = 0    ' 0 - Normal
Global Const MINIMIZED = 1 ' 1 - Minimized
Global Const MAXIMIZED = 2 ' 2 - Maximized

' Check Value
Global Const UNCHECKED = 0 ' 0 - Unchecked
Global Const CHECKED = 1   ' 1 - Checked
Global Const GRAYED = 2    ' 2 - Grayed

' Shift parameter masks
Global Const SHIFT_MASK = 1
Global Const CTRL_MASK = 2
Global Const ALT_MASK = 4

' Button parameter masks
Global Const LEFT_BUTTON = 1
Global Const RIGHT_BUTTON = 2
Global Const MIDDLE_BUTTON = 4

' Function Parameters
' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default
Global Const MB_SYSTEMMODAL = 4096      'System Modal

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed


'File Open/Save Dialog Flags
Global Const OFN_READONLY = &H1&
Global Const OFN_OVERWRITEPROMPT = &H2&
Global Const OFN_HIDEREADONLY = &H4&
Global Const OFN_NOCHANGEDIR = &H8&
Global Const OFN_SHOWHELP = &H10&
Global Const OFN_NOVALIDATE = &H100&
Global Const OFN_ALLOWMULTISELECT = &H200&
Global Const OFN_EXTENSIONDIFFERENT = &H400&
Global Const OFN_PATHMUSTEXIST = &H800&
Global Const OFN_FILEMUSTEXIST = &H1000&
Global Const OFN_CREATEPROMPT = &H2000&
Global Const OFN_SHAREAWARE = &H4000&
Global Const OFN_NOREADONLYRETURN = &H8000&


'Printer Dialog Flags
Global Const PD_ALLPAGES = &H0&
Global Const PD_SELECTION = &H1&
Global Const PD_PAGENUMS = &H2&
Global Const PD_NOSELECTION = &H4&
Global Const PD_NOPAGENUMS = &H8&
Global Const PD_COLLATE = &H10&
Global Const PD_PRINTTOFILE = &H20&
Global Const PD_PRINTSETUP = &H40&
Global Const PD_NOWARNING = &H80&
Global Const PD_RETURNDC = &H100&
Global Const PD_RETURNIC = &H200&
Global Const PD_RETURNDEFAULT = &H400&
Global Const PD_SHOWHELP = &H800&
Global Const PD_USEDEVMODECOPIES = &H40000
Global Const PD_DISABLEPRINTTOFILE = &H80000
Global Const PD_HIDEPRINTTOFILE = &H100000


'Error Constants
Global Const CDERR_DIALOGFAILURE = -32768
Global Const CDERR_GENERALCODES = &H7FFF
Global Const CDERR_STRUCTSIZE = &H7FFE
Global Const CDERR_INITIALIZATION = &H7FFD
Global Const CDERR_NOTEMPLATE = &H7FFC
Global Const CDERR_NOHINSTANCE = &H7FFB
Global Const CDERR_LOADSTRFAILURE = &H7FFA
Global Const CDERR_FINDRESFAILURE = &H7FF9
Global Const CDERR_LOADRESFAILURE = &H7FF8
Global Const CDERR_LOCKRESFAILURE = &H7FF7
Global Const CDERR_MEMALLOCFAILURE = &H7FF6
Global Const CDERR_MEMLOCKFAILURE = &H7FF5
Global Const CDERR_NOHOOK = &H7FF4
Global Const CDERR_DISKNOTREADY = &H47

'Added for CMDIALOG.VBX
Global Const CDERR_CANCEL = &H7FF3
Global Const CDERR_NODLL = &H7FF2
Global Const CDERR_ERRPROC = &H7FF1
Global Const CDERR_ALLOC = &H7FF0
Global Const CDERR_HELP = &H7FEF

Global Const PDERR_PRINTERCODES = &H6FFF
Global Const PDERR_SETUPFAILURE = &H6FFE
Global Const PDERR_PARSEFAILURE = &H6FFD
Global Const PDERR_RETDEFFAILURE = &H6FFC
Global Const PDERR_LOADDRVFAILURE = &H6FFB
Global Const PDERR_GETDEVMODEFAIL = &H6FFA
Global Const PDERR_INITFAILURE = &H6FF9
Global Const PDERR_NODEVICES = &H6FF8
Global Const PDERR_NODEFAULTPRN = &H6FF7
Global Const PDERR_DNDMMISMATCH = &H6FF6
Global Const PDERR_CREATEICFAILURE = &H6FF5
Global Const PDERR_PRINTERNOTFOUND = &H6FF4

Global Const CFERR_CHOOSEFONTCODES = &H5FFF
Global Const CFERR_NOFONTS = &H5FFE

Global Const FNERR_FILENAMECODES = &H4FFF
Global Const FNERR_SUBCLASSFAILURE = &H4FFE
Global Const FNERR_INVALIDFILENAME = &H4FFD
Global Const FNERR_BUFFERTOOSMALL = &H4FFC

Global Const FRERR_FINDREPLACECODES = &H3FFF
Global Const CCERR_CHOOSECOLORCODES = &H2FFF



'---------------------------------------
'Key Status Control
'---------------------------------------
'Style
Global Const KEYSTAT_CAPSLOCK = 0
Global Const KEYSTAT_NUMLOCK = 1
Global Const KEYSTAT_INSERT = 2
Global Const KEYSTAT_SCROLLLOCK = 3


'---------------------------------------
'API SendMessage Constants
'---------------------------------------

Global Const WM_USER = &H400
Global Const EM_CANUNDO = WM_USER + 22
Global Const EM_UNDO = WM_USER + 23
Global Const EM_SETREADONLY = WM_USER + 31

Sub CenterForm (frm As Form)
   Dim iLeft As Integer, iTop As Integer
   iLeft = (Screen.Width - frm.Width) / 2
   iTop = (Screen.Height - frm.Height) / 2
   frm.Move iLeft, iTop
End Sub

Function FileExist (ByVal FName As String) As Integer
   On Error GoTo FileExistError
   FileExist = Dir(FName) <> ""
   On Error GoTo 0
   Exit Function

FileExistError:
   FileExist = False
   Resume Next
End Function

Function FileNamePart (FName As String) As String
   Dim FnameStart As Integer
   FnameStart = 1
   If (Len(FName) > 0) Then
      While InStr(FnameStart, FName, "\") <> 0
	 FnameStart = InStr(FnameStart, FName, "\") + 1
      Wend
      FileNamePart = Mid$(FName, FnameStart)
   Else
      FileNamePart = ""
   End If
End Function

Function Help_File_In_Path ()
Dim Path As String, CurrentDir As String, Found As Integer, SemiColon As Integer

    On Error Resume Next
    CurrentDir = App.Path
    If Right$(CurrentDir, 1) <> "\" Then CurrentDir = CurrentDir + "\"
    Found = Dir$(CurrentDir + "TIMESUM.HLP") <> ""
    If Not Found Then
	Path = Environ$("PATH")
	If Path <> "" Then
	    If Right$(Path, 1) <> ";" Then Path = Path + ";"
	    SemiColon = InStr(Path, ";")
	    Do
		CurrentDir = Left$(Path, SemiColon - 1)
		If Right$(CurrentDir, 1) <> "\" Then CurrentDir = CurrentDir + "\"
		Found = Dir$(CurrentDir + "TIMESUM.HLP") <> ""
		Path = Right$(Path, Len(Path) - SemiColon)
		SemiColon = InStr(Path, ";")
	    Loop While ((SemiColon <> 0) And Not Found)
	End If
    End If
    If Found Then
	HelpFilePath = CurrentDir + "TIMESUM.HLP"
	App.HelpFile = CurrentDir + "TIMESUM.HLP"
    End If
    Help_File_In_Path = Found
    
    On Error GoTo 0

End Function

Sub InitGlobalArrays ()
'******************************************************
'**  Get Screen Properties so we can convert Pixel Sizes
'**  to the TWIPS required by VB
'******************************************************
   PEL2TWIPSX = Screen.TwipsPerPixelX
   PEL2TWIPSY = Screen.TwipsPerPixelY
End Sub

Sub Make3D (ParentCtrl As Control, Ctrl As Control)
   Dim Shadow As Long, Highlight As Long
   If Ctrl.Visible Then
      Shadow = BUTTON_SHADOW
      Highlight = BUTTON_HIGHLIGHT
   Else
      Shadow = BUTTON_FACE
      Highlight = BUTTON_FACE
   End If
   If TypeOf Ctrl Is PictureBox Then
      Ctrl.DrawWidth = 1
      Ctrl.ScaleMode = 3 'Pixel
      Ctrl.CurrentX = 0
      Ctrl.CurrentY = Ctrl.ScaleHeight - 1
      Ctrl.Line -Step(0, -(Ctrl.ScaleHeight - 1)), Highlight
      Ctrl.Line -Step((Ctrl.ScaleWidth - 1), 0), Highlight
      Ctrl.Line -Step(0, (Ctrl.ScaleHeight - 1)), Shadow
      Ctrl.Line -Step(-(Ctrl.ScaleWidth), 0), Shadow
      Ctrl.CurrentX = 1
      Ctrl.CurrentY = Ctrl.ScaleHeight - 2
      Ctrl.Line -Step(0, -(Ctrl.ScaleHeight - 3)), Highlight
      Ctrl.Line -Step((Ctrl.ScaleWidth - 3), 0), Highlight
      Ctrl.Line -Step(0, (Ctrl.ScaleHeight - 3)), Shadow
      Ctrl.Line -Step(-(Ctrl.ScaleWidth - 2), 0), Shadow
   ElseIf TypeOf Ctrl Is Label Then
      ParentCtrl.DrawWidth = 1
      ParentCtrl.ScaleMode = 3 'Pixel
      ParentCtrl.CurrentX = Ctrl.Left - 1
      ParentCtrl.CurrentY = Ctrl.Top + Ctrl.Height
      ParentCtrl.Line -Step(0, -(Ctrl.Height + 1)), Highlight
      ParentCtrl.Line -Step((Ctrl.Width + 1), 0), Highlight
      ParentCtrl.Line -Step(0, (Ctrl.Height + 1)), Shadow
      ParentCtrl.Line -Step(-(Ctrl.Width + 1), 0), Shadow
      ParentCtrl.CurrentX = Ctrl.Left - 2
      ParentCtrl.CurrentY = Ctrl.Top + Ctrl.Height + 1
      ParentCtrl.Line -Step(0, -(Ctrl.Height + 3)), Highlight
      ParentCtrl.Line -Step((Ctrl.Width + 3), 0), Highlight
      ParentCtrl.Line -Step(0, (Ctrl.Height + 3)), Shadow
      ParentCtrl.Line -Step(-(Ctrl.Width + 3), 0), Shadow
   Else
      ParentCtrl.DrawWidth = 1
      ParentCtrl.ScaleMode = 3 'Pixel
      ParentCtrl.CurrentX = Ctrl.Left - 1
      ParentCtrl.CurrentY = Ctrl.Top + Ctrl.Height
      ParentCtrl.Line -Step(0, -(Ctrl.Height + 1)), Shadow
      ParentCtrl.Line -Step((Ctrl.Width + 1), 0), Shadow
      ParentCtrl.Line -Step(0, (Ctrl.Height + 1)), Highlight
      ParentCtrl.Line -Step(-(Ctrl.Width + 1), 0), Highlight
      ParentCtrl.CurrentX = Ctrl.Left - 2
      ParentCtrl.CurrentY = Ctrl.Top + Ctrl.Height + 1
      ParentCtrl.Line -Step(0, -(Ctrl.Height + 3)), Shadow
      ParentCtrl.Line -Step((Ctrl.Width + 3), 0), Shadow
      ParentCtrl.Line -Step(0, (Ctrl.Height + 3)), Highlight
      ParentCtrl.Line -Step(-(Ctrl.Width + 3), 0), Highlight
   End If
End Sub

Function NumTokens (tmp As String, search As String)
   Dim X As Integer, s As Integer, n As Integer
   s = 1
   X = InStr(s, tmp, search)
   While X > 0
      n = n + 1
      s = X + 1
      X = InStr(s, tmp, search)
   Wend
   If X = Len(tmp) Then
      NumTokens = n
   Else
      NumTokens = n + 1
   End If
End Function

Function PathNamePart (FName As String) As String
   Dim FnameStart As Integer
   FnameStart = 1
   If (Len(FName) > 0) Then
      While InStr(FnameStart, FName, "\") <> 0
	 FnameStart = InStr(FnameStart, FName, "\") + 1
      Wend
      PathNamePart = Left$(FName, FnameStart - 2)
   Else
      PathNamePart = ""
   End If
End Function

Sub PrintSetup ()
   Dim ErrSave As Integer
   On Error GoTo FilePrtSetupErrorHandler
   CommonForm.CMDialog1.Flags = PD_PRINTSETUP
   CommonForm.CMDialog1.Action = 5
   On Error GoTo 0

FilePrtSetupExit:
   Exit Sub

FilePrtSetupErrorHandler:
   ErrSave = Err
   FNum = 0
   If ErrSave = CDERR_CANCEL Then
      Resume FilePrtSetupExit
   Else
      Exit Sub
   End If
End Sub

Function Token (tmp As String, search As String) As String
    Dim X As Integer
    X = InStr(1, tmp, search)
    If X Then
       Token = Mid$(tmp, 1, X - 1)
       tmp = Mid$(tmp, X + 1)
    Else
       Token = tmp
       tmp = ""
    End If
End Function

