VERSION 2.00
Begin Form Cursors 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Custom Cursor Sample"
   ClientHeight    =   1950
   ClientLeft      =   3735
   ClientTop       =   3030
   ClientWidth     =   3135
   Height          =   2355
   Left            =   3675
   LinkTopic       =   "Form1"
   ScaleHeight     =   1950
   ScaleWidth      =   3135
   Top             =   2685
   Width           =   3255
   Begin CommandButton Command3 
      Caption         =   "END"
      Height          =   1215
      Left            =   1800
      TabIndex        =   2
      Top             =   360
      Width           =   975
   End
   Begin Timer Timer1 
      Interval        =   1
      Left            =   0
      Top             =   0
   End
   Begin CommandButton Command2 
      Caption         =   "Command2"
      Height          =   735
      Left            =   480
      TabIndex        =   1
      Top             =   840
      Width           =   1215
   End
   Begin CommandButton Command1 
      Caption         =   "Command1"
      Height          =   375
      Left            =   480
      TabIndex        =   0
      Top             =   360
      Width           =   1215
   End
End
'
' This form demonstrates how to have custom cursors
' over button controls
'
' W.Swift
' 5.1.95
' ISIS Project
'
Option Explicit
Declare Sub FreeLibrary Lib "Kernel" (ByVal hLibModule As Integer)
Declare Sub GetCursorPos Lib "User" (p As PointType)
Declare Function SetCursor Lib "User" (ByVal hCursor As Integer) As Integer
Declare Function LoadCursor Lib "User" (ByVal hInstance As Integer, ByVal CusorName As Any) As Integer
Declare Function LoadLibrary Lib "Kernel" (ByVal LibName$) As Integer
Declare Function SetClassWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal NewValas As Integer) As Integer
Declare Function DestroyCursor Lib "User" (ByVal Handle As Integer) As Integer
Declare Function WindowFromPoint Lib "User" (ByVal y As Integer, ByVal x As Integer) As Integer

Const IDC_ARROW = 32512&
Const GCW_HCURSOR = -12

Dim arrowhandle As Integer
Dim DLLInstance As Integer
Dim NewCursorhandle As Integer

Sub Command3_Click ()
    Unload Me
End Sub

Sub Form_Load ()
'
' Load the DLL holding cursor resources
' and get a handle to the system arrow
' and the new custom cursor
'
'
' Cursors available in cursors.dll are:
'
' POINT01    POINT02    POINT03    POINT04    POINT05
' POINT06    POINT07    POINT08    POINT09    POINT10
' POINT11    POINT12    POINT13    POINT14    POINT15
' HANDSHAK   PHONE12    PHONE13    TRASH03    TRASH01
' TRASH02A   TRASH02B   MAIL03     BINOCULR   HOUSE
' SECUR08
'
' As found in Appendix B of the Programmer's Guide
'
    Dim lastcursor As Integer

    DLLInstance = LoadLibrary(APP.Path + "\cursors.DLL")
    NewCursorhandle = LoadCursor(DLLInstance, "MAIL03")
    arrowhandle = LoadCursor(0&, IDC_ARROW)
    
End Sub

Sub Form_Unload (Cancel As Integer)
    
    Dim success
    Call FreeLibrary(DLLInstance)
    success = DestroyCursor(NewCursorhandle)

End Sub

Sub Timer1_Timer ()
'
' Whenever the cursor passes over the required
' button, set the button's class cursor to null
' and set the screen cursor to the cutom cursor.
' When not over the control, if the custom cursor
' is shown set it back again to an arrow.
'
' We set the button cursor blnak to stop windows
' resetting the cursor when the mouse moves.
'
    Dim lastcursor As Integer
    Dim p As PointType
    Static fCustom As Integer
    Static FormMousePointer As Integer

    Call GetCursorPos(p)
    Select Case WindowFromPoint(p.y, p.x)
        Case Command1.hWnd
            If Not fCustom Then
                FormMousePointer = Me.MousePointer
                Me.MousePointer = False
                lastcursor = SetClassWord(Command1.hWnd, GCW_HCURSOR, 0&)
                lastcursor = SetCursor(NewCursorhandle)
                fCustom = True
            End If
        Case Else
            If fCustom Then
                Me.MousePointer = FormMousePointer
                lastcursor = SetCursor(arrowhandle)
                fCustom = False
            End If
    End Select
    End Sub

