Option Explicit
'above is always a good idea

'GetDriveType return values - from win30api.txt
Global Const DRIVE_REMOVABLE = 2
Global Const DRIVE_FIXED = 3
Global Const DRIVE_REMOTE = 4

'API calls for network connections and drive types
Declare Function WNetAddConnection% Lib "User" (ByVal RemoteName As String, ByVal Password As String, ByVal LocalName As String)
Declare Function WNetGetConnection% Lib "User" (ByVal LocalName As String, ByVal RemoteName As String, RNLen As Integer)
Declare Function WNetCancelConnection% Lib "User" (ByVal LocalName As String, ByVal Force As Integer)
Declare Function GetDriveType Lib "Kernel" (ByVal drv As Integer) As Integer

Sub ScanDrives ()
    
    Dim drive%
    Dim res%
    Dim offset%
    Dim DriveLetter$, ld$
    Dim res2%
    Dim NetConnLen%
    Dim NetConn As String * 64
    Dim ln As String
    

    offset% = Asc("A")
    frmMain!lstConn.Clear
    frmMain!lstFree.Clear

'GetDriveType uses A=0, B=1, etc, for drive assignments
    For drive% = 0 To 25
'Return value is a number representing the different drive types
        res% = GetDriveType(drive%)
'Pick up the right drive letter
        DriveLetter$ = Chr$(offset% + drive%) + ":"
        Select Case res%

'For local or floppy drives, may want to be able to work with these too
            Case DRIVE_FIXED

            Case DRIVE_REMOVABLE

'For connected network drives, get connection name
'and add it to the lstConn list box
            Case DRIVE_REMOTE
                NetConnLen% = 64
                res2% = WNetGetConnection%(DriveLetter$, NetConn, NetConnLen%)
                frmMain!lstConn.AddItem DriveLetter$ + " " + NetConn

'For available network drives, add to the lstFree list box
            Case 0
                If drive% > 6 Then frmMain!lstFree.AddItem DriveLetter$

            Case Else

        End Select
    Next

End Sub

Sub ScanPrinters ()

    Dim portnum%
    Dim port$
    Dim res%
    Dim NetConnLen%
    Dim NetConn As String * 64

'Clear the list boxes first
    frmMain!lstConn.Clear
    frmMain!lstFree.Clear

'Scan through each of the port numbers - assuming LPT1: to LPT3:
'which is true for most networking systems.
    For portnum% = 1 To 3
        port$ = "LPT" & CStr(portnum%) & ":"
        NetConnLen% = 64
'Check for the connection
        res% = WNetGetConnection%(port$, NetConn, NetConnLen%)
'If there is a printer on this port, add it to the
'lstConn list box, otherwise add the port to the free ports list box
        If res% = 0 Then
            frmMain!lstConn.AddItem port$ & " " & NetConn
        Else
            frmMain!lstFree.AddItem port$
        End If
    Next portnum%

End Sub

