VERSION 2.00
Begin Form Form1 
   Caption         =   "Graph"
   ClientHeight    =   5865
   ClientLeft      =   1095
   ClientTop       =   975
   ClientWidth     =   7560
   Height          =   6270
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   5865
   ScaleWidth      =   7560
   Top             =   630
   Width           =   7680
   Begin CommandButton Cmd_Copy 
      Caption         =   "Copy MF"
      Height          =   375
      Index           =   1
      Left            =   6120
      TabIndex        =   17
      Top             =   4920
      Width           =   1095
   End
   Begin CommandButton Cmd_Copy 
      Caption         =   "Copy BMP"
      Height          =   375
      Index           =   0
      Left            =   4920
      TabIndex        =   16
      Top             =   4920
      Width           =   1095
   End
   Begin CommandButton Cmd_Save 
      Caption         =   "Save MF"
      Height          =   375
      Left            =   6120
      TabIndex        =   15
      Top             =   5400
      Width           =   1095
   End
   Begin CommandButton Cmd_Graph 
      Caption         =   "Plot"
      Height          =   375
      Left            =   5160
      TabIndex        =   14
      Top             =   4440
      Width           =   1695
   End
   Begin CommandButton Cmd_Scale 
      Caption         =   "Change Scale"
      Height          =   375
      Left            =   5160
      TabIndex        =   13
      Top             =   3960
      Width           =   1695
   End
   Begin TextBox Txt_Label 
      Height          =   285
      Index           =   2
      Left            =   960
      MaxLength       =   15
      TabIndex        =   11
      Top             =   5400
      Width           =   3375
   End
   Begin TextBox Txt_Label 
      Height          =   285
      Index           =   1
      Left            =   960
      MaxLength       =   15
      TabIndex        =   9
      Top             =   5040
      Width           =   3375
   End
   Begin TextBox Txt_Label 
      Height          =   285
      Index           =   0
      Left            =   960
      MaxLength       =   15
      TabIndex        =   7
      Top             =   4680
      Width           =   3375
   End
   Begin CommandButton Cmd_Print 
      Caption         =   "Print MF"
      Height          =   375
      Left            =   4920
      TabIndex        =   6
      Top             =   5400
      Width           =   1095
   End
   Begin TextBox Txt_Num_Pts 
      Height          =   285
      Left            =   6360
      MaxLength       =   5
      TabIndex        =   1
      Top             =   360
      Width           =   855
   End
   Begin TextBox Txt_XY 
      Height          =   285
      Index           =   1
      Left            =   6000
      MaxLength       =   9
      TabIndex        =   5
      Top             =   720
      Width           =   1455
   End
   Begin TextBox Txt_XY 
      Height          =   285
      Index           =   0
      Left            =   4560
      MaxLength       =   9
      TabIndex        =   4
      Top             =   720
      Width           =   1455
   End
   Begin ListBox Lst_XY 
      Height          =   2565
      Left            =   4560
      TabIndex        =   3
      Top             =   1080
      Width           =   2895
   End
   Begin PictureBox Pic_Graph 
      AutoRedraw      =   -1  'True
      Height          =   4245
      Left            =   120
      ScaleHeight     =   4215
      ScaleWidth      =   4215
      TabIndex        =   2
      Top             =   240
      Width           =   4245
   End
   Begin Label Lbl_Label 
      Caption         =   "&Y Label"
      Height          =   255
      Index           =   2
      Left            =   120
      TabIndex        =   12
      Top             =   5400
      Width           =   735
   End
   Begin Label Lbl_Label 
      Caption         =   "&X Label"
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   10
      Top             =   5040
      Width           =   855
   End
   Begin Label Lbl_Label 
      Caption         =   "&Title"
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   8
      Top             =   4680
      Width           =   735
   End
   Begin Label Lbl_Num_Pts 
      Caption         =   "&Number of Points"
      Height          =   255
      Left            =   4800
      TabIndex        =   0
      Top             =   360
      Width           =   1575
   End
End
Option Explicit
DefInt A-Z
Dim A$, I, ND, X$, Y$, XY() As XYData
Dim A1!, B1!, R2!, Exps!(), MaxX!, MaxY!
Dim MF, CalcFlag

Sub Calc ()
    ReDim XY(ND) As XYData, Exps(5)
   
    XMax = 0: YMax = 0
    For I = 1 To ND
    A$ = Lst_XY.List(I - 1)
    XY(I).X = Val(Left$(A$, 11))
    XY(I).Y = Val(Right$(A$, 11))
    If XY(I).X > XMax Then XMax = XY(I).X
    If XY(I).Y > YMax Then YMax = XY(I).Y
    Exps(1) = Log(XY(I).X) + Exps(1)
    Exps(2) = Log(XY(I).Y) + Exps(2)
    Exps(3) = Log(XY(I).X) * Log(XY(I).Y) + Exps(3)
    Exps(4) = Log(XY(I).X) ^ 2 + Exps(4)
    Exps(5) = Log(XY(I).Y) ^ 2 + Exps(5)
    Next I
    B1 = (Exps(3) - Exps(1) * Exps(2) / ND) / (Exps(4) - Exps(1) ^ 2 / ND)
    A1 = Exp(Exps(2) / ND - B1 * Exps(1) / ND)
    R2 = (Exps(3) - Exps(1) * Exps(2) / ND) ^ 2 / (Exps(4) - Exps(1) ^ 2 / ND) / (Exps(5) - Exps(2) ^ 2 / ND)
    XTic = XMax / 5
    YTic = YMax / 5
    XMin = 0
    YMin = 0
End Sub

Sub Cmd_Copy_Click (Index As Integer)
    Dim Ret, CopyMF, MP  As METAFILEPICT
    Dim CBhnd, CBAdr&
    Dim OldDC, TempDC

    CLipboard.Clear
    If Index = 0 Then
	' Create a copy of the bitmap in Pic_Graph.Image and pass it to the clipboard
	TempDC = CreateCompatibleDC(Pic_Graph.hDC)
	CBhnd = CreateCompatibleBitmap(Pic_Graph.hDC, Pic_Graph.ScaleWidth, Pic_Graph.ScaleHeight)
	OldDC = SelectObject(TempDC, CBhnd)
	Ret = BitBlt(TempDC, 0, 0, Pic_Graph.ScaleWidth, Pic_Graph.ScaleHeight, Pic_Graph.hDC, 0, 0, SRCCOPY)
	Ret = SelectObject(TempDC, OldDC)
	Ret = DeleteDC(TempDC)
	Ret = OPenClipboard(Form1.hWnd)
	Ret = SetClipBoardData(CF_BITMAP, CBhnd)
	Ret = CloseClipBoard()
    Else
	If MF = 0 Then Exit Sub
	' Create a copy of the metafile and pass it to the Clipboard
	CopyMF = CopyMetafileByNum(MF, 0)
	MP.mm = MM_ANISOTROPIC
	MP.xExt = 2000    ' Arbitrary default setting
	MP.yExt = 2000    ' Arbitrary default setting
	MP.hMF = CopyMF
	CBhnd = GlobalAlloc(GMEM_MOVEABLE, Len(MP))
	CBAdr = GlobalLock(CBhnd)
	hmemcpy CBAdr, MP, Len(MP)
	Ret = GlobalUnlock(CBhnd)
	Ret = OPenClipboard(Form1.hWnd)
	Ret = SetClipBoardData(CF_METAFILEPICT, CBhnd)
	Ret = CloseClipBoard()
    End If
End Sub

Sub Cmd_Graph_Click ()
    Dim Ret, RetL&, CMF, ShDC, SavedDC

    Pic_Graph.Cls
    If ND = 0 Then Exit Sub
    If CalcFlag Then Calc
    If MF Then Ret = DeleteMetafile(MF)
    CMF = CreateMetaFile(0)
    Pic_Graph.ScaleMode = 3
    Ret = SetMapMode(CMF, MM_ANISOTROPIC)
    RetL = SetWindowOrg(CMF, 0, 0)
    RetL = SetWindowExt(CMF, 280, 280)
    ' If you want the metafile to be a fixed size,
    ' uncomment the next two lines
    'RetL = SetViewportOrg(CMF, 0, 0)
    'RetL = SetViewportExt(CMF, 280, 280)
    ShDC = Pic_Graph.hDC
    GraphMF CMF
    MF = CloseMetaFile(CMF)
    SavedDC = SaveDC(ShDC)
    Ret = SetMapMode(ShDC, MM_ANISOTROPIC)
    RetL = SetViewportOrg(ShDC, 0, 0)
    RetL = SetViewportExt(ShDC, Pic_Graph.ScaleWidth, Pic_Graph.ScaleHeight)
    RetL = SetWindowOrg(ShDC, 0, 0)
    RetL = SetWindowExt(ShDC, Pic_Graph.ScaleWidth, Pic_Graph.ScaleHeight)
    Ret = PlayMetaFile(ShDC, MF)
    Ret = RestoreDC(ShDC, SavedDC)
    Pic_Graph.Refresh
End Sub

Sub Cmd_Print_Click ()
    Dim Ret, RetL&, SavedDC, Tp, Lft, Wdth, Hght
    
    If MF = 0 Then Exit Sub
    MousePOinter = 11
    Printer.Print " "
    Printer.ScaleMode = 3
    SavedDC = SaveDC(Printer.hDC)
    Wdth = 1200   ' Arbitrary setting
    Hght = 1200   ' Arbitrary setting
    Ret = SetMapMode(Printer.hDC, MM_ANISOTROPIC)
    Lft = (Printer.ScaleWidth - Wdth) / 2
    Tp = (Printer.ScaleHeight - Hght) / 2
    RetL = SetViewportOrg(Printer.hDC, Lft, Tp)
    RetL = SetViewportExt(Printer.hDC, Wdth, Hght)
    Ret = PlayMetaFile(Printer.hDC, MF)
    Ret = RestoreDC(Printer.hDC, SavedDC)
    Printer.EndDoc
    MousePOinter = 0
End Sub

Sub Cmd_Save_Click ()
    Dim F$, Ret, SMF

    If MF = 0 Then Exit Sub
    F$ = InputBox$("Enter file name to save metafile", "Graph")
    If F$ <> "" Then
	SMF = CopyMetaFile(MF, F$)
    End If
End Sub

Sub Cmd_Scale_Click ()
    Canc = False
    CalcFlag = False
    Scale_Frm.Show MODAL
    If Canc Then
	CalcFlag = True
	Exit Sub
    End If
    Cmd_Graph_Click
End Sub

Sub Form_Load ()
    Dim I, BU&, Hi, Lo, Ret
    Static Tabs(1 To 24)

    ' Set tab stops in Lst_XY so that data is right justified
    BU = GetDialogBaseUnits()
    Hi = BU \ (2 ^ 16)
    Lo = BU And &HFFFF&
    For I = 1 To 24
    Tabs(I) = (Lo * I) / 2
    Next I
    Ret = SendMessage(Lst_XY.hWnd, LB_SETTABSTOPS, 24, Tabs(1))
    XF$ = "########0.0"
    YF$ = "########0.0"
    XDec = 1
    YDec = 1
    CalcFlag = True
End Sub

Sub Form_Unload (Cancel As Integer)
    Dim Ret
   
    If MF Then Ret = DeleteMetafile(MF)
End Sub

Sub GraphMF (CMF)
    Dim Xo!, Yo!, X!, Y!, W!, H!, CX!, CY!, Lft!, Tp!, Rad!
    Dim Ret, RetL&, PX, PY, TW, XInc!
    Dim NewFont, OldFont, OldPen, NewPen, OldBrush, NewBrush
    Dim Brush As LOGBRUSH
    Dim FontNam$

    ' Font width at 8 point = 6, height = 13
    ' Font width at 11 point = 9, height = 16
    ' Font width at 14 point = 12, height = 24
    ' Based on 280 x 280 pixels
    ' In this scale, the stock font (MS Sans Serif) will not
    ' print sideways at less than 11 points and non-numeric
    ' text will not always print properly

    FontNam$ = ""
    NewFont = SetFont(FontNam$, 8, FW_NORMAL, 0)
    If NewFont = 0 Then Exit Sub
    OldFont = SelectObject(CMF, NewFont)
    
    ' Calculate the scale conversion
    TW = Len(Format$(YMax, YF$) & "00") * 6 ' Make room for the Y Labels
    W = 280
    Lft = TW + W * .075         ' Left region is 7.5% of window + width of Y labels
    CX = (W * .9 - Lft) / XMax  ' Graphing width is 90% of window - left region
    H = 280
    Tp = H * .15                ' Top region is 15% of window
    CY = H * .6 / YMax          ' Graphing Height is 60% of window

    ' Create a green pen and a transparent brush
    NewPen = CreatePen(BS_INSIDEFRAME, 1, GREEN)
    OldPen = SelectObject(CMF, NewPen)
    Brush.lbStyle = BS_NULL
    Brush.lbColor = 0&
    Brush.lbHatch = 0
    NewBrush = CreateBrushIndirect%(Brush)
    OldBrush = SelectObject(CMF, NewBrush)
		      
    ' Draw the vertical gridlines
    X = XMin + XTic
    Do Until X >= XMax
    Ret = MoveTo(CMF, Lft + X * CX, Tp)
    Ret = LineTo(CMF, Lft + X * CX, Tp + YMax * CY)
    X = X + XTic
    Loop

    ' Draw the horizontal gridlines
    Y = YMax - YTic
    Do Until Y <= YMin
    Ret = MoveTo(CMF, Lft, Tp + Y * CY)
    Ret = LineTo(CMF, Lft + CX * XMax, Tp + Y * CY)
    Y = Y - YTic
    Loop
    
    ' Draw a border with a black pen 2 points wide
    If NewPen Then
	Ret = SelectObject(CMF, OldPen)
	Ret = DeleteObject(NewPen)
    End If
    NewPen = CreatePen(BS_SOLID, 2, 0)
    OldPen = SelectObject(CMF, NewPen)
    Ret = Rectangle(CMF, Lft, Tp, Lft + XMax * CX + 1, Tp + YMax * CY + 1)
    If NewPen Then
	Ret = SelectObject(CMF, OldPen)
	Ret = DeleteObject(NewPen)
    End If
    ' Reset pen to 1 point
    NewPen = CreatePen(BS_SOLID, 1, 0)
    OldPen = SelectObject(CMF, NewPen)
    
    ' Draw the curve fit line
    Xo = XMin: Yo = A1 * Xo ^ B1
    XInc = XMax / 10
    For X = XMin + XInc To XMax Step XInc
    Y = A1 * X ^ B1
    If X <= XMax And Y >= YMin And Y <= YMax Then
	Ret = MoveTo(CMF, Lft + Xo * CX, Tp + (YMax - Yo) * CY)
	Ret = LineTo(CMF, Lft + X * CX, Tp + (YMax - Y) * CY)
    End If
    Xo = X: Yo = Y
    Next X

    ' Draw the data points - black circle filled with blue
    Brush.lbStyle = BS_SOLID
    Brush.lbColor = BLUE
    Brush.lbHatch = 0
    If NewBrush Then
	Ret = SelectObject(CMF, OldBrush)
	Ret = DeleteObject(NewBrush)
    End If
    NewBrush = CreateBrushIndirect%(Brush)
    OldBrush = SelectObject(CMF, NewBrush)
    Rad = ((XMax - XMin) * .01 * CX) / 2
    If Rad < 3 Then Rad = 3
    For I = 1 To ND
    If XY(I).X >= XMin And XY(I).X <= XMax And XY(I).Y >= YMin And XY(I).Y <= YMax Then
	Ret = Chord(CMF, Lft + XY(I).X * CX - Rad, Tp + (YMax - XY(I).Y) * CY - Rad, Lft + XY(I).X * CX + Rad, Tp + (YMax - XY(I).Y) * CY + Rad, Lft + XY(I).X * CX - Rad, Tp + (YMax - XY(I).Y) * CY - Rad, Lft + XY(I).X * CX - Rad, Tp + (YMax - XY(I).Y) * CY - Rad)
    End If
    Next I

    ' Delete the pen and brush
    If NewPen Then
	Ret = SelectObject(CMF, OldPen)
	Ret = DeleteObject(NewPen)
    End If
    If NewBrush Then
	Ret = SelectObject(CMF, OldBrush)
	Ret = DeleteObject(NewBrush)
    End If

    ' Label the Y axis
    Ret = SetTextAlign(CMF, TA_RIGHT)
    For Y = YMin To YMax + YTic / 2 Step YTic
    A$ = Format$(Y, YF$)
    PX = Lft - 4
    PY = Tp + (YMax - Y) * CY - 7
    Ret = TextOut(CMF, PX, PY, (A$), Len(A$)) ' Right justify 4 points to the left of the graph
    Next Y
    
    ' Label the X axis
    Ret = SetTextAlign(CMF, TA_CENTER)
    For X = XMin To XMax + XTic / 2 Step XTic
    A$ = Format$(X, XF$)
    PX = Lft + X * CX
    PY = Tp + YMax * CY + 4
    Ret = TextOut(CMF, PX, PY, (A$), Len(A$)) ' Center justify 4 points below the graph
    Next X

    ' Print the formula
    If NewFont Then
	Ret = SelectObject(CMF, OldFont)
	Ret = DeleteObject(NewFont)
    End If
    NewFont = SetFont(FontNam$, 11, FW_NORMAL, 0)
    If NewFont = 0 Then Exit Sub
    OldFont = SelectObject(CMF, NewFont)
    A$ = "Y = " & Format$(A1, "####0.0###") & " * X^" & Format$(B1, "####0.0###") & "   R = " & Format$(R2, "0.000")
    PX = W / 2
    PY = 260
    Ret = TextOut(CMF, PX, PY, (A$), Len(A$))  ' Center justify in the window close to the bottom
    
    ' Print the X axis label
    If NewFont Then
	Ret = SelectObject(CMF, OldFont)
	Ret = DeleteObject(NewFont)
    End If
    NewFont = SetFont(FontNam$, 12, FW_BOLD, 0)
    If NewFont = 0 Then Exit Sub
    OldFont = SelectObject(CMF, NewFont)
    A$ = Txt_Label(1).Text
    PX = Lft + (XMax - XMin) / 2 * CX
    PY = (280 - (Tp + YMax * CY)) / 2 + (Tp + YMax * CY) - 8
    Ret = TextOut(CMF, PX, PY, (A$), Len(A$))  ' Center justify on the graph area in the center of the bottom area
    
    ' Print the Y axis label (sideways)
    If NewFont Then
	Ret = SelectObject(CMF, OldFont)
	Ret = DeleteObject(NewFont)
    End If
    NewFont = SetFont(FontNam$, 12, FW_BOLD, 900)
    If NewFont = 0 Then Exit Sub
    OldFont = SelectObject(CMF, NewFont)
    A$ = Txt_Label(2).Text
    PX = 8
    PY = Tp + (YMax - YMin) / 2 * CY
    Ret = TextOut(CMF, PX, PY, (A$), Len(A$)) ' Center justify near the left edge of the window

    ' Print the title
    If NewFont Then
	Ret = SelectObject(CMF, OldFont)
	Ret = DeleteObject(NewFont)
    End If
    NewFont = SetFont(FontNam$, 14, FW_BOLD, 0)
    If NewFont = 0 Then Exit Sub
    OldFont = SelectObject(CMF, NewFont)
    A$ = Txt_Label(0).Text
    PX = W / 2
    PY = Tp / 2 - 12
    Ret = TextOut(CMF, PX, PY, (A$), Len(A$)) ' Center justify in the center of the top area
    If NewFont Then
	Ret = SelectObject(CMF, OldFont)
	Ret = DeleteObject(NewFont)
    End If
End Sub

Sub Lst_XY_Click ()
    A$ = Lst_XY.List(Lst_XY.ListIndex)
    If Len(A$) <> 0 Then
	Txt_XY(0).Text = Format$(Left$(A$, 11), XF$)
	Txt_XY(1).Text = Format$(Right$(A$, 10), YF$)
	Txt_XY(0).SetFocus
    End If
End Sub

Function SetFont (F$, FSize, FWght, Esc)
    Dim lf As LOGFONT
    Dim Ret, CP!

    CP = .75    ' Convert pixels to points
    lf.lfHeight = -Fix(FSize / CP)
    lf.LfWidth = 0
    lf.lfWeight = FWght
    lf.lfEscapement = Esc
    lf.lfOutPrecision = Chr$(OUT_DEFAULT_PRECIS)
    lf.lfClipPrecision = Chr$(OUT_DEFAULT_PRECIS)
    lf.lfQuality = Chr$(DEFAULT_QUALITY)
    lf.lfPitchAndFamily = Chr$(DEFAULT_PITCH Or FF_DONTCARE)
    If F$ <> "" Then lf.lfFaceName = F$ & Chr$(0)
    lf.lfCharSet = Chr$(DEFAULT_CHARSET)
    SetFont = CreateFontIndirect(lf)
End Function

Sub Txt_Label_GotFocus (Index As Integer)
    Txt_Label(Index).SelStart = 0
    Txt_Label(Index).SelLength = Len(Txt_Label(Index).Text)
End Sub

Sub Txt_Label_KeyPress (Index As Integer, KeyAscii As Integer)
    If KeyAscii = 13 And Index < 2 Then
	KeyAscii = 0
	Txt_Label(Index + 1).SetFocus
    End If
End Sub

Sub Txt_Num_Pts_Change ()
    ND = Val(Txt_Num_Pts.Text)
End Sub

Sub Txt_Num_Pts_KeyPress (KeyAscii As Integer)
    Dim NL
    
    If KeyAscii = 13 Then
	KeyAscii = 0
	NL = Lst_XY.ListCount
	If NL > ND Then
	    For I = NL To ND + 1 Step -1
	    Lst_XY.RemoveItem I - 1
	    Next I
	End If
	If ND > NL Then
	    For I = NL + 1 To ND
	    Lst_XY.AddItem ""
	    Next I
	End If
	Lst_XY.ListIndex = 0
	Txt_XY(0).SetFocus
    End If
    If KeyAscii < 48 Or KeyAscii > 57 Then KeyAscii = 0
End Sub

Sub Txt_XY_GotFocus (Index As Integer)
    Txt_XY(Index).SelStart = 0
    Txt_XY(Index).SelLength = Len(Txt_XY(Index).Text)
End Sub

Sub Txt_XY_KeyPress (Index As Integer, KeyAscii As Integer)
    Dim LI

    If KeyAscii = 13 And Index = 0 Then
	KeyAscii = 0
	Txt_XY(1).SetFocus
    End If
    If KeyAscii = 13 Then
	KeyAscii = 0
	X$ = Format$(Txt_XY(0).Text, XF$)
	X$ = String$(12 - Len(X$), Chr$(9)) & X$ & Chr$(9)
	Y$ = Format$(Txt_XY(1).Text, YF$)
	Y$ = String$(12 - Len(Y$), Chr$(9)) & Y$
	LI = Lst_XY.ListIndex
	Lst_XY.List(LI) = X$ & Y$
	If LI < ND - 1 Then Lst_XY.ListIndex = LI + 1
	Txt_XY(0).Text = ""
	Txt_XY(1).Text = ""
	Txt_XY(0).SetFocus
    End If
    If (KeyAscii < 48 Or KeyAscii > 57) And KeyAscii <> 46 And KeyAscii <> 8 Then KeyAscii = 0
End Sub

