''
'' Cz Software Corporation
'' 7276 NE 122nd Street
'' Kirkland, WA 98034
''
'' Copyright (C) 1994.
'' This software is subject to copyright protection under the laws of
'' the United States and other countries.
''

' CANZ.BAS - Containers for Visual Basic
'
' Visual Basic Declarations - See CANZ.HLP for a description of
' these functions and structures.
'
' This file must match the CANZ.VBX declarations. Do not edit!!!
'

'
' Registartion data and functions
' Apps must register before using CANZ routines
'

Global Const CZ_MAJOR_REV = 1
Global Const CZ_MINOR_REV = 2

Type CzRegData
    ' Required by CzRegisterInstance
    iTestedMajor As Integer              ' developed interface version
    iTestedMinor As Integer
	
    iLanguage As Integer                 ' VB 3.0 = 1
    iDebugLevel As Integer               ' none = 0; check parameters = 100
    iErrorCode As Integer                ' error number to use
	
    ' Returned from CzRegisterInstance
    iEarliestMajor As Integer            ' earliest interface version supported by this DLL
    iEarliestMinor As Integer
    iCurrentMajor As Integer             ' current interface version of this DLL
    iCurrentMinor As Integer
    
    ' Private data for internal use only
    pCzNull As Long
    ilastError As Integer
End Type

Type CzNullData
    nullValue As Long
End Type
Global CzNull As CzNullData


'
' Constants for use with hCzFind functions (iCompareType)
'
Global Const CZ_EQ = 0   'Find item =  test item
Global Const CZ_LT = -1  'Find item <  test item
Global Const CZ_LE = -2  'Find item <= test item
Global Const CZ_GT = 1   'Find item >  test item
Global Const CZ_GE = 2   'Find item >= test item

'
' Initialization Methods
'
Declare Sub CzRegisterTask Lib "canzdemo.vbx" (regData As CzRegData, cznul As CzNullData)
Declare Sub CzUnRegisterTask Lib "canzdemo.vbx" ()
'
' Generic Collection Methods
'
Declare Function hCzAdd Lib "canzdemo.vbx" (ByVal hCollection As Long, userData As Any) As Long
Declare Sub CzChangeKey Lib "canzdemo.vbx" (ByVal hCollection As Long, ByVal sKey As String)
Declare Function iCzCompareCur Lib "canzdemo.vbx" (ByVal hCollection As Long, testData As Any) As Integer
Declare Function lCzCount Lib "canzdemo.vbx" (ByVal hCollection As Long) As Long
Declare Function hCzCur Lib "canzdemo.vbx" (ByVal hCollection As Long, returnData As Any) As Long
Declare Function bCzCurIsValid Lib "canzdemo.vbx" (ByVal hCollection As Long) As Integer
Declare Sub CzExchangeData Lib "canzdemo.vbx" (ByVal hCollection1 As Long, ByVal hItem1 As Long, ByVal hCollection2 As Long, ByVal hItem2 As Long)
Declare Function hCzFindByNickname Lib "canzdemo.vbx" (ByVal sNickname As String) As Long
Declare Function hCzFindFirst Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hCollection As Long, testData As Any, returnData As Any) As Long
Declare Function hCzFindNext Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hCollection As Long, testData As Any, returnData As Any) As Long
Declare Function hCzFirst Lib "canzdemo.vbx" (ByVal hCollection As Long, returnData As Any) As Long
Declare Function bCzIsEmpty Lib "canzdemo.vbx" (ByVal hCollection As Long) As Integer
Declare Function hCzLast Lib "canzdemo.vbx" (ByVal hCollection As Long, returnData As Any) As Long
Declare Function iCzLastError Lib "canzdemo.vbx" () As Integer
Declare Function hCzNext Lib "canzdemo.vbx" (ByVal hCollection As Long, returnData As Any) As Long
Declare Function hCzPrev Lib "canzdemo.vbx" (ByVal hCollection As Long, returnData As Any) As Long
Declare Sub CzRemoveAll Lib "canzdemo.vbx" (ByVal hCollection As Long)
Declare Sub CzRemoveCur Lib "canzdemo.vbx" (ByVal hCollection As Long, returnData As Any)
Declare Sub CzRemoveFirst Lib "canzdemo.vbx" (ByVal hCollection As Long, returnData As Any)
Declare Sub CzRemoveLast Lib "canzdemo.vbx" (ByVal hCollection As Long, returnData As Any)
Declare Sub CzResetCur Lib "canzdemo.vbx" (ByVal hCollection As Long)
Declare Sub CzSetCur Lib "canzdemo.vbx" (ByVal hCollection As Long, ByVal hItem As Long)
Declare Sub CzSetNickname Lib "canzdemo.vbx" (ByVal hCollection As Long, ByVal sNickname As String)
Declare Sub CzSort Lib "canzdemo.vbx" (ByVal hCollection As Long)
'
' Generic Iterator Methods
'
Declare Function hCzIterCollection Lib "canzdemo.vbx" (ByVal hIterator As Long) As Long
Declare Function iCzIterCompareCur Lib "canzdemo.vbx" (ByVal hIterator As Long, testData As Any) As Integer
Declare Function hCzIterCur Lib "canzdemo.vbx" (ByVal hIterator As Long, returnData As Any) As Long
Declare Function bCzIterCurIsValid Lib "canzdemo.vbx" (ByVal hIterator As Long) As Integer
Declare Function hCzIterFindFirst Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hIterator As Long, testData As Any, returnData As Any) As Long
Declare Function hCzIterFindNext Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hIterator As Long, testData As Any, returnData As Any) As Long
Declare Function hCzIterFirst Lib "canzdemo.vbx" (ByVal hIterator As Long, returnData As Any) As Long
Declare Function hCzIterLast Lib "canzdemo.vbx" (ByVal hIterator As Long, returnData As Any) As Long
Declare Function hCzIterNext Lib "canzdemo.vbx" (ByVal hIterator As Long, returnData As Any) As Long
Declare Function hCzIterPrev Lib "canzdemo.vbx" (ByVal hIterator As Long, returnData As Any) As Long
Declare Sub CzIterRemoveCur Lib "canzdemo.vbx" (ByVal hIterator As Long, returnData As Any)
Declare Sub CzIterResetCur Lib "canzdemo.vbx" (ByVal hIterator As Long)
Declare Sub CzIterSetCur Lib "canzdemo.vbx" (ByVal hIterator As Long, ByVal hItem As Long)
'
' List Methods
'
Declare Function hCzListAdd Lib "canzdemo.vbx" (ByVal hList As Long, userData As Any) As Long
Declare Sub CzListChangeKey Lib "canzdemo.vbx" (ByVal hList As Long, ByVal sKey As String)
Declare Function iCzListCompareCur Lib "canzdemo.vbx" (ByVal hList As Long, testData As Any) As Integer
Declare Function lCzListCount Lib "canzdemo.vbx" (ByVal hList As Long) As Long
Declare Function hCzListCreate Lib "canzdemo.vbx" (ByVal sLayout As String, ByVal sKey As String, ByVal lFlags As Long) As Long
Declare Function hCzListCur Lib "canzdemo.vbx" (ByVal hList As Long, returnData As Any) As Long
Declare Function bCzListCurIsValid Lib "canzdemo.vbx" (ByVal hList As Long) As Integer
Declare Sub CzListDestroy Lib "canzdemo.vbx" (ByVal hList As Long)
Declare Function hCzListFindFirst Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hList As Long, testData As Any, returnData As Any) As Long
Declare Function hCzListFindNext Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hList As Long, testData As Any, returnData As Any) As Long
Declare Function hCzListFirst Lib "canzdemo.vbx" (ByVal hList As Long, returnData As Any) As Long
Declare Function hCzListInsert Lib "canzdemo.vbx" (ByVal hList As Long, userData As Any) As Long
Declare Function bCzListIsEmpty Lib "canzdemo.vbx" (ByVal hList As Long) As Integer
Declare Function hCzListLast Lib "canzdemo.vbx" (ByVal hList As Long, returnData As Any) As Long
Declare Sub CzListMakeFirst Lib "canzdemo.vbx" (ByVal hList As Long)
Declare Sub CzListMakeLast Lib "canzdemo.vbx" (ByVal hList As Long)
Declare Function hCzListNext Lib "canzdemo.vbx" (ByVal hList As Long, returnData As Any) As Long
Declare Function hCzListPrev Lib "canzdemo.vbx" (ByVal hList As Long, returnData As Any) As Long
Declare Sub CzListRemoveAll Lib "canzdemo.vbx" (ByVal hList As Long)
Declare Sub CzListRemoveCur Lib "canzdemo.vbx" (ByVal hList As Long, returnData As Any)
Declare Sub CzListRemoveFirst Lib "canzdemo.vbx" (ByVal hList As Long, returnData As Any)
Declare Sub CzListRemoveLast Lib "canzdemo.vbx" (ByVal hList As Long, returnData As Any)
Declare Sub CzListResetCur Lib "canzdemo.vbx" (ByVal hList As Long)
Declare Sub CzListSetCur Lib "canzdemo.vbx" (ByVal hList As Long, ByVal hItem As Long)
Declare Sub CzListSort Lib "canzdemo.vbx" (ByVal hList As Long)
'
' List Iterator Methods
'
Declare Function iCzListIterCompareCur Lib "canzdemo.vbx" (ByVal hListIterator As Long, testData As Any) As Integer
Declare Function hCzListIterCreate Lib "canzdemo.vbx" (ByVal hList As Long) As Long
Declare Function hCzListIterCur Lib "canzdemo.vbx" (ByVal hListIterator As Long, returnData As Any) As Long
Declare Function bCzListIterCurIsValid Lib "canzdemo.vbx" (ByVal hListIterator As Long) As Integer
Declare Sub CzListIterDestroy Lib "canzdemo.vbx" (ByVal hListIterator As Long)
Declare Function hCzListIterFindFirst Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hListIterator As Long, testData As Any, returnData As Any) As Long
Declare Function hCzListIterFindNext Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hListIterator As Long, testData As Any, returnData As Any) As Long
Declare Function hCzListIterFirst Lib "canzdemo.vbx" (ByVal hListIterator As Long, returnData As Any) As Long
Declare Function hCzListIterInsert Lib "canzdemo.vbx" (ByVal hListIterator As Long, userData As Any) As Long
Declare Function hCzListIterLast Lib "canzdemo.vbx" (ByVal hListIterator As Long, returnData As Any) As Long
Declare Function hCzListIterList Lib "canzdemo.vbx" (ByVal hListIterator As Long) As Long
Declare Sub CzListIterMakeFirst Lib "canzdemo.vbx" (ByVal hListIterator As Long)
Declare Sub CzListIterMakeLast Lib "canzdemo.vbx" (ByVal hListIterator As Long)
Declare Function hCzListIterNext Lib "canzdemo.vbx" (ByVal hListIterator As Long, returnData As Any) As Long
Declare Function hCzListIterPrev Lib "canzdemo.vbx" (ByVal hListIterator As Long, returnData As Any) As Long
Declare Sub CzListIterRemoveCur Lib "canzdemo.vbx" (ByVal hListIterator As Long, returnData As Any)
Declare Sub CzListIterResetCur Lib "canzdemo.vbx" (ByVal hListIterator As Long)
Declare Sub CzListIterSetCur Lib "canzdemo.vbx" (ByVal hListIterator As Long, ByVal hItem As Long)
'
' Queue Methods
'
Declare Function iCzQueueCompareFirst Lib "canzdemo.vbx" (ByVal hQueue As Long, testData As Any) As Integer
Declare Function lCzQueueCount Lib "canzdemo.vbx" (ByVal hQueue As Long) As Long
Declare Function hCzQueueCreate Lib "canzdemo.vbx" (ByVal sLayout As String, ByVal sKey As String, ByVal lFlags As Long) As Long
Declare Sub CzQueueDestroy Lib "canzdemo.vbx" (ByVal hQueue As Long)
Declare Sub CzQueueFirst Lib "canzdemo.vbx" (ByVal hQueue As Long, returnData As Any)
Declare Function bCzQueueIsEmpty Lib "canzdemo.vbx" (ByVal hQueue As Long) As Integer
Declare Sub CzQueuePop Lib "canzdemo.vbx" (ByVal hQueue As Long, returnData As Any)
Declare Sub CzQueuePush Lib "canzdemo.vbx" (ByVal hQueue As Long, userData As Any)
Declare Sub CzQueueRemoveAll Lib "canzdemo.vbx" (ByVal hQueue As Long)
'
' Stack Methods
'
Declare Function iCzStackCompareFirst Lib "canzdemo.vbx" (ByVal hStack As Long, testData As Any) As Integer
Declare Function lCzStackCount Lib "canzdemo.vbx" (ByVal hStack As Long) As Long
Declare Function hCzStackCreate Lib "canzdemo.vbx" (ByVal sLayout As String, ByVal sKey As String, ByVal lFlags As Long) As Long
Declare Sub CzStackDestroy Lib "canzdemo.vbx" (ByVal hStack As Long)
Declare Sub CzStackFirst Lib "canzdemo.vbx" (ByVal hStack As Long, returnData As Any)
Declare Function bCzStackIsEmpty Lib "canzdemo.vbx" (ByVal hStack As Long) As Integer
Declare Sub CzStackPop Lib "canzdemo.vbx" (ByVal hStack As Long, returnData As Any)
Declare Sub CzStackPush Lib "canzdemo.vbx" (ByVal hStack As Long, userData As Any)
Declare Sub CzStackRemoveAll Lib "canzdemo.vbx" (ByVal hStack As Long)
'
' Tree Methods
'
Declare Function hCzTreeAdd Lib "canzdemo.vbx" (ByVal hTree As Long, userData As Any) As Long
Declare Sub CzTreeChangeKey Lib "canzdemo.vbx" (ByVal hTree As Long, ByVal sKey As String)
Declare Function iCzTreeCompareCur Lib "canzdemo.vbx" (ByVal hTree As Long, testData As Any) As Integer
Declare Function lCzTreeCount Lib "canzdemo.vbx" (ByVal hTree As Long) As Long
Declare Function hCzTreeCreate Lib "canzdemo.vbx" (ByVal sLayout As String, ByVal sKey As String, ByVal lFlags As Long) As Long
Declare Function hCzIndexCreate Lib "canzdemo.vbx" (ByVal hTree As Long, ByVal sKey As String) As Long
Declare Function hCzTreeCur Lib "canzdemo.vbx" (ByVal hTree As Long, returnData As Any) As Long
Declare Function bCzTreeCurIsValid Lib "canzdemo.vbx" (ByVal hTree As Long) As Integer
Declare Sub CzTreeDestroy Lib "canzdemo.vbx" (ByVal hTree As Long)
Declare Function hCzTreeFindFirst Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hTree As Long, testData As Any, returnData As Any) As Long
Declare Function hCzTreeFindNext Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hTree As Long, testData As Any, returnData As Any) As Long
Declare Function hCzTreeFirst Lib "canzdemo.vbx" (ByVal hTree As Long, returnData As Any) As Long
Declare Function bCzTreeIsEmpty Lib "canzdemo.vbx" (ByVal hTree As Long) As Integer
Declare Function hCzTreeLast Lib "canzdemo.vbx" (ByVal hTree As Long, returnData As Any) As Long
Declare Function hCzTreeNext Lib "canzdemo.vbx" (ByVal hTree As Long, returnData As Any) As Long
Declare Function hCzTreePrev Lib "canzdemo.vbx" (ByVal hTree As Long, returnData As Any) As Long
Declare Sub CzTreeRemoveAll Lib "canzdemo.vbx" (ByVal hTree As Long)
Declare Sub CzTreeRemoveCur Lib "canzdemo.vbx" (ByVal hTree As Long, returnData As Any)
Declare Sub CzTreeRemoveFirst Lib "canzdemo.vbx" (ByVal hTree As Long, returnData As Any)
Declare Sub CzTreeRemoveLast Lib "canzdemo.vbx" (ByVal hTree As Long, returnData As Any)
Declare Sub CzTreeResetCur Lib "canzdemo.vbx" (ByVal hTree As Long)
Declare Sub CzTreeSetCur Lib "canzdemo.vbx" (ByVal hTree As Long, ByVal hItem As Long)
'
' Tree Iterator Methods
'
Declare Function iCzTreeIterCompareCur Lib "canzdemo.vbx" (ByVal hTreeIterator As Long, testData As Any) As Integer
Declare Function hCzTreeIterCreate Lib "canzdemo.vbx" (ByVal hTree As Long) As Long
Declare Function hCzTreeIterCur Lib "canzdemo.vbx" (ByVal hTreeIterator As Long, returnData As Any) As Long
Declare Function bCzTreeIterCurIsValid Lib "canzdemo.vbx" (ByVal hTreeIterator As Long) As Integer
Declare Sub CzTreeIterDestroy Lib "canzdemo.vbx" (ByVal hTreeIterator As Long)
Declare Function hCzTreeIterFindFirst Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hTreeIterator As Long, testData As Any, returnData As Any) As Long
Declare Function hCzTreeIterFindNext Lib "canzdemo.vbx" (ByVal iCompareType As Integer, ByVal hTreeIterator As Long, testData As Any, returnData As Any) As Long
Declare Function hCzTreeIterFirst Lib "canzdemo.vbx" (ByVal hTreeIterator As Long, returnData As Any) As Long
Declare Function hCzTreeIterLast Lib "canzdemo.vbx" (ByVal hTreeIterator As Long, returnData As Any) As Long
Declare Function hCzTreeIterNext Lib "canzdemo.vbx" (ByVal hTreeIterator As Long, returnData As Any) As Long
Declare Function hCzTreeIterPrev Lib "canzdemo.vbx" (ByVal hTreeIterator As Long, returnData As Any) As Long
Declare Sub CzTreeIterRemoveCur Lib "canzdemo.vbx" (ByVal hTreeIterator As Long, returnData As Any)
Declare Sub CzTreeIterResetCur Lib "canzdemo.vbx" (ByVal hTreeIterator As Long)
Declare Sub CzTreeIterSetCur Lib "canzdemo.vbx" (ByVal hTreeIterator As Long, ByVal hItem As Long)
Declare Function hCzTreeIterTree Lib "canzdemo.vbx" (ByVal hTreeIterator As Long) As Long

