VERSION 2.00
Begin Form Aclock 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Analog Clock"
   ClientHeight    =   0
   ClientLeft      =   1095
   ClientTop       =   1500
   ClientWidth     =   2160
   Height          =   405
   Icon            =   ACLOCK.FRX:0000
   Left            =   1035
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   0
   ScaleWidth      =   2160
   Top             =   1155
   Width           =   2280
   WindowState     =   1  'Minimized
   Begin Timer Timer1 
      Interval        =   500
      Left            =   5640
      Top             =   3000
   End
End
Dim LastHour As Integer
Dim LastMinute As Integer
Dim LastSecond As Integer

Sub Form_Load ()
    Me.Left = -5000
    Me.Top = -5000
    Me.WindowState = 1

    RemoveSysMenuItem Me, 8
    RemoveSysMenuItem Me, 7
End Sub

Sub Form_Resize ()
    If Me.WindowState <> 1 Then Me.WindowState = 1
End Sub

Sub Timer1_Timer ()
    If Me.WindowState <> 1 Then Exit Sub
        Me.Scale (-2, -2)-(2, 2)
        Static OldHx, OldHy, OldMx, OldMy, OldSx, OldSy
        OldDrawWidth = Me.DrawWidth
        OldScaleWidth = Me.ScaleWidth
        Hlen = .6: Mlen = .8: Slen = .9
        Pi = 4 * Atn(1)
        TwoPi = Pi + Pi
        HalfPi = Pi / 2

        If Second(Now) = LastSecond Then
            Exit Sub
        Else
            LastSecond = Second(Now)
            LastMinute = Minute(Now)
            LastHour = Hour(Now)
        End If
        Hnum = Hour(Now)
        Mnum = Minute(Now)
        Snum = Second(Now)
    
        Hang = TwoPi * (Hnum + Mnum / 60) / 12 - HalfPi
        Mang = TwoPi * (Mnum + Snum / 60) / 60 - HalfPi
        Sang = TwoPi * Snum / 60 - HalfPi
        Hx = Hlen * Cos(Hang)
        Hy = Hlen * Sin(Hang)
        Mx = Mlen * Cos(Mang)
        My = Mlen * Sin(Mang)
        Sx = Slen * Cos(Sang)
        Sy = Slen * Sin(Sang)
    
        If LastHour <> Hour(Now) Then
            DrawWidth = 4
            Line (0, 0)-(OldHx, OldHy), QBColor(15)
            End If
        If LastMinute <> Minute(Now) Then
            DrawWidth = 4
            Line (0, 0)-(OldMx, OldMy), QBColor(15)
            End If
        DrawWidth = 2
        Line (0, 0)-(Hx, Hy), QBColor(0)
        DrawWidth = 2
        Line (0, 0)-(Mx, My), QBColor(8)
        Line (0, 0)-(OldSx, OldSy), QBColor(15)
        DrawWidth = 1
        Line (0, 0)-(Sx, Sy), QBColor(12)
        
        OldHx = Hx: OldHy = Hy
        OldMx = Mx: OldMy = My
        OldSx = Sx: OldSy = Sy
        Me.Scale
        Me.DrawWidth = OldDrawWidth
        Me.ScaleWidth = OldScaleWidth
End Sub

