Option Explicit

'---asc2mdb converter
'---standard application globals

Dim c$              'receives currency str, e.g. "$"
Dim M$              'receives thousands str, e.g. ","
    
Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer

Global ReplaceMode As Integer
'     ReplaceMode is initialized in project .BAS file,
'     Sub SetupSpecifics.  Can't be a constant, since
'     it can be changed at runtime with radio button.

Global ReplaceModes() As String
'strings to describe each replace mode

Global ProgramEdit As Integer ' boolean to distinguish
        'betw user click and program induced click

Global thisDb As database   'global may be overridden
    
Global Ans              'response to message box

Global NL As String

Global gbErrorLimit     'sets limit for error reporting

Type IOFieldType
    dbName As String
    dbSize As Long
    dbType As Integer
    inStart As Integer
    inLength As Integer
    value As Variant
End Type

Type IndexPtrnType
    Name As String
    Fields As String
    Primary As Integer
    Unique As Integer
End Type

Global gIOFld() As IOFieldType      'input fields defined above
Global gIndexPtrn() As IndexPtrnType

Global gTabOut As table
Global gRunning As Integer


'File Open/Save Dialog Flags
Global Const OFN_READONLY = &H1&
Global Const OFN_OVERWRITEPROMPT = &H2&
Global Const OFN_HIDEREADONLY = &H4&
Global Const OFN_NOCHANGEDIR = &H8&
Global Const OFN_SHOWHELP = &H10&
Global Const OFN_NOVALIDATE = &H100&
Global Const OFN_ALLOWMULTISELECT = &H200&
Global Const OFN_EXTENSIONDIFFERENT = &H400&
Global Const OFN_PATHMUSTEXIST = &H800&
Global Const OFN_FILEMUSTEXIST = &H1000&
Global Const OFN_CREATEPROMPT = &H2000&
Global Const OFN_SHAREAWARE = &H4000&
Global Const OFN_NOREADONLYRETURN = &H8000&

Global Const KEY_RETURN = &HD


'
' Data Access constants
'

' Option argument values (CreateDynaset, etc)
Global Const DB_DENYWRITE = &H1
Global Const DB_DENYREAD = &H2
Global Const DB_READONLY = &H4
Global Const DB_APPENDONLY = &H8
Global Const DB_INCONSISTENT = &H10
Global Const DB_CONSISTENT = &H20
Global Const DB_SQLPASSTHROUGH = &H40

' SetDataAccessOption
Global Const DB_OPTIONINIPATH = 1

' Field Attributes
Global Const DB_FIXEDFIELD = &H1
Global Const DB_VARIABLEFIELD = &H2
Global Const DB_AUTOINCRFIELD = &H10
Global Const DB_UPDATABLEFIELD = &H20

' Field Data Types
Global Const DB_BOOLEAN = 1
Global Const DB_BYTE = 2
Global Const DB_INTEGER = 3
Global Const DB_LONG = 4
Global Const DB_CURRENCY = 5
Global Const DB_SINGLE = 6
Global Const DB_DOUBLE = 7
Global Const DB_DATE = 8
Global Const DB_TEXT = 10
Global Const DB_LONGBINARY = 11
Global Const DB_MEMO = 12

' TableDef Attributes
Global Const DB_ATTACHEXCLUSIVE = &H10000
Global Const DB_ATTACHSAVEPWD = &H20000
Global Const DB_SYSTEMOBJECT = &H80000002
Global Const DB_ATTACHEDTABLE = &H40000000
Global Const DB_ATTACHEDODBC = &H20000000

' ListTables TableType
Global Const DB_TABLE = 1
Global Const DB_QUERYDEF = 5

' ListTables Attributes (for QueryDefs)
Global Const DB_QACTION = &HF0
Global Const DB_QCROSSTAB = &H10
Global Const DB_QDELETE = &H20
Global Const DB_QUPDATE = &H30
Global Const DB_QAPPEND = &H40
Global Const DB_QMAKETABLE = &H50

' ListIndexes IndexAttributes values
Global Const DB_UNIQUE = 1
Global Const DB_PRIMARY = 2
Global Const DB_PROHIBITNULL = 4
Global Const DB_IGNORENULL = 8
' ListIndexes FieldAttributes value
Global Const DB_DESCENDING = 1  'For each field in Index

' CreateDatabase and CompactDatabase Language constants
Global Const DB_LANG_GENERAL = ";LANGID=0x0809;CP=1252;COUNTRY=0"
Global Const DB_LANG_SPANISH = ";LANGID=0x040A;CP=1252;COUNTRY=0"
Global Const DB_LANG_DUTCH = ";LANGID=0x0413;CP=1252;COUNTRY=0"
Global Const DB_LANG_SWEDFIN = ";LANGID=0x040C;CP=1252;COUNTRY=0"   'VB3 and Access 1.1 Databases
Global Const DB_LANG_NORWDAN = ";LANGID=0x0414;CP=1252;COUNTRY=0"   'VB3 and Access 1.1 Databases
Global Const DB_LANG_ICELANDIC = ";LANGID=0x040F;CP=1252;COUNTRY=0" 'VB3 and Access 1.1 Databases
Global Const DB_LANG_NORDIC = ";LANGID=0x041D;CP=1252;COUNTRY=0"    'Access 1.0 Databases only

' CreateDatabase and CompactDatabase options
Global Const DB_VERSION10 = 1        ' Microsoft Access Version 1.0
Global Const DB_ENCRYPT = 2          ' Make database encrypted.
Global Const DB_DECRYPT = 4          ' Decrypt database while compacting.

'Collating order values
Global Const DB_SORTGENERAL = 256    ' Sort by EFGPI rules (English, French, German,Portuguese, Italian)
Global Const DB_SORTSPANISH = 258    ' Sort by Spanish rules
Global Const DB_SORTDUTCH = 259      ' Sort by Dutch rules
Global Const DB_SORTSWEDFIN = 260    ' Sort by Swedish, Finnish rules
Global Const DB_SORTNORWDAN = 261    ' Sort by Norwegian, Danish rules
Global Const DB_SORTICELANDIC = 262  ' Sort by Icelandic rules
Global Const DB_SORTPDXINTL = 4096   ' Sort by Paradox international rules
Global Const DB_SORTPDXSWE = 4097    ' Sort by Paradox Swedish, Finnish rules
Global Const DB_SORTPDXNOR = 4098    ' Sort by Paradox Norwegian, Danish rules
Global Const DB_SORTUNDEFINED = -1   ' Sort rules are undefined or unknown

' Function Parameters
' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default
Global Const MB_SYSTEMMODAL = 4096      'System Modal

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

Sub GlobalInit ()
    SvcCurrProfile c$, M$
    ReplaceModeTextStrings
    gbErrorLimit = 50
End Sub

Sub ReplaceModeTextStrings ()
  ReDim ReplaceModes(0 To 5)

  ReplaceModes(0) = "&0- Delete old db; recreate db and table"
  ReplaceModes(1) = "&1- Keep old db; recreate the table"
  ReplaceModes(2) = "&2- Keep old db; add new records to table"
  ReplaceModes(3) = "&3- Mass delete and add per input criteria"
  ReplaceModes(4) = "&4- Individual record replace; if nomatch, add new"
  ReplaceModes(5) = "&5- Field Update; if nomatch; log an error"

End Sub

Private Sub SvcCurrProfile (c$, M$)
    ' get the win.ini defaults for
    ' C$ currency symbol (def "$")
    ' M$ thousands separator (def ",")
    
    ' api call stuff
    
    Const App$ = "intl"
    
    Const CKey$ = "sCurrency"
    Const CDef$ = "Y"
    Dim CBuf$           'return buffer for C$
    CBuf$ = Space$(128)
    Dim CLen%
    CLen% = Len(CBuf$)
    
    Const MKey$ = "sThousand"
    Const MDef$ = "."
    Dim MBuf$           'return buffer for M$
    MBuf$ = Space$(128)
    Dim MLen%
    MLen% = Len(MBuf$)
    
    Dim ret%

    ret% = GetProfileString(App$, CKey$, CDef$, CBuf$, CLen%)
    c$ = Left$(CBuf$, ret%)
    
    ret% = GetProfileString(App$, MKey$, MDef$, MBuf$, MLen%)
    M$ = Left$(MBuf$, ret%)
    
End Sub

Function SvcCurrStrip (Strng)
    ' Strng is a formatted currency string with possible
    ' "$" and "," characters embedded.
    ' This service function will change this reference
    ' to pure numbers (no change of decimals).

    Dim Ind As Integer
    Dim iMarker As Integer
    Dim Lim As Integer

    Lim = Len(Strng)
    
    Do
        iMarker = InStr(Strng, c$)
        If iMarker = 0 Then Exit Do
        Strng = Left(Strng, iMarker - 1) & Mid(Strng, iMarker + 1, Len(Strng))
    Loop
        
    Do
        iMarker = InStr(Strng, M$)
        If iMarker = 0 Then Exit Do
        Strng = Left(Strng, iMarker - 1) & Mid(Strng, iMarker + 1, Len(Strng))
    Loop

    iMarker = InStr(Strng, "(")
    If Not iMarker = 0 Then
        'replace opening negative sign with a minus
        Mid(Strng, iMarker, 1) = "-"
    End If

    iMarker = InStr(Strng, ")")
    If Not iMarker = 0 Then
        Strng = Left(Strng, iMarker - 1) & Mid(Strng, iMarker + 1, Len(Strng))
    End If

    ' get rid of spaces
    Do
        iMarker = InStr(Strng, " ")
        If iMarker = 0 Then Exit Do
        Strng = Left(Strng, iMarker - 1) & Mid(Strng, iMarker + 1, Len(Strng))
    Loop

    SvcCurrStrip = Strng & String$(Lim - Len(Strng), 32)
End Function

