#ifndef _MBMDEFS_  

#define _MBMDEFS_

#include <windows.h>
									// Error Messages
#define   db_OK                    0 
#define   db_ErrExists             1
#define   db_ErrNotExists          2 
#define   db_TooManyFields         3 
#define   db_NoMemAvail            4 
#define   db_FileNotFound          5
#define   db_ReadError             6 
#define   db_WriteError            7 
#define   db_RecSizeError          8 
#define   db_NbRecError            9 
#define   db_DynRecError          10   // Returned when Nil Pointer found in the list
#define   db_OPNAError            11   // Operation Not Admited
#define   db_ErrNotNumber         12   // STRINGxxx/BUFBYTExxx : xxx Not a umber
#define   db_ErrUnknownTable      13   
#define   db_ErrRecTooFar         18   
#define   db_ErrTableClosed       19   

   //----------------------------------------------------------
   // Consult Errors           Argument passed to ConsultError
   //----------------------------------------------------------
#define   db_FieldSizeError       48   // GetField/SetField<>tableSize
#define   db_ErrUnknownType       34   // Unknown type used
#define   db_ErrFieldCount        30   

#define   MaxFields      		  2500   // maximum number of fields in a table record



typedef   LPSTR PList;    
struct    TList 
					{
					LPSTR Elt ;
      			PList Next;
					};



typedef   int                ErrType;  

typedef   char 		        String12[13]    ;      
typedef   char 		        String20[21]    ;      
typedef   char		        String30[31]    ;
typedef   char		        String40[41]    ;
typedef   char		        String60[61]    ;
typedef   char		        String80[81]    ;

typedef   String80           PathStr     ;

typedef   String20           TableString ;
typedef   String20           FieldString ;
typedef   String20           ParamString ;
typedef   String30           PredString  ;
typedef   String20           TypeString  ;
typedef   String80           FileString  ;
typedef   String40           EPString    ;
typedef   String20           OwnerString ;   


typedef   TypeString         TStrArray[MaxFields];
typedef   LPSTR 	           PStrArray;      

typedef   DWORD              TLongArray[MaxFields];
typedef   LPSTR              PLongArray;
		         

//typedef 	 int                TIntArray[MaxFields];
typedef   LPSTR              PIntArray; 
                                       
typedef   char					  TypeChar[21];	                                       
typedef   TypeChar			  TCharArray[MaxFields];
typedef   TypeChar far *         PCharArray;


                                // Table Flags
#define   fg_Static                0         // fg_Nous + fg_Memoire + fg_Static + fg_ReadWrite
#define   fg_Disk                  2         // fg_Memoire
#define   fg_Dynamic               4         // fg_Statique

                           // Modes for OpenFile
#define   md_Closed                0 
#define   md_Consult               1 
#define   md_Create                2  
#define   md_ReadWrite             4 

                           // Modes for AddRecord
#define   md_BEGINNING             1 
#define   md_END                   2
#define   md_SORTED                4

             // Flags for king of sort in a table
#define   NoSort                   0 
#define   AscendantSort            1 
#define   DescendantSort           2 


struct    TTable
{
      		 unsigned short Version;     // compiling version of the table
      		 LPSTR IdTable;  // a table is known by its string identifier - Used to be PSTRING
      		 
      		 LPSTR DataFile; // a table may be stored in a data file - Used to be PSTRING
		                         // rem : the full path should be given
		       int Flags;        // defines the type of the table :

                           //   ---------------------------------------
                           //   MEMORY  : fully in memory
                           //     the table is loaded in memory from
                           //     DataFile and stored in DataFile when
                           //     closed
									//     if Datafile is NIL, the table may be
                           //     used as a temporary table
                           //   DISK    : fully stored on disk with
                           //             buffered access
                           //     the table is never fully in memory
                           //     (a record one by one or buffered)
									//   ---------------------------------------
                           //   STATIC  :
                           //     a table opened in CONSULT mode can not
                           //     increase itself with more elements
                           //   DYNAMIC :
                           //     the number of records may change
                           //     during execution
                           //   ---------------------------------------
                           //   READONLY :
                           //     a table opened in CONSULT mode can not
                           //     modify its records
                           //   READWRITE :
                           //     a table opened in CONSULT mode can
                           //     modify its records
                           //   ---------------------------------------
             int NbFields;  //  number of fields in each record

             LPSTR Fields;     //  name of each field in a record
             LPSTR Types;      //  type of each field in a record :
             
                           //    String       Size in memory
                           //    ------       --------------
									//     BYTE             1
                           //     SHORTINT         1
                           //     CHAR             1
                           //     unsigned short             2
                           //     INTEGER          2
                           //     LONGINT          4
                           //     REAL             6
                           //     STRINGxxx    xxx + 1
                           //     BUFFBYTExxx    xxx
             PLongArray Offsets;   //  Offset from the beginning of the record
                                   //  for each field
             unsigned short MaxRecs;  //  number max of record allowed for a table
                            //    $FFFF for a DYNAMIC table

             unsigned short RecSize;  //  size of a record
             unsigned short Current;  //  current record accessed
				 unsigned short NbRecs;   //  number of records in the table
 
             unsigned short Handle;   //  Handle to allocated memory (static)
             LPSTR DataPtr;  //  Pointer to allocated memory (dynamic)
             unsigned char Modified; //  Flag to set when table contents change
             char OpenStatus;  //  Open status: (os_CLOSED, os_CREATE,
										 //                os_CONSULT

             long Limits;      //
             LPSTR Extra;       //  Pointer to Extra Data Record
             unsigned short XREFInc;     //  Increment for XREF Chk
             BYTE SortFlag;    //  Sort's type flag
                            //  NoSort           0
                            //  AscendantSort    1
                            //  DescendantSort   2
             BYTE CloseFlag;   //  NOT USED RESERVED
             BYTE DefaultFlag; // if DefaultFlag then default values are
                               // stored in record 0
             unsigned short NumFldSort;  //Number of primary fields on which the
                               //table is sorted

             unsigned short ModifiedRec; //The record number which was modified
				 unsigned short Unique;      //If there is a Uniqe Field in the record
				 unsigned short TableType;    //Type of the table
									 //DB      0
									 //DBSYS   2   Base
				 LPSTR Owner;     //the owner of the table
				 PIntArray VarSize;  //  Size of Variable
				};

typedef   TTable far * PTable;

#endif
